/**
 *
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/7/18/9:28  Copyright gtmap Corp
 */

define([
    'global/core/EventBus',
    'knockout',
    'jquery',
    'mustache',
    'Cesium',
    'global/core/index',
    "global/utils/MapUtils"
], function (
    EventBus,
    ko,
    $,
    Mustache,
    Cesium,
    Utils,
    MapUtils
) {
    'use strict';

    var that, previousWidget;

    /**
     * 组件的数据传递
     * @export WidgetsManager
     * @param widgets
     * @constructor
     */
    function WidgetsManager(widgets) {
        if (!Cesium.defined(widgets)) {
            throw  Cesium.DeveloperError('widgetsConfig cannot null')
        }

        this._widgetsConfig = widgets.widget;
        this._toolsConfig = widgets.tool;
        that = this;
    }

    // todo widget init
    EventBus.listener(EventBus.WIDGETS_INITIALIZE, function (e) {
        Utils.log('加载组件面板中...');
        // 注册id
        ko.applyBindings(new ViewModel(), document.getElementById("globalWidgets"));
        Utils.log('面板加载结束');
    });


    /**
     * 初始化地图组件
     * @private
     */
    function ViewModel() {

        var widgetsAll = [], widgets = widgetSort();
        // 左侧组件
        self.leftWidgets = ko.observableArray(widgets);
        // 工具组件
        self.toolWidgets = ko.observableArray(toolSort());

        // 点击切换组件
        self.activeWidget = activeWidget;

        // 关闭组件
        self.closeWidget = function (widget) {
            var isClose = true,
                removeClass = 'active-widget';
            widgetEvent(widget, isClose);

            if (widget.isTool) {
                removeClass = 'active-tool-widget'
            }

            if (!$('.datalist-legend').is(':hidden')) {
                $('.datalist-legend').css('left', '5px');
            }

            // ko.utils.arrayForEach(widgets, function (item) {
            widget.isOpen = false;
            var pane = $('.' + widget.id + '-pane');
            widget.isTool ? pane.slideUp(400) : pane.hide(500);
            var widLi = $('#' + widget.id + 'Li');
            if (widLi.hasClass(removeClass)) {
                widLi.removeClass(removeClass)
            }
            // 关闭面板
            widget.visible = false;
            // });
        };


        /**
         * 激活组件
         * @param widget
         */
        function activeWidget(widget) {

            var widgets = self.leftWidgets();
            if (Cesium.defined(previousWidget) && widget.id !== widget.previousWidget) {
                widget.previousWidget = previousWidget;
            }

            that.toolsConfig.forEach(function (tool) {
                if (tool.id === widget.id) {
                    widget.isTool = true;
                }
            });

            // 判断是否是工具组件
            if (widget.isTool) {
                widgets = self.toolWidgets();
            }

            ko.utils.arrayForEach(widgets, function (item) {

                var pane = $('.' + item.id + '-pane'),
                    widLi = $('#' + item.id + 'Li');

                if (item.id === widget.id) {
                    if (widget.id === "identify") {
                        var identifyHandler = new Cesium.ScreenSpaceEventHandler(MapUtils.viewer.scene.canvas);
                        identifyHandler.setInputAction(function (click) {
                            var clickPoint = MapUtils.viewer.scene.pickPosition(click.position);
                            var latlng = Cesium.Cartographic.fromCartesian(clickPoint);
                            var lat = Cesium.Math.toDegrees(latlng.latitude);
                            var lng = Cesium.Math.toDegrees(latlng.longitude);
                            $.ajax({
                                url: that.widgetsConfig[1].config.identifyOptions.url,
                                type: 'GET',
                                dataType: 'json',
                                traditional: true,
                                async: true,
                                data: {
                                    instanceId: that.widgetsConfig[1].config.identifyOptions.instanceId,
                                    lon: lng,
                                    lat: lat,
                                    distance: that.widgetsConfig[1].config.identifyOptions.distance
                                },
                                timeout: 1000 * 60 * 10,
                                success: function (data) {
                                    if (data.count === 0) {
                                        layui.use(['layer'], function () {
                                            // 将分页存到全局中，方便查询结果后调用
                                            var layer = layui.layer;
                                            layer.msg('查询无结果', {
                                                time: 2000
                                            });
                                        });

                                    } else {
                                        try {
                                            widget.data = data;
                                            widget.config = that.widgetsConfig[1].config;
                                            widget.isTool ?
                                                (widLi.addClass('active-tool-widget'), pane.slideDown(500)) :
                                                (widLi.addClass('active-widget'), pane.animate({width: 'toggle'}, 500));
                                            widgetEvent(widget);
                                            item.visible = true;
                                            // item.isOpen ? (self.closeWidget(widget), item.isOpen = true) : widgetEvent(widget);
                                            // !widget.isOpen ? item.visible = true : item.visible = false;
                                            // widget.isOpen = !widget.isOpen;
                                            // 添加初始化参数
                                            widget.initialized = true;
                                        } catch (e) {
                                            Utils.error("请配置组件!")
                                        }
                                    }
                                }
                            });
                            identifyHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);

                        }, Cesium.ScreenSpaceEventType.LEFT_CLICK);
                    } else {
                        try {
                            widget.isTool ?
                                (widLi.addClass('active-tool-widget'), pane.slideDown(500)) :
                                (widLi.addClass('active-widget'), pane.animate({width: 'toggle'}, 500));
                            item.isOpen ? (self.closeWidget(widget), item.isOpen = true) : widgetEvent(widget);
                            !widget.isOpen ? item.visible = true : item.visible = false;
                            widget.isOpen = !widget.isOpen;
                            // 添加初始化参数
                            widget.initialized = true;
                        } catch (e) {
                            Utils.error("请配置组件!")
                        }
                    }

                } else {
                    item.isOpen = false;
                    pane.hide();
                    widget.isTool ? widLi.removeClass('active-tool-widget') : widLi.removeClass('active-widget')
                }
            });

            previousWidget = widget.id;

            if (!$('.datalist-legend').is(':hidden')) {
                $('.datalist-legend').css('left', '435px');
            }
        }


        /**
         *  组件排序 weight
         * @returns {Array}
         */
        function widgetSort() {
            var widgets = [];
            $.each(that.widgetsConfig, function (weight, value) {
                $.each(that.widgetsConfig, function (index, item) {
                    item = $.extend(item, {isOpen: false});
                    if (item.display && weight === parseInt(item.weight)) {
                        widgets.push(item);
                        loadWidget(item, index);
                    }

                });
            });
            return widgets
        }


        /**
         * 过滤工具组件
         * @return {*}
         */
        function toolSort() {
            return that.toolsConfig.filter(function (tool) {
                if (tool.display) {
                    loadWidget(tool);
                }
                return tool.display
            })
        }

        /**
         * widget event
         * @param widget
         * @param isClose
         */
        function widgetEvent(widget, isClose) {
            widgetsAll.forEach(function (item) {
                try {
                    if (item.id === widget.id) {
                        if (widget.initialized && !isClose) {
                            if (widget.id === "identify") {
                                item.config = widget.config;
                                item.data = widget.data;
                            }
                            typeof item.onOpen == 'function' ? item.onOpen() : Utils.error("请添加 [" + item.id + "]打开组件事件!");
                        } else {
                            if (!isClose) {
                                item.config = widget.config;
                                item.data = widget.data;
                            }
                            isClose ? item.onClose() : item.init();
                        }
                    }

                    if (widget.hasOwnProperty('previousWidget') && item.id === widget.previousWidget && widget.id !== widget.previousWidget) {
                        typeof item.onPause == 'function' ? item.onPause() : Utils.error("请添加 [" + item.id + "]离开组件事件!");
                    }
                } catch (e) {
                    Utils.error('请添加组件事件!');
                }
            })
        }

        /**
         * 组件的读取
         * @param widget
         */
        function loadWidget(widget) {
            var widgetId = widget.id,
                url = "global/widgets/" + widgetId;

            if (widget.visible) {
                previousWidget = widget.id;
                widget.isOpen = true;
            }
            try {
                require(["text!" + url + "/Index.html", "css!" + url + "/Style"], function (html) {
                    if (!html) {
                        Utils.log("widget [" + widgetId + "] must return BaseWidget");
                        return;
                    }
                    $('#' + widgetId + 'Widget').append(html);
                    require([url + "/Index"], function (index) {
                        index.config = widget.config;
                        var main = $.extend({
                            id: widgetId,
                            label: widget.label,
                            ko: self
                        }, index);
                        Utils.log('组件 [' + widgetId + '] 加载完成 ');
                        widgetsAll.push(main);
                        // 默认初始化
                        if (widget.visible) {
                            var widLi = $('#' + widgetId + 'Li');
                            widLi.addClass('active-widget');
                            widgetEvent(widget);
                            widget.initialized = true;
                        }
                    });
                }, function (err) {
                    Utils.error("模块 [" + widgetId + "] 加载异常请添加配置！")
                });
            } catch (e) {
                Utils.error("模块 [" + widgetId + "] 加载异常 [" + e.message + "]");
            }
        }

        // 组件初始化结束
        EventBus.trigger(EventBus.WIDGETS_LOADED, this);
    }


    Object.defineProperties(WidgetsManager.prototype, {

        widgetsConfig: {
            get: function () {
                return this._widgetsConfig;
            }
        },

        toolsConfig: {
            get: function () {
                return this._toolsConfig;
            }
        }

    });
    return WidgetsManager
});