/**
 *
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/7/18/9:28  Copyright gtmap Corp
 */

define([
    'global/core/index',
    'global/core/EventBus',
    'Cesium',
    'global/utils/MapUtils',
    'global/core/ViewerExtend',
    'jquery',
    '../utils/BuildingLoadUtils',
    '../utils/PoiLoadUtils',
    'global/controls/ViewerCesiumControlsMixin',
    'tp/bluebird/bluebird',
    'global/core/CameraAndScale',
    'knockout',
    'lodash',
    'global/core/GetUrlParams'
], function (
    Utils,
    EventBus,
    Cesium,
    MapUtils,
    ViewerExtend,
    $,
    BuildingLoad, PoiLoad,
    ViewerCesiumControlsMixin,
    Promise,
    Camera,
    ko,
    _,
    GetUrlParams
) {
    'use strict';
    var that, isShowModelLevel = false, viewer, tinModels = [], addToSceneModel,
        hasAddModel = false, hasTinModel = false;

    function GlobalManager(config, container) {
        if (!Cesium.defined(config)) {
            throw  new Cesium.DeveloperError('mapConfig cannot null')
        }
        this._globalConfig = config.map;
        this._controls = config.controls;
        this._modelLayer = undefined;
        if (!container) {
            this._container = Utils.config.GLOBAL_CONTAINER;
        } else {
            this._container = container;
        }
        that = this;
    }


    // init dom after init fun
    EventBus.listener(EventBus.GLOBAL_INITIALIZE, function (e) {
        Utils.log('初始化中三维地图...');
        _initializeGlobal();
    });

    function viewRoamModel() {
        var self = this, isStart = true;

        self.roamIConCls = ko.observable('icon-f-start-fly');

        self.roamStatusHandle = function () {
            // change icon

            isStart ? self.roamIConCls('icon-f-start-fly') : self.roamIConCls('icon-f-pause-fly');

            // roam Camera
            if (!viewer) {
                return Utils.warn('请在地图初始化结束后点击漫游！');
            }

            var camera = viewer.scene.camera;
            var position = viewer.scene.globe.ellipsoid.cartesianToCartographic(camera.position);
            var lat = Cesium.Math.toDegrees(position.latitude);
            var lng = Cesium.Math.toDegrees(position.longitude);

            var toMove = setInterval(function () {
                lat = lat + 0.1;
                camera.flyTo({
                    destination: Cesium.Cartesian3.fromDegrees(lng, lat, position.height),
                    orientation: {
                        heading: camera.heading,
                        pitch: camera.pitch,
                        roll: camera.roll
                    },
                    duration: 0.5,
                    convert: false
                });

                if (Math.round(lat) === 90 || isStart) {
                    clearInterval(toMove);
                }

            }, 1000);
            // }
        }
    }

    /**
     * 初始化地球
     * @private
     */
    function _initializeGlobal(container) {

        var baseLayers = that._globalConfig.baseLayers[0].layers;

        var modelLayer = that._globalConfig.baseLayers[0].modelLayer;
        // MapUtils.setModelLayer(modelLayer);
        // 默认底图
        var globalLayers = that._globalConfig.globalLayer;

        var initBounds = that._globalConfig.options.initBounds;

        var minScale = (that._globalConfig.options.minScale) ? that._globalConfig.options.minScale : 0;

        var baseLayerAll = [], _ctlsOptions = {};

        var container = that._container;
        // supermap add 3dtile must set Ellipsoid.WGS84 === 4490
        Cesium.Ellipsoid.WGS84 = Cesium.freezeObject(Utils.config.ellipsolid["EPSG:4490"]);

        // 默认底图并添加地形图
        var viewer = new ViewerExtend(new Cesium.Viewer(container, {
            navigation: false,
            infoBox: false,
            terrainProvider: new Cesium.EllipsoidTerrainProvider({}),
            selectionIndicator: false,
            resolutionScale: window.devicePixelRatio
        }));

        // 添加球体底图 球体底图为空默认supermap底图切片
        if (globalLayers.length > 0) {
            globalLayers.forEach(function (lyr) {
                    var provider = MapUtils.createGlobalLayer(lyr, viewer);
                    if (provider) {
                        viewer.scene.imageryLayers.add(new Cesium.ImageryLayer(provider));
                    }

                }
            );
        }

        if (!baseLayers) {
            throw  new Cesium.DeveloperError('请配置底图');
        }

        if (modelLayer && modelLayer.type === 'spm_terr') {
            viewer.terrainProvider = MapUtils.createGlobalLayer(modelLayer, viewer);
        }

        // 添加图层控制底图
        baseLayers.forEach(function (lyr) {
            // 计算最小可见比例尺
            try {
                var minLevel = 0;
                var info = (lyr.type.indexOf("tile") > 0) ? {"tileInfo": "", "layers": []} : {};
                $.each(Camera.getResolution(lyr.crs), function (index, ele) {
                    if (minScale === ele.scale) {
                        minLevel = ele.level;
                    }
                });
                var provider = MapUtils.createGlobalLayer(lyr, viewer);

                if (provider) {
                    var imageryLayer = $.extend(new Cesium.ImageryLayer(provider), {
                        layerId: lyr.id,
                        layerAlias: lyr.alias,
                        alpha: 1.0,
                        minLevel: minLevel,
                        extent: Cesium.Rectangle.fromDegrees(initBounds.xmin, initBounds.ymin, initBounds.xmax, initBounds.ymax),
                        info: info
                    });
                    viewer.scene.imageryLayers.add(imageryLayer);
                    baseLayerAll.push(imageryLayer);
                }
            } catch (e) {
                console.log(e)
            }
        });

        MapUtils.setBaseImageryLayers(baseLayerAll);

        if (that._globalConfig.buildingES && that._globalConfig.buildingES.url && that._globalConfig.buildingES.instanceId) {
            var buildingLoad = new BuildingLoad(viewer, {
                url: that._globalConfig.hasOwnProperty("buildingES") ? that._globalConfig.buildingES.url : "",
                instanceId: that._globalConfig.hasOwnProperty("buildingES") ? that._globalConfig.buildingES.instanceId : ""
            });
            MapUtils.setModelLayer(buildingLoad);
        } else {
            MapUtils.setModelLayer(modelLayer);
            // 监听图层事件
            _handlerWheel(viewer, modelLayer);
        }

        var poiLoad = new PoiLoad(viewer, {
            url: that._globalConfig.hasOwnProperty("poiES") ? that._globalConfig.poiES.url : "",
            instanceId: that._globalConfig.hasOwnProperty("poiES") ? that._globalConfig.poiES.instanceId : ""
        })
        MapUtils.setPoiLayer(poiLoad);
        // 监听图层事件
        // _handlerWheel(viewer, modelLayer);

        // 组件结束后进行定位
        EventBus.listener(EventBus.WIDGETS_LOADED, function (e) {

            var promise = function () {
                return new Promise(function (resolve, reject) {
                    setTimeout(function () {
                        // 初始化控件
                        if (that._controls) {
                            that._controls.forEach(function (control) {
                                _ctlsOptions[control.id] = control.display;
                            });
                        }

                        if (_ctlsOptions) {
                            ViewerCesiumControlsMixin(viewer, _ctlsOptions);
                        }

                        MapUtils.setViewer(viewer);

                        // 展示组件面板
                        Utils.config.leftWidgetDom.show();
                        Utils.config.toolWidgetDom.show();
                        resolve();
                    }, 2000)
                })
            };


            promise().then(function (value) {
                viewer.scene.camera.flyTo({
                    destination: Cesium.Rectangle.fromDegrees(initBounds.xmin, initBounds.ymin, initBounds.xmax, initBounds.ymax)
                });

                Pace.stop();
                Utils.log('初始化三维地图结束');

                // 打开来自首页点击需要定位到的功能模块
                var param = GetUrlParams.getWidgetName();
                if (param !== undefined && param !== null && param !== "") {
                   try{
                       $('#'+param+'Li').trigger('click');
                   } catch (e) {
                       Error(e);
                   }
                }

            });
        });

    }


    /**
     * 根据比例尺等比放缩地图
     * @param viewer
     * @param modelLayer
     * @private
     */
    function _handlerWheel(viewer, modelLayer) {
        viewer.camera.moveEnd.addEventListener(function () {
            var levels = [], tilesToRender = viewer.scene.globe._surface._tilesToRender;

            tilesToRender.forEach(function (value) {
                levels.push(value.level)
            });

            var _levels = Array.from(new Set(levels)),
                zoomLevel = Math.max.apply(null, _levels);
            MapUtils.setZoomLevel(zoomLevel);

            if (modelLayer) {
                if (_levels.length > 0 && zoomLevel > 15 && modelLayer.hasOwnProperty('modelLayerDetails')) {
                    modelLayer.modelLayerDetails.visible = true;

                } else if (_levels.length > 0 && zoomLevel < 16 && modelLayer.hasOwnProperty('modelLayerDetails')) {
                    modelLayer.modelLayerDetails.visible = false;
                }
            }
            // var isShowModel = MapUtils.isShowModel;
            //
            // if (modelLayer && isShowModel) {
            //     if (_levels.length > 0 && zoomLevel > 15 &&
            //         !modelLayer.hasOwnProperty('modelLayerDetails') && isShowModelLevel === false) {
            //         modelLayer.layerName = modelLayer.name;
            //         modelLayer.fillColor="#FAEAEAEA";
            //         modelLayer.brightness=0.76;
            //         MapUtils.createGlobalLayer(modelLayer, viewer);
            //         isShowModelLevel = true;
            //     } else if (_levels.length > 0 && zoomLevel < 16 && modelLayer.hasOwnProperty('modelLayerDetails')) {
            //         viewer.scene.layers.remove(modelLayer.layerName);
            //         delete modelLayer.modelLayerDetails;
            //         isShowModelLevel = false;
            //     }
            // } else if (modelLayer && !isShowModel && modelLayer.hasOwnProperty('layerName')) {
            //     viewer.scene.layers.remove(modelLayer.layerName);
            //     delete modelLayer.modelLayerDetails;
            // }
            //
            // MapUtils.setModelLayer(modelLayer);

        });
    }

    Cesium.defineProperties(GlobalManager.prototype, {

        globalConfig: {
            get: function () {
                return this._globalConfig;
            }
        },

        controls: {
            get: function () {
                return this._controls;
            }
        }

    });


    return GlobalManager
});