/**
 *  地图配置分发
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/7/18/9:26  Copyright gtmap Corp
 */

define([
    'global/core/index',
    'global/core/EventBus',
    './WidgetsManager',
    './GlobalManager',
    'knockout',
    'jquery',
    'global/utils/WidgetUtils',
    'Cesium'
], function (
    Utils,
    EventBus,
    WidgetsManager,
    GlobalManager,
    ko,
    $,
    WidgetUtils,
    Cesium
) {
    'use strict';

    /**
     * @alias ConfigManager
     * @constructor
     */
    function ConfigManager(config) {
        if (!Cesium.defined(config)) {
            throw  Cesium.DeveloperError('tpl cannot null')
        }

        // 进行赋值
        this._content = config.content;
        this._isGlobal = config.isGlobal;
        this._globalConfig = {
            map: this._content.map,
            controls: this._content.controls
        };
        this._widgets = {
            widget: this._content.widgets,
            tool: this._content.tools
        };

        // 自定义参数 todo other params
        this._appConfig = {
            baseLayer: this._content.map.baseLayers,
            interface: this._content.map.interface
        };

        // 默认未配置则显示二维地图
        var isGlobal = Cesium.defaultValue(config.isGlobal, false);


        // 分发数据
        _setAppConfig(this._appConfig);
        _setControlConfig(this._content.controls);
        _setGlobalConfig(this._globalConfig);
        _setWidgetsConfig(this._widgets);
    }


    /**
     *  set widgets
     * @param widgets
     * @private
     */
    function _setWidgetsConfig(widgets) {
        new WidgetsManager(widgets);
        EventBus.trigger(EventBus.WIDGETS_INITIALIZE, widgets);
    }

    function _setGlobalConfig(globalConfig) {
        new GlobalManager(globalConfig);
        EventBus.trigger(EventBus.GLOBAL_INITIALIZE, globalConfig);
    }

    /**
     * 传输部分自定义参数
     *  set appConfig
     * @param appConfig
     * @private
     */
    function _setAppConfig(appConfig) {
        WidgetUtils.setAppConfig(appConfig);
}

    function _setControlConfig(controlConfig){
        WidgetUtils.setControlConfig(controlConfig);
    }


    Object.defineProperties(ConfigManager.prototype, {

        isGlobal: {
            get: function () {
                return this._isGlobal;
            }
        },

        appConfig: {
            get: function () {
                return this._appConfig;
            }

        },

        widgetsConfig: {
            get: function () {
                return this._widgetsConfig;
            },
            set: function (config) {
                this._widgetsConfig = config;
            }
        },

        globalConfig: {
            get: function () {
                return this._globalConfig;
            },
            set: function (config) {
                this._globalConfig = config;
            }
        }

    });


    return ConfigManager
});
