/**
 * @Project 时空超立方
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/1/30/10:05  Copyright gtmap Corp
 */



(function () {
    if (!window.console) {
        var names = ["log", "debug", "info", "warn", "error", "assert", "dir", "dirxml", "group", "groupEnd", "time", "timeEnd", "count", "trace", "profile", "profileEnd"];
        window.console = {};
        for (var i = 0; i < names.length; ++i)
            window.console[names[i]] = function () {
            }
    }
    if (window["context"] === undefined) {
        if (!window.location.origin) {
            window.location.origin = window.location.protocol + "//" + window.location.hostname +
                (window.location.port ? ':' + window.location.port : '');
        }
        window["context"] = location.origin + "/V6.0";
    }
}());

$(function () {
    /**
     * 日期格式化
     * @param fmt
     * @returns {*}
     * @constructor
     */
    Date.prototype.Format = function (fmt) {
        var o = {
            "M+": this.getMonth() + 1, //月份
            "d+": this.getDate(), //日
            "h+": this.getHours(), //小时
            "m+": this.getMinutes(), //分
            "s+": this.getSeconds(), //秒
            "q+": Math.floor((this.getMonth() + 3) / 3), //季度
            "S": this.getMilliseconds() //毫秒
        };
        if (/(y+)/.test(fmt))
            fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
        for (var k in o) {
            if (new RegExp("(" + k + ")").test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
            }
        }
        return fmt;
    };

    /**
     * Date  toLocaleString
     * @returns {string}
     */
    Date.prototype.toLocaleString = function () {
        return this.getFullYear() + "年" + (this.getMonth() + 1) + "月" + this.getDate() + "日 " + this.getHours() + "点" + this.getMinutes() + "分" + this.getSeconds() + "秒";
    };

    /**
     * Proxy部分兼容处理
     * 仅支持代理apply与construct
     */
    window.Proxy = window.Proxy || function (target, handler) {
        if (typeof target !== 'function') {
            throw new TypeError('Only support function proxy in this polyfill');
        }

        function __Proxy__() {
            if (this instanceof __Proxy__) {
                // 实例化
                var obj;
                if (typeof handler.construct === 'function') {
                    obj = handler.construct(target, arguments);
                    if (obj && typeof obj === 'object') {
                        return obj;
                    } else {
                        throw new TypeError('Proxy handler\'s construct must return an object');
                    }
                } else if (handler.construct == null) {
                    obj = target.apply(this, arguments);
                    if (obj && typeof obj === 'object') {
                        return obj;
                    } else {
                        return this;
                    }
                } else {
                    throw new TypeError('Proxy handler\'s construct must be a function');
                }
            } else {
                // 函数调用
                if (typeof handler.apply === 'function') {
                    return handler.apply(target, this, arguments);
                } else if (handler.apply == null) {
                    return target.apply(this, arguments);
                } else {
                    throw new TypeError('Proxy handler\'s apply must be a function');
                }
            }
        }

        Object.setPrototypeOf(__Proxy__, target);
        $.extend(__Proxy__, target);
        __Proxy__.prototype = target.prototype;
        return __Proxy__;
    };


    require([
        'global/core/EventBus',
        'global/core/index',
        'global/manager/ConfigManager'
    ], function (EventBus, Utils, ConfigManager) {
        EventBus.listener(EventBus.CONTENT_INITIALIZE, function () {
                Utils.log("使用" + tpl.title);
                new ConfigManager(tpl);
            }
        );

        EventBus.appInit();
    });


});