/**
 * Warn
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/5/17/15:21  Copyright gtmap Corp
 */

define(function () {
    /**
     * @export Warn
     *
     * @param warnText {String}
     * @constructor
     * @returns {String} Returns warn info in console.
     *
     * @example warn(something)
     */
    function Warn(warnText) {
        var now = new Date();
        var timeTag = now.getFullYear() + "-" + (now.getMonth() + 1) + "-" + now.getUTCDate() + " "
            + now.getHours() + ":" + now.getMinutes() + ":" + now.getSeconds();
        console.warn("%c" + timeTag + '|-WARN-- ' + warnText, 'color: #E6A23C');
    }

    return Warn
});