/**
 *
 * @author by zzf
 * @version v1.0 2019年8月1日17:22:50  Copyright gtmap Corp
 */

define([
    "Cesium",
    "global/utils/MapUtils",
    "global/core/EventBus",
    "global/core/ToolTip"
], function (
    Cesium,
    MapUtils,
    EventBus) {
    var superMapDraw = {

        draw: function (id) {
            var tooltip = createTooltip(document.body);
            var viewer = MapUtils.viewer;
            if(MapUtils.polygonDrawHandler !== undefined && MapUtils.polygonDrawHandler !== null){
                MapUtils.polygonDrawHandler.clear();
                MapUtils.polygonDrawHandler.deactivate();
                MapUtils.polygonDrawHandler = null;
            }
            MapUtils.setPolygonDrawHandler(new Cesium.DrawHandler(viewer, Cesium.DrawMode.Polygon, 1));
            MapUtils.polygonDrawHandler.activeEvt.addEventListener(function (isActive) {
                if (isActive === true) {
                    viewer.enableCursorStyle = false;
                    viewer._element.style.cursor = '';
                    $('body').removeClass('drawCur').addClass('drawCur');
                }
                else {
                    viewer.enableCursorStyle = true;
                    $('body').removeClass('drawCur');
                }
            });

            MapUtils.polygonDrawHandler.activate();
            MapUtils.polygonDrawHandler.movingEvt.addEventListener(function(windowPosition){
                if(MapUtils.polygonDrawHandler.isDrawing){
                    tooltip.showAt(windowPosition,'<p>左键点击确定折线中间点</p><p>右键单击结束绘制</p>');
                }
                else{
                    tooltip.showAt(windowPosition,'<p>点击绘制第一个点</p>');
                }

            });
            MapUtils.polygonDrawHandler.drawEvt.addEventListener(function (result) {
                EventBus.trigger(id, MapUtils.superMapPolygonToFeatureCollection(result));
                tooltip.setVisible(false);
            });
        },
        
        clear: function () {
            if(MapUtils.polygonDrawHandler){
                MapUtils.polygonDrawHandler.clear();
                MapUtils.polygonDrawHandler.deactivate();
            }
        }
    };


    return superMapDraw;
});