/**
 * // 是否有关闭按钮，content是string还是div片段，传入直接是位置对象，暴露出偏移方向和是否有箭头，
 * // 关闭destroy可以获得id和关闭监听方法，传入时自动生成id，不需要传入
 * // 如样式被三角箭头遮挡，给予被遮挡div position: relative(后续优化)
 * popup.open({
 *      content: ""             // popup窗内容
 *      position: ""            // cesium点击事件监听的click坐标
 *      offset: ""              // popup生成的位置，有top，right，bottom，left四种
 *      hasTriangle : true      // 是否有三角箭头
 *      triangleOffset: bottom  // 默认三角箭头生成位置
 *      hasClose: true          // 是否有关闭按钮
 * })
 *
 *
 * popup.close()             // 关闭事件
 *
 */
define([
    "Cesium",
    "global/utils/MapUtils",
    "lodash"
], function (
    Cesium,
    MapUtils,
    _
) {

    function Popup() {

    }

    var id = "";
    var uniqueId = "";
    var popupList = {};

    Popup.prototype.open = function (options) {
        _createContent(options);

        _setInputAction(options);
    };

    Popup.prototype.close = function (e) {
        var dom = e.target.parentElement;
        while (popupList[dom.id] === undefined) {
            dom = dom.parentElement;
        }
        var temp = popupList[dom.id];
        if (temp !== undefined) {
            temp();
            delete popupList[dom.id];
            $("#" + dom.id).remove();
        }
    };

    Popup.prototype.closeAll = function () {

    };

    // 获取当前的popup的id
    Popup.prototype.getId = function () {
        return id;
    };

    // 根据id移除popup窗
    Popup.prototype.closeById = function (id) {
        $(id).remove();
    };

    var _createContent = function (options) {
        uniqueId = _.uniqueId();
        id = "#" + uniqueId + "Popup";
        options.id = id;
        var popup = "<div class='popup-pane' id='" + uniqueId + "Popup' >";
        if (options.hasTriangle === undefined || options.hasTriangle === true) {
            popup += "<div class='popup-pane-triangle'></div>";
        }
        if (options.hasClose === undefined || options.hasClose === true) {
            popup += "<i class='popup-pane-close icon-f-close'></i>"
        } else {
            popup += "</div>"
        }
        $('body').append(popup);
        $(id).append(options.content);
    };

    var _setInputAction = function (options) {
        var clickPoint = MapUtils.viewer.scene.pickPosition(options.position);

        options.clickPoint = clickPoint;

        function setPosition(options) {
            var offset, triangleOffset;
            if (options.triangleOffset) {
                triangleOffset = options.triangleOffset;
            } else {
                triangleOffset = "bottom";
            }
            if (options.offset) {
                offset = options.offset
            } else {
                offset = "top";
            }

            var clickPoint = options.clickPoint;
            var id = options.id;
            var triClass = ".popup-pane-triangle";
            var i = MapUtils.viewer.camera.pickEllipsoid(new Cesium.Cartesian2(MapUtils.viewer.canvas.clientWidth / 2, MapUtils.viewer.canvas.clientHeight / 2));
            if (i !== undefined) {
                var changedC = Cesium.SceneTransforms.wgs84ToWindowCoordinates(MapUtils.viewer.scene, clickPoint);
                var onTop = false;
                var e = clickPoint;
                var n = MapUtils.viewer.scene.globe.ellipsoid.cartesianToCartographic(i).height;
                var max = n + 1 * MapUtils.viewer.scene.globe.ellipsoid.maximumRadius;
                var distance = Cesium.Cartesian3.distance(i, e);
                if (max < distance) {
                    onTop = false;
                } else {
                    onTop = true;
                }
                if (onTop) {
                    var x = changedC.x;
                    var y = changedC.y;
                    var triangleX = 0;
                    var triangleY = 0;
                    var height = $(id).height();
                    var width = $(id).width();
                    var triangleHeight = $(triClass).height();
                    var triangleWidth = $(triClass).width();
                    $(id).css('display', 'block');
                    switch (offset) {
                        case 'top':
                            x = x - width / 2;
                            y = y - height - 10;
                            break;
                        case 'right':
                            x = x + 10;
                            y = y - height / 2;
                            break;
                        case 'bottom':
                            x = x - width / 2;
                            y = y + 10;
                            break;
                        case 'left':
                            x = x - width - 10;
                            y = y - height / 2;
                            break;
                    }
                    switch (triangleOffset) {
                        case 'top':
                            triangleX = width / 2 - triangleWidth / 2;
                            triangleY = -triangleHeight / 2 + 5;
                            break;
                        case 'right':
                            triangleX = width - triangleWidth / 2 - 5;
                            triangleY = height / 2 - triangleHeight / 2;
                            break;
                        case 'bottom':
                            triangleX = width / 2 - triangleWidth / 2;
                            triangleY = height - triangleHeight / 2 - 5;
                            break;
                        case 'left':
                            triangleX = -triangleWidth / 2 + 5;
                            triangleY = height / 2 - triangleHeight / 2;
                            break;

                    }
                    $(id).css('left', x + 'px');
                    $(id).css('top', y + $(".new-header-box").height() + 'px');
                    $(triClass).css('left', triangleX + 'px');
                    $(triClass).css('top', triangleY + 'px');
                    $(".popup-pane-triangle").show()
                } else {
                    $(id).css('display', 'none');
                }
            }
        }

        var listener = MapUtils.viewer.scene.postRender.addEventListener(function () {
            setPosition(options)
        });
        popupList[uniqueId + "Popup"] = listener;
        $(".popup-pane-close").on("click", function (e) {
            var temp = popupList[e.target.parentElement.id];
            if (temp !== undefined) {
                temp();
                delete popupList[e.target.parentElement.id];
                $("#" + e.target.parentElement.id).remove();
                $(".popup-pane-triangle").hide()
            }
        });

    };


    return new Popup;

});