/**
 *  header控制js
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/6/3/19:46  Copyright gtmap Corp
 */

define(['./Error', 'jquery'], function (Error, $) {


    /**
     * @export hasHeader
     */
    function GetUrlParams() {
        this._url = window.location.href;
    }


    function parseQueryString(url) {
        url = url === null ? window.location.href : url;
        var obj = {},
            search = url.substring(url.lastIndexOf("?") + 1),
            reg = /([^?&=]+)=([^?&=]*)/g;
        search.replace(reg, function (rs, $1, $2) {
            var name = decodeURIComponent($1);
            var val = decodeURIComponent($2);
            val = String(val);
            obj[name] = val;
            return rs;
        });
        return obj;
    }


    /**
     * @export hasHeader
     * @returns {boolean|any}
     */
    GetUrlParams.prototype.hasHeader = function () {
        try {
            var hasHeader, params = parseQueryString(window.location.href);
            hasHeader = params.hasOwnProperty('hasHeader') ? JSON.parse(params.hasHeader) : true;
            return hasHeader
        } catch (e) {
            Error(e);
        }
    };

    /**
     * getheaderHeight
     * @returns {jQuery}
     */
    GetUrlParams.prototype.getHeaderHeight = function () {
        return $('.map-header').outerHeight();
    };

    GetUrlParams.prototype.hasLayer = function (map) {
        var hasLayer, params = parseQueryString(window.location.href);
        hasLayer = params.hasOwnProperty('layer') ? JSON.parse(params.layers) : true;
        if (hasLayer === true) {
            var url = "../mock/layers.json";
            $.getJSON(url, function (data) {
                var layers = data.content[params.layers.toUpperCase()].layers;
                var layer = "";
                if (layers.length !== 1) {
                    layer = L.layerGroup(layers.map(function (lyr) {
                        return MapUtils.createMapLayer(lyr);
                    }));
                } else if (layers.length === 1) {
                    var options = layers[0];
                    layer = MapUtils.createMapLayer(options);
                }
                map.addLayer(layer);
                $.support.cors = true;
                $.ajax({
                    url: layers[0].url,
                    type: 'get',
                    dataType: 'jsonp',
                    data: {f: 'pjson'},
                    success: function (res) {
                        var extent = res.fullExtent;
                        // 坐标转换
                        var crs = MapUtils.getCrs(extent.spatialReference.wkid);
                        var coord1 = crs.unproject(L.point(extent.xmax, extent.ymax));
                        var coord2 = crs.unproject(L.point(extent.xmin, extent.ymin));
                        var bounds = L.latLngBounds(coord1, coord2);
                        map.fitBounds(bounds);
                    }
                })
            })
        }
        return hasLayer
    };

    /**
     * @export widgetName
     * @returns {String}
     */
    GetUrlParams.prototype.getWidgetName = function () {
        var widgetName="";
        try {
            var url = window.location.href;
            url = url === null ? window.location.href : url;
            if (url.lastIndexOf("?")>-1){
                widgetName = url.substring(url.lastIndexOf("?") + 1);
            }
        } catch (e) {
            Error(e);
        }
        return widgetName;
    };

    return new GetUrlParams;
});