define(function () {
    'use strict';
    function createRandom() {
        var result ="";
        for(var i=0;i<8;i++){
            result = result+Math.random*10;
        }
        return result;
    }
    var store = {
        data: [],
        get: function (id) {
            if(!id){
                return this.data
            }else {
                var target =null;
                $(this.data).each(function (i,e) {
                    if(e.id==id){
                        target =e;
                        return;
                    }
                })
                return target;
            }

        },
        set: function (item) {
            var isContain= false;
            var feature = item.feature;
            var tmp = {};
            tmp.geometry = feature.geometry;
            tmp.type = item.type;
            tmp.properties={};
            for(var i in feature.properties){
                if(typeof feature.properties[i]=="string"){
                    feature.properties[i]=feature.properties[i];
                }
            }
            var dt ={
                type:item.type,
                label:item.label,
                id:item.id||createRandom(),
                feature:tmp
            }

            $(this.data).each(function (i,e) {
                if(e.id&&e.id==item.id){
                    e=dt;
                }
            });


            if(!isContain){
                this.data.push(dt)
            }
        },
        clear: function () {
            this.data = []
        }
    }
    return store;
})