/**
 *
 * 调用
 * drawGeometry.draw({
                        type: "groundLine",
                        measure: true,
                        id: ''                  // 如果id存在则判断需要进行返回值，增加eventBus事件，将结果传出
                        viewer: MapUtils.viewer
                    });
 * 移除
 * DrawGeometry.remove();
 * @author by zzf
 * @version v1.0 2019年7月22日15:59:55  Copyright gtmap Corp
 */

var viewer = "";

// 判断是否有id传入，如果有id则触发eventBus事件
var drawId = undefined;
define(["Cesium",
    "global/core/Popup",
    "global/core/EventBus",
    "global/utils/MapUtils"], function (Cesium, Popup, EventBus, MapUtils) {

    var drawGeometry = {

        // 带有删除按钮的弹出窗
        popupAll: [],

        // 判断鼠标状态的，是否进入了长按左键的拖动状态
        leftDown: false,

        draw: function (drawGeo) {
            // 三维场景
            this.viewer = drawGeo.viewer;
            // 全局viewer
            viewer = this.viewer;
            // 屏幕事件监听
            if (!this.handler)
                this.handler = new Cesium.ScreenSpaceEventHandler(this.viewer.scene.canvas);

            if (drawGeo.id)
                drawId = drawGeo.id;
            this.drawType = drawGeo.type;

            // 关闭所有监听事件
            this._closeMouseEvent(this.handler);
            // 判断鼠标状态，是否进入了长按左键的拖动状态
            this.handler.setInputAction(function (mouseMove) {
                this.leftDown = true;
            }, Cesium.ScreenSpaceEventType.LEFT_DOWN);
            this.handler.setInputAction(function (mouseMove) {
                this.leftDown = false;
            }, Cesium.ScreenSpaceEventType.LEFT_UP);
            this._drawEvent();
        },

        remove: function () {
            if (this.handler)
                this._closeMouseEvent(this.handler);
            if (this.popupAll.length > 0) {
                $.each(this.popupAll, function (index, value) {
                    $(value).trigger('click');
                })
            }
            // 关闭悬浮事件
            this._closeMouseMovePopup();
        },

        // 根据传入type分解到不同的绘制方法
        _drawEvent: function () {
            switch (this.drawType) {
                case "spaceLine":
                    this._drawSpaceDistanceLine();
                    break;
                case "groundLine":
                    this._drawGroundLine();
                    break;
                case "drawHeight":
                    this._drawHeight();
                    break;
                case "drawSpaceSurface":
                    this._drawSpaceSurface();
                    break;
                case "drawGroundSurface":
                    this._drawGroundSurface();
                    break;
                case "drawCircleSurface":
                    this._drawCircleSurface();
                    break;
                default:
                    break;
            }
        },

        // 空间直线
        _drawSpaceDistanceLine: function () {
            // 所有点坐标
            var points = [];

            var that = this;

            // 所有生成线的集合
            var polylineCollection = new Cesium.PrimitiveCollection();
            // 长度数组，方便删除上个线段长度
            var lengthArray = [];
            // 移动线实例，方便移除
            var movePolylinePrimitive;
            var moveInstance = [];

            // 线的材质和样式
            var appearance = new Cesium.PolylineMaterialAppearance({
                material: Cesium.Material.fromType('Color')
            });

            // 添加到地图上的线实例和用webGl方式添加到地图上的线
            var instance, linePrimitives;
            // 计算长度的label
            var labels = viewer.scene.primitives.add(new Cesium.LabelCollection());
            // 本次生成的label集合，防止右击删除事件移除其他部分的label
            var labelsArray = [];

            // 移动过程中生成的label集合
            var moveLabels = viewer.scene.primitives.add(new Cesium.LabelCollection());

            // 上一个移动过程中生成的label
            var moveLastLabel;

            // 左击事件监听
            this.handler.setInputAction(function (click) {
                // 将屏幕坐标转换为世界坐标
                var point = viewer.scene.pickPosition(click.position);
                // 根据长度判断是起始点或是非起始点
                if (points.length === 0) {
                    points.push(point);
                } else {
                    // 移除移动过程中生成的线段
                    if (Cesium.defined(movePolylinePrimitive)) {
                        viewer.scene.primitives.remove(movePolylinePrimitive)
                    }
                    points.push(point);
                    // 生成线的实例
                    instance = that._createSpaceLineWithId(points, "spaceDistanceLine" + Math.random());
                    // 添加到地图
                    linePrimitives = viewer.scene.primitives.add(new Cesium.Primitive({
                        geometryInstances: instance,
                        appearance: appearance,
                        asynchronous: false
                    }));
                    // 添加到primitivesCollection
                    polylineCollection.add(linePrimitives);
                    moveInstance.push(linePrimitives);

                    // 计算长度并生成自带的label
                    if (points.length > 1) {
                        var distance = Cesium.Cartesian3.distance(points[points.length - 2], points[points.length - 1]);
                        lengthArray.push(distance);
                        var labelPosition = viewer.scene.pickPosition(click.position);
                        labelPosition.z += 10;
                        labelPosition.y -= 10;
                        labelPosition.x -= 10;
                        $(".main-map-popup").hide();
                        labelsArray.push(labels.add({
                            position: labelPosition,
                            text: distance.toFixed(2) + " 米",
                            scale: 0.8,
                            font: 'normal small-caps 25px 楷体',
                            disableDepthTestDistance: Number.POSITIVE_INFINITY,
                            fillColor: Cesium.Color.RED,
                            showBackground: true,
                            backgroundColor: new Cesium.Color(1, 1, 1, 0.8)
                        }));
                    }
                }

            }, Cesium.ScreenSpaceEventType.LEFT_CLICK);

            // 右击事件监听
            this.handler.setInputAction(function (click) {
                // 移除点坐标，移除线样式
                if (points.length !== 0) {
                    points.pop();
                    // 移除上一个label
                    if (points.length !== 0) {
                        labels.remove(labelsArray[labelsArray.length - 1]);
                        labelsArray.pop();
                        // 移除最后一个生成的线
                        viewer.scene.primitives.remove(moveInstance[moveInstance.length - 1]);
                        polylineCollection._primitives.pop();
                        moveInstance.pop();
                        // 重新计算长度
                        lengthArray.pop();
                        // 生成上个点和现有点的临时连线
                        movePolylinePrimitive = that._createTempSpaceLine(click.position,
                            points, appearance, movePolylinePrimitive);
                        var clickCartesian3 = viewer.scene.pickPosition(click.position);
                        moveLastLabel = that._createTempLabel(clickCartesian3, points[points.length - 1], moveLabels, moveLastLabel, click.position);
                    } else {
                        moveLabels.remove(moveLastLabel);
                        if (Cesium.defined(movePolylinePrimitive)) {
                            viewer.scene.primitives.remove(movePolylinePrimitive);
                        }
                    }
                }
            }, Cesium.ScreenSpaceEventType.RIGHT_CLICK);

            // 移动事件监听
            this.handler.setInputAction(function (mouseMove) {
                var promise = Cesium.GroundPolylinePrimitive.initializeTerrainHeights();
                promise.then(function () {
                    if (points.length !== 0) {
                        // 移动点世界坐标
                        var moveCartesian3 = viewer.scene.pickPosition(mouseMove.endPosition);
                        // 生成移动线段的实体
                        if (moveCartesian3 !== undefined) {
                            movePolylinePrimitive = that._createTempSpaceLine(mouseMove.endPosition,
                                points, appearance, movePolylinePrimitive);
                            // test
                            // test
                            moveLastLabel = that._createTempLabel(moveCartesian3, points[points.length - 1], moveLabels, moveLastLabel, mouseMove.endPosition);
                        }
                    }
                    // 生成鼠标移动的popup窗
                    that._mouseMovePop(mouseMove.endPosition);
                });
            }, Cesium.ScreenSpaceEventType.MOUSE_MOVE);

            // 双击事件监听
            this.handler.setInputAction(function (click) {
                // 关闭监听事件
                that._closeMouseEvent(that.handler);
                // 移除多余的一个点
                points.pop();
                // 移除多触发两次单机事件的label
                labels.remove(labelsArray[labelsArray.length - 1]);
                labels.remove(labelsArray[labelsArray.length - 2]);
                labelsArray.pop();
                labelsArray.pop();
                moveLabels.remove(moveLastLabel);
                // 移动点世界坐标
                var dbclickCartesian3 = viewer.scene.pickPosition(click.position);
                // 生成总长度的label
                var length = 0;
                //     lengthArray.forEach((temp) => {
                //         length += temp;
                // });
                for (var i = 0; i < lengthArray.length; i++) {
                    length += lengthArray[i];
                }
                dbclickCartesian3.z += 10;
                dbclickCartesian3.y -= 10;
                dbclickCartesian3.x -= 10;
                labels.add({
                    position: dbclickCartesian3,
                    text: "总长" + length.toFixed(2) + " 米",
                    scale: 0.8,
                    font: 'normal small-caps 25px 楷体',
                    disableDepthTestDistance: Number.POSITIVE_INFINITY,
                    fillColor: Cesium.Color.RED,
                    showBackground: true,
                    backgroundColor: new Cesium.Color(1, 1, 1, 0.8)
                });
                // 关闭悬浮事件
                that._closeMouseMovePopup();
            }, Cesium.ScreenSpaceEventType.LEFT_DOUBLE_CLICK);
        },

        // 贴地直线
        _drawGroundLine: function () {
            // 所有点坐标
            var points = [];

            var that = this;

            // 长度数组，方便删除上个线段长度
            var lengthArray = [];
            // 子节点popup窗id
            var childrenPopup = [];

            // 移动生成的点
            var resultPoint = [];
            // 移动的图形
            var activeShape;

            // 增加图形的方法
            function drawShape(positionData) {
                var shape;
                shape = viewer.entities.add({
                    polyline: {
                        positions: positionData,
                        // clampToGround: true,
                        width: 3,
                        material: Cesium.Color.RED,
                        depthFailMaterial: Cesium.Color.RED // 线在视野范围看不到时的material
                    },
                    id: drawId
                });

                return shape;
            }

            // 增加图形的方法
            function drawShapeDynamic(positionData) {
                var shape;
                shape = viewer.entities.add({
                    polyline: {
                        positions: positionData,
                        clampToGround: true, // 是否贴地
                        width: 3,
                        material: Cesium.Color.RED,
                        depthFailMaterial: Cesium.Color.RED // 线在视野范围看不到时的material
                    }
                });

                return shape;
            }

            this.handler.setInputAction(function (click) {
                var point = viewer.scene.pickPosition(click.position);
                if (points.length === 0) {
                    points.push(point);
                    var dynamicPositions = new Cesium.CallbackProperty(function () {
                        return points;
                    }, false);
                    activeShape = drawShapeDynamic(dynamicPositions);
                }
                points.push(point);
                resultPoint.push(point);
                // 计算长度并生成自带的弹出框
                if (resultPoint.length > 1) {
                    var distance = new Cesium.EllipsoidGeodesic(
                        Cesium.Cartographic.fromCartesian(resultPoint[resultPoint.length - 2]),
                        Cesium.Cartographic.fromCartesian(resultPoint[resultPoint.length - 1]));
                    lengthArray.push(distance._distance);

                    $(".main-map-popup").hide();

                    if (distance._distance > 1) {
                        console.log('distance: '+distance._distance);
                        var content = '<div class="draw-measure-pop"> <span>' + distance._distance.toFixed(2) + '米</span></div>';
                        Popup.open({
                            content: content,
                            position: click.position,
                            offset: "top",
                            hasTriangle: false,
                            hasClose: false
                        });

                        childrenPopup.push(Popup.getId());
                    }

                }

            }, Cesium.ScreenSpaceEventType.LEFT_CLICK);

            this.handler.setInputAction(function (mouseMove) {
                if (!this.leftDown) {
                    if (points.length > 1) {
                        var newPosition = viewer.scene.pickPosition(mouseMove.endPosition);
                        if (Cesium.defined(newPosition)) {
                            points.pop();
                            points.push(newPosition);
                        }
                    }
                }
                // 生成鼠标移动的popup窗
                that._mouseMovePop(mouseMove.endPosition, "groundLine");
            }, Cesium.ScreenSpaceEventType.MOUSE_MOVE);

            this.handler.setInputAction(function (click) {
                // 关闭监听事件
                that._closeMouseEvent(that.handler);
                resultPoint.push(viewer.scene.pickPosition(click.position));
                var resultShape = drawShape(resultPoint);
                setTimeout(function () {
                    viewer.entities.remove(activeShape);
                    activeShape = undefined;
                }, 1000);

                if (resultPoint.length > 1) {
                    var distance = new Cesium.EllipsoidGeodesic(
                        Cesium.Cartographic.fromCartesian(resultPoint[resultPoint.length - 2]),
                        Cesium.Cartographic.fromCartesian(resultPoint[resultPoint.length - 1]));
                    lengthArray.push(distance._distance);
                }

                resultPoint = [];
                // 关闭悬浮事件
                that._closeMouseMovePopup();

                // 生成总长度的label
                var length = 0;
                for (var i = 0; i < lengthArray.length; i++) {
                    length += lengthArray[i];
                }

                if (length!==0) {
                    console.log('length: '+length);
                    var tempId = _.uniqueId() + "Draw";
                    var content = '<div class="draw-measure-pop"> <span>总长度：' + length.toFixed(2) + '米</span>' +
                        '<span class="icon-f-analysis-delete measure-close-icon " id="' + tempId + '"></span></div>';

                    Popup.open({
                        content: content,
                        position: click.position,
                        offset: "top",
                        hasTriangle: false,
                        hasClose: false
                    });
                    var popupId = "#" + tempId;
                    that.popupAll.push(popupId);
                    $(popupId).on('click', function (e) {
                        Popup.close(e);
                        viewer.entities.remove(resultShape);

                        // 关闭弹出窗
                        $.each(childrenPopup, function (index, value) {
                            Popup.closeById(value)
                        });
                    });
                }


            }, Cesium.ScreenSpaceEventType.RIGHT_CLICK);

        },

        // 高度
        _drawHeight: function () {
            var that = this;
            var handler = new Cesium.ScreenSpaceEventHandler(viewer.scene.canvas);
            // 先关闭所有事件
            this._closeMouseEvent(handler);
            // 初始化起始点的世界坐标和起始点的经纬度坐标
            var originPoint, originHeight;
            // 线的材质和样式
            var appearance = new Cesium.PolylineMaterialAppearance({
                material: Cesium.Material.fromType('Color')
            });

            // 设置click事件，第一次点击
            handler.setInputAction(function (click) {
                if (originHeight === undefined) {
                    originPoint = viewer.scene.pickPosition(click.position);
                    originHeight = Cesium.Cartographic.fromCartesian(originPoint);
                } else {
                    handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                    handler.removeInputAction(Cesium.ScreenSpaceEventType.MOUSE_MOVE);
                }
            }, Cesium.ScreenSpaceEventType.LEFT_CLICK);

            // 所有线的添加的集合，字体集合，字体添加的类，贴地线的实体
            var allPolyline, labels, labelHeight, distancePrimitive;
            // 字体部分
            labels = viewer.scene.primitives.add(new Cesium.LabelCollection());

            // 鼠标移动事件
            handler.setInputAction(function (e) {
                var promise = Cesium.GroundPolylinePrimitive.initializeTerrainHeights();
                promise.then(function () {
                    if (originPoint !== undefined) {
                        // 移动点世界坐标
                        var movePoint = viewer.scene.pickPosition(e.endPosition);
                        // 移动点经纬度坐标
                        var middleHeight = Cesium.Cartographic.fromCartesian(movePoint);
                        // 高差
                        var heightDifferent = Math.abs(originHeight.height - middleHeight.height).toFixed(2);
                        // 判断高差位置在起始点还是在移动点
                        if (middleHeight.height > originHeight.height) {
                            middleHeight.latitude = originHeight.latitude;
                            middleHeight.longitude = originHeight.longitude;
                        } else {
                            middleHeight.height = originHeight.height;
                        }
                        // 高点
                        var middlePoint = viewer.scene.globe.ellipsoid.cartographicToCartesian(middleHeight);

                        // 平面坐标集合
                        var pointsDistance = [];
                        pointsDistance.push(originPoint);
                        pointsDistance.push(movePoint);
                        // 高差坐标集合
                        var pointsHeight = [];
                        pointsHeight.push(movePoint);
                        pointsHeight.push(middlePoint);
                        // 水平坐标集合
                        var pointsLevel = [];
                        pointsLevel.push(originPoint);
                        pointsLevel.push(middlePoint);

                        // 所有生成的面
                        var allGeometry = [];
                        // 贴地线的类
                        var distanceToGround = new Cesium.GeometryInstance({
                            geometry: new Cesium.GroundPolylineGeometry({
                                positions: pointsDistance,
                                width: 4.0
                            })
                        });
                        // 生成线实体
                        allGeometry.push(that._createSpaceLineWithId(pointsHeight, "heightToGround"));
                        allGeometry.push(that._createSpaceLineWithId(pointsLevel, "heightLevel"));

                        // 从中间点的世界坐标转换成经纬度防止浅拷贝
                        var heightLabelPoint;
                        heightLabelPoint = Cesium.Cartographic.fromCartesian(middlePoint);
                        heightLabelPoint.height = heightLabelPoint.height - heightDifferent / 2;
                        // 中间点坐标
                        var eyeOffset = viewer.scene.globe.ellipsoid.cartographicToCartesian(heightLabelPoint);

                        if (allPolyline === undefined) {
                            distancePrimitive = viewer.scene.primitives.add(new Cesium.GroundPolylinePrimitive({
                                geometryInstances: distanceToGround,
                                asynchronous: false
                            }));
                            allPolyline = viewer.scene.primitives.add(new Cesium.Primitive({
                                geometryInstances: allGeometry,
                                appearance: appearance,
                                asynchronous: false
                            }));
                            labelHeight = labels.add({
                                position: eyeOffset,
                                text: "高差: " + heightDifferent + " 米",
                                scale: 0.8,
                                font: 'normal small-caps 25px 楷体',
                                disableDepthTestDistance: Number.POSITIVE_INFINITY,
                                fillColor: Cesium.Color.RED,
                                showBackground: true,
                                backgroundColor: new Cesium.Color(1, 1, 1, 0.8)
                            });
                        } else {
                            labels.remove(labelHeight);
                            viewer.scene.primitives.remove(allPolyline);
                            viewer.scene.primitives.remove(distancePrimitive);
                            allPolyline = viewer.scene.primitives.add(new Cesium.Primitive({
                                geometryInstances: allGeometry,
                                appearance: appearance,
                                asynchronous: false
                            }));
                            distancePrimitive = viewer.scene.primitives.add(new Cesium.GroundPolylinePrimitive({
                                geometryInstances: distanceToGround,
                                asynchronous: false
                            }));
                            labelHeight = labels.add({
                                position: eyeOffset,
                                text: "高差: " + heightDifferent + " 米",
                                scale: 0.8,
                                font: 'normal small-caps 25px 楷体',
                                disableDepthTestDistance: Number.POSITIVE_INFINITY,
                                fillColor: Cesium.Color.RED,
                                showBackground: true,
                                backgroundColor: new Cesium.Color(1, 1, 1, 0.8)
                            });

                        }
                    }
                });
            }, Cesium.ScreenSpaceEventType.MOUSE_MOVE);

        },

        // 测平面
        _drawSpaceSurface: function () {
            // 所有点坐标
            var points = [];
            var that = this;

            // 计算长度的label
            var labelsPrimitive = viewer.scene.primitives.add(new Cesium.LabelCollection());
            // 显示面积的label
            var labels;

            var appearance = new Cesium.PerInstanceColorAppearance();

            var movePolylinePrimitive;
            var movePolygonInstance;
            var polyGeometryInstance, polyPrimitive;
            this.handler.setInputAction(function (click) {
                var cartesian = viewer.scene.pickPosition(click.position);
                points.push(cartesian);
                if (points.length > 3) {
                    viewer.scene.primitives.remove(polyPrimitive);
                    polyGeometryInstance = that._createSpaceSurfaceWithId(points, "spaceSurface");
                    polyPrimitive = new Cesium.Primitive({
                        geometryInstances: polyGeometryInstance,
                        appearance: appearance,
                        asynchronous: false
                    });
                    viewer.scene.primitives.add(polyPrimitive);
                } else if (points.length === 3) {
                    polyGeometryInstance = that._createSpaceSurfaceWithId(points, "spaceSurface");
                    polyPrimitive = new Cesium.Primitive({
                        geometryInstances: polyGeometryInstance,
                        appearance: appearance,
                        asynchronous: false
                    });
                    viewer.scene.primitives.add(polyPrimitive);
                }
            }, Cesium.ScreenSpaceEventType.LEFT_CLICK);
            this.handler.setInputAction(function (mouseMove) {
                var movePoint = viewer.scene.pickPosition(mouseMove.endPosition);
                if (points.length > 0) {
                    if (Cesium.defined(movePolygonInstance)) {
                        viewer.scene.primitives.remove(movePolygonInstance);
                    }
                    if (points.length > 1) {
                        viewer.scene.primitives.remove(movePolylinePrimitive);
                        labelsPrimitive.remove(labels);
                        points.push(movePoint);
                        var distance = that._countAreaInCartesian3(points);
                        points.pop();
                        labels = that._createSpaceSurfaceArea(mouseMove.endPosition, labels, labelsPrimitive, distance)
                    } else {
                        // 移动点世界坐标
                        var moveCartesian3 = viewer.scene.pickPosition(mouseMove.endPosition);
                        // 生成移动线段的实体
                        if (moveCartesian3 !== undefined) {// 线的材质和样式
                            var lineAppearance = new Cesium.PolylineMaterialAppearance({
                                material: Cesium.Material.fromType('Color')
                            });
                            movePolylinePrimitive = that._createTempSpaceLine(mouseMove.endPosition,
                                points, lineAppearance, movePolylinePrimitive);
                        }
                    }
                    movePolygonInstance = that._createTempSpaceSurface(points, movePoint, appearance);
                    viewer.scene.primitives.add(movePolygonInstance);
                }
            }, Cesium.ScreenSpaceEventType.MOUSE_MOVE);
            this.handler.setInputAction(function (click) {
                // 关闭监听事件
                that._closeMouseEvent(that.handler);
                // 移除多余的一个点
                points.pop();
            }, Cesium.ScreenSpaceEventType.LEFT_DOUBLE_CLICK);
            this.handler.setInputAction(function (click) {
                if (points.length > 0) {
                    var position = viewer.scene.pickPosition(click.position);
                    viewer.scene.primitives.remove(movePolygonInstance);
                    points.pop();
                    if (points.length > 0) {
                        viewer.scene.primitives.remove(polyPrimitive);
                        polyGeometryInstance = that._createSpaceSurfaceWithId(points, "spaceSurface");
                        polyPrimitive = new Cesium.Primitive({
                            geometryInstances: polyGeometryInstance,
                            appearance: appearance,
                            asynchronous: false
                        });
                        viewer.scene.primitives.add(polyPrimitive);
                        movePolygonInstance = that._createTempSpaceSurface(points, position, appearance);
                        viewer.scene.primitives.add(movePolygonInstance);
                        labelsPrimitive.remove(labels);
                        if (points.length > 1) {
                            points.push(position);
                            var distance = that._countAreaInCartesian3(points);
                            points.pop();
                            labels = that._createSpaceSurfaceArea(click.position, labels, labelsPrimitive, distance)
                        } else {
                            // 移动点世界坐标
                            var moveCartesian3 = viewer.scene.pickPosition(click.position);
                            // 生成移动线段的实体
                            if (moveCartesian3 !== undefined) {// 线的材质和样式
                                var lineAppearance = new Cesium.PolylineMaterialAppearance({
                                    material: Cesium.Material.fromType('Color')
                                });
                                movePolylinePrimitive = that._createTempSpaceLine(click.position,
                                    points, lineAppearance, movePolylinePrimitive);
                            }
                        }
                    } else {
                        viewer.scene.primitives.remove(movePolylinePrimitive);
                    }
                }
            }, Cesium.ScreenSpaceEventType.RIGHT_CLICK);

        },

        // 测贴地面
        _drawGroundSurface: function () {
            // 所有点坐标
            var that = this;

            // 移动点，绘制点和移动图形
            var points = [];
            var resultPoint = [];
            var activeShape;
            var polygonId = drawId;

            // 增加图形的方法
            function drawShape(positionData) {
                var shape;
                shape = viewer.entities.add({
                    polygon: {
                        hierarchy: positionData,
                        material: new Cesium.ColorMaterialProperty(Cesium.Color.BLUE.withAlpha(0.3)),
                        outline: true,
                        outlineColor: Cesium.Color.RED,
                        outlineWidth: 4
                    },
                    id: polygonId
                });

                return shape;
            }

            this.handler.setInputAction(function (click) {
                var point = viewer.scene.pickPosition(click.position);
                if (points.length === 0) {
                    points.push(point);
                    var dynamicPositions = new Cesium.CallbackProperty(function () {
                        return points;
                    }, false);
                    activeShape = drawShape(dynamicPositions);
                }
                points.push(point);
                resultPoint.push(point);
            }, Cesium.ScreenSpaceEventType.LEFT_CLICK);

            this.handler.setInputAction(function (mouseMove) {
                if (!this.leftDown) {
                    if (points.length > 0) {
                        var newPosition = viewer.scene.pickPosition(mouseMove.endPosition);
                        if (Cesium.defined(newPosition)) {
                            points.pop();
                            points.push(newPosition);
                        }
                    }

                }
                // 生成鼠标移动的popup窗
                that._mouseMovePop(mouseMove.endPosition, "groundSurface");
            }, Cesium.ScreenSpaceEventType.MOUSE_MOVE);

            this.handler.setInputAction(function (click) {
            }, Cesium.ScreenSpaceEventType.LEFT_DOUBLE_CLICK);

            this.handler.setInputAction(function (click) {
                // 关闭监听事件
                that._closeMouseEvent(that.handler);
                resultPoint.push(viewer.scene.pickPosition(click.position));
                if (drawId) {
                    EventBus.trigger(drawId, MapUtils.drawGeometryPolygonToFeatureCollection(resultPoint));
                    drawId = undefined;
                }
                var resultShape = drawShape(resultPoint);
                setTimeout(function () {
                    viewer.entities.remove(activeShape);
                    activeShape = undefined;
                }, 1000);
                // 关闭悬浮事件
                that._closeMouseMovePopup();
                var temp = Number(that._countAreaInCartesian3(resultPoint));
                var area = temp > 1000000 ? (temp / 1000000).toFixed(2) + 'km²' : temp.toFixed(2) + '㎡';

                var tempId = _.uniqueId() + "Draw";
                var content = '<div class="draw-measure-pop"> <span>面积：' + area + '</span>' +
                    '<span class="icon-f-analysis-delete measure-close-icon" id="' + tempId + '"></span></div>';

                resultPoint = [];
                Popup.open({
                    content: content,
                    position: click.position,
                    offset: "top",
                    hasTriangle: false,
                    hasClose: false
                });
                var popupId = "#" + tempId;
                that.popupAll.push(popupId);
                // 绑定关闭按钮事件
                $(popupId).on('click', function (e) {
                    Popup.close(e);
                    viewer.entities.remove(resultShape);
                });

            }, Cesium.ScreenSpaceEventType.RIGHT_CLICK);
        },

        // 测贴地圆面
        _drawCircleSurface: function () {
            // 所有点坐标
            var that = this;

            // 移动点，绘制点和移动图形
            var centerPoint;
            var tmpDistance = 1;
            var resultDistance;
            var activeShape;

            // 增加图形的方法
            function drawShape(position, distance) {
                var shape;
                shape = viewer.entities.add({
                    position: position,
                    ellipse: {
                        semiMinorAxis: distance,
                        semiMajorAxis: distance,
                        material: Cesium.Color.BLUE.withAlpha(0.3)
                    }
                });

                return shape;
            }

            this.handler.setInputAction(function (click) {
                var point = viewer.scene.pickPosition(click.position);
                if (!centerPoint) {
                    centerPoint = point;
                    tmpDistance = 1;
                    var dynamicDistance = new Cesium.CallbackProperty(function () {
                        return tmpDistance;
                    }, false);
                    activeShape = drawShape(centerPoint, dynamicDistance);
                }
            }, Cesium.ScreenSpaceEventType.LEFT_CLICK);
            this.handler.setInputAction(function (mouseMove) {
                if (!this.leftDown) {
                    if (centerPoint) {
                        var newPosition = viewer.scene.pickPosition(mouseMove.endPosition);
                        if (Cesium.defined(newPosition)) {
                            tmpDistance = Cesium.Cartesian3.distance(centerPoint, newPosition);
                        }
                    }
                }
                // 生成鼠标移动的popup窗
                that._mouseMovePop(mouseMove.endPosition, "circleSurface");
            }, Cesium.ScreenSpaceEventType.MOUSE_MOVE);
            this.handler.setInputAction(function (click) {
            }, Cesium.ScreenSpaceEventType.LEFT_DOUBLE_CLICK);
            this.handler.setInputAction(function (click) {
                // 关闭监听事件
                that._closeMouseEvent(that.handler);
                resultDistance = Cesium.Cartesian3.distance(centerPoint, viewer.scene.pickPosition(click.position));
                if (drawId) {
                    // EventBus.trigger(drawId, MapUtils.drawGeometryPolygonToFeatureCollection(resultPoint));
                    drawId = undefined;
                }
                var resultShape = drawShape(centerPoint, resultDistance);
                setTimeout(function () {
                    viewer.entities.remove(activeShape);
                    activeShape = undefined;
                }, 1000);
                // 关闭悬浮事件
                that._closeMouseMovePopup();
                var temp = Math.PI * resultDistance * resultDistance;
                var area = temp > 1000000 ? (temp / 1000000).toFixed(2) + 'km²' : temp.toFixed(2) + '㎡';

                var tempId = _.uniqueId() + "Draw";
                var content = '<div class="draw-measure-pop"> <span>面积：' + area + '</span>' +
                    '<span class="icon-f-analysis-delete measure-close-icon" id="' + tempId + '"></span></div>';

                centerPoint = null;
                resultDistance = null;
                Popup.open({
                    content: content,
                    position: click.position,
                    offset: "top",
                    hasTriangle: false,
                    hasClose: false
                });
                var popupId = "#" + tempId;
                that.popupAll.push(popupId);
                // 绑定关闭按钮事件
                $(popupId).on('click', function (e) {
                    Popup.close(e);
                    viewer.entities.remove(resultShape);
                });

            }, Cesium.ScreenSpaceEventType.RIGHT_CLICK);
        },

        // 生成临时线的方法，包括移除上一条线的方法
        _createTempSpaceLine: function (position, points, appearance, movePolylinePrimitive) {
            if (Cesium.defined(movePolylinePrimitive)) {
                viewer.entities.remove(movePolylinePrimitive);
            }
            var mousePoint = viewer.scene.pickPosition(position);
            // 存放临时线的两点
            var movePoints = [];
            movePoints.push(points[points.length - 1]);
            movePoints.push(mousePoint);
            // 移动线的实例
            var movePolylineInstance = this._createSpaceLineWithId(movePoints, "movePolyline");
            return viewer.scene.primitives.add(new Cesium.Primitive({
                geometryInstances: movePolylineInstance,
                appearance: appearance,
                asynchronous: false
            }));
        },

        // 生成直线的方法，需要传入线的全部点坐标，返回生成的线实例
        _createSpaceLineWithId: function (positions, id) {
            // 生成临时点坐标
            var temp = [];
            temp.push(positions[positions.length - 1]);
            temp.push(positions[positions.length - 2]);
            return new Cesium.GeometryInstance({
                geometry: new Cesium.PolylineGeometry({
                    positions: temp,
                    width: 2.0,
                    vertexFormat: Cesium.PolylineMaterialAppearance.VERTEX_FORMAT
                }),
                id: id
            });
        },

        // 关闭所有监听事件
        _closeMouseEvent: function (handler) {
            handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
            handler.removeInputAction(Cesium.ScreenSpaceEventType.MOUSE_MOVE);
            handler.removeInputAction(Cesium.ScreenSpaceEventType.RIGHT_CLICK);
            handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_DOUBLE_CLICK);
            handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_DOWN);
            handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_UP);
        },

        // 鼠标悬浮pop窗
        _mouseMovePop: function (position, type) {
            var popId = document.getElementById("drawMouseMove");
            if (!popId) {
                var popElement = document.createElement("div");
                var tip;
                switch (type) {
                    case "groundSurface":
                        tip = "单击增加点，右击完成绘制";
                        break;
                    case "circleSurface":
                        tip = "单击确定圆心，右击完成绘制";
                        break;
                    default:
                        tip = "单击增加点，右击完成绘制";
                        break;
                }
                popElement.innerHTML = '<div class="draw-mouse-move-popup" id="drawMouseMove">' + tip + '</div>';
                var body = document.getElementsByClassName('cesium-viewer')[0];
                body.appendChild(popElement);
                popId = document.getElementById("drawMouseMove");
            }
            popId.style.display = "block";
            popId.style.left = position.x + 15 + "px";
            popId.style.top = position.y + 15 + "px";
            popId.style.width = "auto";
            popId.style.height = "auto";
            popId.style.backgroundColor = "#ffffff";
            popId.style.position = "absolute";
            popId.style.color = "#7a8188";
            popId.style.border = "1px solid red";
            popId.style.padding = "5px";
        },

        // 关闭鼠标悬浮样式
        _closeMouseMovePopup: function () {
            var popId = document.getElementById("drawMouseMove");
            popId.style.display = "none";
        },

        // 生成贴地直线方法，需要传入点坐标，返回生成的线实例
        _createGroundLineWithId: function (positions, id) {
            // 生成临时点坐标
            var temp = [];
            temp.push(positions[positions.length - 1]);
            temp.push(positions[positions.length - 2]);
            return new Cesium.GeometryInstance({
                geometry: new Cesium.GroundPolylineGeometry({
                    positions: temp,
                    width: 4.0
                }),
                id: id
            });
        },

        // 生成临时线的方法，包括移除上一条线的方法
        _createTempGroundLine: function (position, points, movePolylinePrimitive, lineCollection) {
            // if (movePolylinePrimitive) {
            //     viewer.scene.primitives.remove(movePolylinePrimitive);
            // }
            var mousePoint = viewer.scene.pickPosition(position);
            // 存放临时线的两点
            var movePoints = [];
            movePoints.push(points[points.length - 1]);
            movePoints.push(mousePoint);
            // 移动线的实例
            var movePolylineInstance = this._createGroundLineWithId(movePoints, "movePolyline");
            var promise = Cesium.GroundPolylinePrimitive.initializeTerrainHeights();
            // promise.then(function () {
            var temp = lineCollection.add(new Cesium.GroundPolylinePrimitive({
                geometryInstances: movePolylineInstance,
                asynchronous: false
            }));
            return temp;
            // });
        },

        // 生成临时长度框
        _createTempLabel: function (position1, position2, moveLabels, moveLastLabel, positionXY) {
            var distance = Cesium.Cartesian3.distance(position1, position2);
            // label方式的移动表达
            // if (moveLabels._labels.length !== 0) {
            //     moveLabels.remove(moveLastLabel);
            // }
            // // 生成移动线段的长度label
            // position1.z += 250;
            // position1.y -= 250;
            // position1.x -= 250;
            // return moveLabels.add({
            //     position: position1,
            //     text: distance.toFixed(2) + " 米",
            //     scale: 0.8,
            //     font: 'normal small-caps 25px 楷体',
            //     disableDepthTestDistance: Number.POSITIVE_INFINITY
            // });

            // 悬浮div的表达方式
            $(".main-map-popup").show();
            var content = "<span>" + distance.toFixed(2) + "米</span>";
            $(".main-map-popup").css('left', positionXY.x + 15 + 'px');
            $(".main-map-popup").css('top', positionXY.y + 15 + 'px');
            $(".main-map-popup").html(content);
        },

        // 生成临时贴地框
        _createGroundTempLabel: function (position1, position2, moveLabels, moveLastLabel, positionXY) {
            var distance = new Cesium.EllipsoidGeodesic(
                Cesium.Cartographic.fromCartesian(position1),
                Cesium.Cartographic.fromCartesian(position2));
            // if (moveLabels._labels.length !== 0) {
            //     moveLabels.remove(moveLastLabel);
            // }
            // // 生成移动线段的长度label
            // position1.z += 250;
            // position1.y -= 250;
            // position1.x -= 250;
            // return moveLabels.add({
            //     position: position1,
            //     text: distance._distance.toFixed(2) + " 米",
            //     scale: 0.8,
            //     font: 'normal small-caps 25px 楷体',
            //     disableDepthTestDistance: Number.POSITIVE_INFINITY
            // });

            // 悬浮div的表达方式
            $(".main-map-popup").show();
            var content = "<span>" + distance._distance.toFixed(2) + "米</span>";
            $(".main-map-popup").css('left', positionXY.x + 15 + 'px');
            $(".main-map-popup").css('top', positionXY.y + 15 + 'px');
            $(".main-map-popup").html(content);
        },

        // 生成贴地面
        _createGroundSurfaceWithId: function (positions, id) {
            return new Cesium.GeometryInstance({
                geometry: new Cesium.PolygonGeometry({
                    polygonHierarchy: new Cesium.PolygonHierarchy(positions)
                }),
                id: id,
                attributes: {
                    color: Cesium.ColorGeometryInstanceAttribute.fromColor(Cesium.Color.AQUA)
                }
            });
        },

        // 生成临时贴地面
        _createTempGroundSurface: function (position, movePoint, appearance) {
            var points = [];
            points.push(position[0]);
            points.push(position[position.length - 1]);
            points.push(movePoint);
            var temp = this._createGroundSurfaceWithId(points, "tempGroundSurface");
            return new Cesium.GroundPrimitive({
                geometryInstances: temp,
                appearance: appearance,
                asynchronous: false
            });
        },

        // 生成圆面
        _createCircleSurfaceWithId: function (centerPoint, distance, id) {
            return new Cesium.GeometryInstance({
                geometry: new Cesium.CircleGeometry({
                    center: centerPoint,
                    redius: distance
                }),
                id: id,
                attributes: {
                    color: Cesium.ColorGeometryInstanceAttribute.fromColor(Cesium.Color.AQUA)
                }
            });
        },

        // 生成临时圆面
        _createTempCircleSurface: function (centerPoint, movePoint, appearance) {
            var distance = Cesium.Cartesian3.distance(centerPoint, movePoint);
            var temp = this._createCircleSurfaceWithId(centerPoint, distance, "tempCircleSurface");
            return new Cesium.GroundPrimitive({
                geometryInstances: temp,
                appearance: appearance,
                asynchronous: false
            });
        },

        // 生成空间面
        _createSpaceSurfaceWithId: function (positions, id) {
            return new Cesium.GeometryInstance({
                geometry: new Cesium.PolygonGeometry.fromPositions({
                    positions: positions,
                    perPositionHeight: true
                }),
                id: id,
                attributes: {
                    color: Cesium.ColorGeometryInstanceAttribute.fromColor(Cesium.Color.CRIMSON)
                }
            });
        },

        // 生成临时空间面
        _createTempSpaceSurface: function (position, movePoint, appearance) {
            var points = [];
            points.push(position[0]);
            points.push(position[position.length - 1]);
            points.push(movePoint);
            var temp = this._createSpaceSurfaceWithId(points, "tempGroundSurface");
            return new Cesium.Primitive({
                geometryInstances: temp,
                appearance: appearance,
                asynchronous: false
            });
        },

        // 生成空间面积的label
        _createSpaceSurfaceArea: function (position, labels, labelsPrimitive, distance) {
            var labelPosition = viewer.scene.pickPosition(position);
            labelPosition.z += 10;
            labelPosition.y -= 10;
            labelPosition.x -= 10;
            labels = labelsPrimitive.add({
                position: labelPosition,
                text: distance.toFixed(2) + " 平方米",
                scale: 0.8,
                font: 'normal small-caps 25px 楷体',
                disableDepthTestDistance: Number.POSITIVE_INFINITY,
                fillColor: Cesium.Color.RED,
                showBackground: true,
                backgroundColor: new Cesium.Color(1, 1, 1, 0.8)
            });
            return labels;
        },

        // 计算面积方法
        _countAreaInCartesian3: function (ps) {
            var s = 0;
            for (var i = 0; i < ps.length; i++) {
                var p1 = ps[i];
                var p2;
                if (i < ps.length - 1)
                    p2 = ps[i + 1];
                else
                    p2 = ps[0];
                s += p1.x * p2.y - p2.x * p1.y;
            }
            return Math.abs(s / 2);
        }

    };

    return drawGeometry;
});