/**
 *  存储声明常量 静态声明的存储
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/4/29/14:22  Copyright gtmap Corp
 */

define(['jquery', 'Cesium', './GeographicTilingScheme'], function ($, Cesium, GeographicTilingScheme) {


    // TODO other params
    // GLOBAL_CONTAINER
    var GLOBAL_CONTAINER = 'globalContainer',

        leftWidgetDom = $('.left-widgets-pane'),

        toolWidgetDom = $('.tool-widgets-pane'),

        ellipsolid_4490 = new Cesium.Ellipsoid(6378137.0, 6378137.0, 6356752.3142451793),

        ellipsolid_4326 = new Cesium.Ellipsoid(6378137.0, 6378137.0, 6356752.31414035585),

        Ellipsolid_default = new Cesium.Ellipsoid(6378137.0, 6378137.0, 6378137.0),

        // 全球范围
        rectangle = Cesium.Rectangle.fromDegrees(-180, -90, 180, 90),

        geographicTilingScheme_4490 = new GeographicTilingScheme({
            ellipsoid: ellipsolid_4490,
            rectangle: rectangle,
            numberOfLevelZeroTilesX: 4,
            numberOfLevelZeroTilesY: 2
        }),

        geographicTilingScheme_4326 = new GeographicTilingScheme({
            ellipsoid: ellipsolid_4326,
            rectangle: rectangle,
            numberOfLevelZeroTilesX: 2,
            numberOfLevelZeroTilesY: 1
        }),

        // 天地图wtfs服务默认参数
        tiandituWTFS_options_default = {
            subdomains: ['8', '9', '10', '11'],
            metadata: {
                boundBox: {
                    minX: -180,
                    minY: -90,
                    maxX: 180,
                    maxY: 90
                },
                minLevel: 1,
                maxLevel: 20
            },
            aotuCollide: true,
            collisionPadding: [5, 10, 8, 5],
            serverFirstStyle: true,
            labelGraphics: {
                font: "28px sans-serif",
                fontSize: 28,
                fillColor: Cesium.Color.DARKGREY,
                scale: .5,
                outlineColor: Cesium.Color.BLACK,
                outlineWidth: 3.125,
                style: Cesium.LabelStyle.FILL_AND_OUTLINE,
                showBackground: false,
                backgroundColor: Cesium.Color.RED,
                backgroundPadding: new Cesium.Cartesian2(10, 10),
                horizontalOrigin: Cesium.HorizontalOrigin.MIDDLE,
                verticalOrigin: Cesium.VerticalOrigin.TOP,
                eyeOffset: Cesium.Cartesian3.ZERO,
                pixelOffset: new Cesium.Cartesian2(0, 8)
            },
            billboardGraphics: {
                horizontalOrigin: Cesium.HorizontalOrigin.CENTER,
                verticalOrigin: Cesium.VerticalOrigin.CENTER,
                eyeOffset: Cesium.Cartesian3.ZERO,
                pixelOffset: Cesium.Cartesian2.ZERO,
                alignedAxis: Cesium.Cartesian3.ZERO,
                color: Cesium.Color.WHITE,
                rotation: 0,
                scale: 1,
                width: 18,
                height: 18
            }
        },

        tiandituWTFS_options_resolution = [
            {
                x: 6,
                y: 1,
                level: 2,
                boundBox: {
                    minX: 90,
                    minY: 0,
                    maxX: 135,
                    maxY: 45
                }
            }, {
                x: 7,
                y: 1,
                level: 2,
                boundBox: {
                    minX: 135,
                    minY: 0,
                    maxX: 180,
                    maxY: 45
                }
            }, {
                x: 6,
                y: 0,
                level: 2,
                boundBox: {
                    minX: 90,
                    minY: 45,
                    maxX: 135,
                    maxY: 90
                }
            }, {
                x: 7,
                y: 0,
                level: 2,
                boundBox: {
                    minX: 135,
                    minY: 45,
                    maxX: 180,
                    maxY: 90
                }
            }, {
                x: 5,
                y: 1,
                level: 2,
                boundBox: {
                    minX: 45,
                    minY: 0,
                    maxX: 90,
                    maxY: 45
                }
            }, {
                x: 4,
                y: 1,
                level: 2,
                boundBox: {
                    minX: 0,
                    minY: 0,
                    maxX: 45,
                    maxY: 45
                }
            }, {
                x: 5,
                y: 0,
                level: 2,
                boundBox: {
                    minX: 45,
                    minY: 45,
                    maxX: 90,
                    maxY: 90
                }
            }, {
                x: 4,
                y: 0,
                level: 2,
                boundBox: {
                    minX: 0,
                    minY: 45,
                    maxX: 45,
                    maxY: 90
                }
            }, {
                x: 6,
                y: 2,
                level: 2,
                boundBox: {
                    minX: 90,
                    minY: -45,
                    maxX: 135,
                    maxY: 0
                }
            }, {
                x: 6,
                y: 3,
                level: 2,
                boundBox: {
                    minX: 90,
                    minY: -90,
                    maxX: 135,
                    maxY: -45
                }
            }, {
                x: 7,
                y: 2,
                level: 2,
                boundBox: {
                    minX: 135,
                    minY: -45,
                    maxX: 180,
                    maxY: 0
                }
            }, {
                x: 5,
                y: 2,
                level: 2,
                boundBox: {
                    minX: 45,
                    minY: -45,
                    maxX: 90,
                    maxY: 0
                }
            }, {
                x: 4,
                y: 2,
                level: 2,
                boundBox: {
                    minX: 0,
                    minY: -45,
                    maxX: 45,
                    maxY: 0
                }
            }, {
                x: 3,
                y: 1,
                level: 2,
                boundBox: {
                    minX: -45,
                    minY: 0,
                    maxX: 0,
                    maxY: 45
                }
            }, {
                x: 3,
                y: 0,
                level: 2,
                boundBox: {
                    minX: -45,
                    minY: 45,
                    maxX: 0,
                    maxY: 90
                }
            }, {
                x: 2,
                y: 0,
                level: 2,
                boundBox: {
                    minX: -90,
                    minY: 45,
                    maxX: -45,
                    maxY: 90
                }
            }, {
                x: 0,
                y: 1,
                level: 2,
                boundBox: {
                    minX: -180,
                    minY: 0,
                    maxX: -135,
                    maxY: 45
                }
            }, {
                x: 1,
                y: 0,
                level: 2,
                boundBox: {
                    minX: -135,
                    minY: 45,
                    maxX: -90,
                    maxY: 90
                }
            }, {
                x: 0,
                y: 0,
                level: 2,
                boundBox: {
                    minX: -180,
                    minY: 45,
                    maxX: -135,
                    maxY: 90
                }
            }],

        lods_4490 = [
            {
                level: 0,
                resolution: 1.406250026231578,
                scale: 5.90995197141668E8
            }, {
                level: 1,
                resolution: 0.703125013115789,
                scale: 2.95497598570834E8
            }, {
                level: 2,
                resolution: 0.3515625065578945,
                scale: 1.47748799285417E8
            }, {
                level: 3,
                resolution: 0.17578125327894775,
                scale: 7.38743996427087E7
            }, {
                level: 4,
                resolution: 0.08789062663947399,
                scale: 3.69371998213544E7
            }, {
                level: 5,
                resolution: 0.043945313319736994,
                scale: 1.84685999106772E7
            }, {
                level: 6,
                resolution: 0.021972656659868472,
                scale: 9234299.95533859
            }, {
                level: 7,
                resolution: 0.010986328329934226,
                scale: 4617149.97766929
            }, {
                level: 8,
                resolution: 0.005493164164967124,
                scale: 2308574.98883465
            }, {
                level: 9,
                resolution: 0.0027465820824835504,
                scale: 1154287.49441732
            }, {
                level: 10,
                resolution: 0.0013732910412417797,
                scale: 577143.747208662
            }, {
                level: 11,
                resolution: 6.866455206208899E-4,
                scale: 288571.873604331
            }, {
                level: 12,
                resolution: 3.433227603104438E-4,
                scale: 144285.936802165
            }, {
                level: 13,
                resolution: 1.716613801552224E-4,
                scale: 72142.9684010827
            }, {
                level: 14,
                resolution: 8.583069007761132E-5,
                scale: 36071.4842005414
            }, {
                level: 15,
                resolution: 4.291534503880566E-5,
                scale: 18035.7421002707
            }, {
                level: 16,
                resolution: 2.1457672519402802E-5,
                scale: 9017.87105013534
            }, {
                level: 17,
                resolution: 1.0728836259701401E-5,
                scale: 4508.93552506767
            }, {
                level: 18,
                resolution: 5.364418129850712E-6,
                scale: 2254.46776253384
            }, {
                level: 19,
                resolution: 2.682209064925356E-6,
                scale: 1127.23388126692
            }, {
                level: 20,
                resolution: 1.341104532462678E-6,
                scale: 563.61694063346
            }
        ],

        INIT_MAP_HEIGHT_DEFAULT = 1100000;

    // 自定义球体
    var ellipsolid = {
        "EPSG:4490": ellipsolid_4490,
        "EPSG:4326": ellipsolid_4326,
        "ellipsolid_def": Ellipsolid_default
    };

    // 自定义切片规则
    var geographicTilingScheme = {
        "EPSG:4490": geographicTilingScheme_4490,
        "EPSG:4326": geographicTilingScheme_4326
    };


    var lods = {
        "EPSG:4490": lods_4490
    };

    return {
        GLOBAL_CONTAINER: GLOBAL_CONTAINER,
        leftWidgetDom: leftWidgetDom,
        toolWidgetDom: toolWidgetDom,
        ellipsolid: ellipsolid,
        tilingScheme: geographicTilingScheme,
        tiandituWTFS: {
            options: tiandituWTFS_options_default,
            resolution: tiandituWTFS_options_resolution
        },
        lods: lods,
        INIT_MAP_HEIGHT: INIT_MAP_HEIGHT_DEFAULT,
        RECTANGLE: rectangle
    }
})
;

