define([
    "global/utils/MapUtils",
    "Cesium"
],function (MapUtils,Cesium) {

    var layer,self;
    layui.use(['layer'], function() {
       layer = layui.layer;
    });
    function Onchange() {
        self = this;
        this._option = {
            startTime: Cesium.JulianDate.fromDate(new Date(2017,9,20,21,30,00)),
            stopTime: Cesium.JulianDate.addSeconds(Cesium.JulianDate.fromDate(new Date(2017,9,20,21,30,00)), 3600, new Cesium.JulianDate()),
            multiplier: 500,
            clockRange: Cesium.ClockRange.LOOP_STOP,
            shouldAnimate: true
        }
    }

    /*
    * 定义一个初始化的时间轴 ：参数|回调函数
    *
    * startTime:初始化一个起始时间
    * seconds:经过的秒数
    * multiplier:速率
    * clockRange:播放模式
    * shouldAnimate:起始播放
    *
    *
    */
    Onchange.prototype.init = function (option,callback) {
        this._viewer = MapUtils.viewer;
        this._gtLine = MapUtils.viewer.gtTimeLine;
        this._gtLine = MapUtils.viewer.gtTimeLine;
        this._clock =  MapUtils.viewer.clock;
        if(!option || !callback){
            layer.msg('缺少参数',{
                time:2000
            });
            return
        }
        // 合并传递参数
        $.extend(self._option,option);
        var start = self._option.startTime;
        //var stop = Cesium.JulianDate.addSeconds(start, self._option.seconds, new Cesium.JulianDate());
        var stop = self._option.stopTime;
        self._clock.startTime = start.clone();
        self._clock.currentTime = start.clone();
        self._clock.stopTime = stop.clone();
        self._clock.multiplier = self._option.multiplier;
        self._gtLine.zoomTo(start,stop);
        self._clock.clockRange = self._option.clockRange;
        self._clock.shouldAnimate = true;
        self._clock.onTick.addEventListener(function () {
            var delTime = Cesium.JulianDate.secondsDifference(self._clock.currentTime, self._clock.startTime);
            callback(delTime);
        })
    };

    Onchange.prototype.destroy = function () {
        
    };


    return new Onchange;
});