define([
    'knockout',
    'global/utils/WidgetUtils'
],function (
    ko, WidgetUtils) {

  var that,LISTEN;
  function SliderTimeLine() {
      that = this;
      this.year = ko.observable("");
      this.allYears = ko.observable("");
      this.list = ko.observableArray(initTime());
  }

  SliderTimeLine.prototype = {
      /**
       * 控制折叠样式
       * @param btn
       * @param e
       */
      fold: function (btn, e) {
          if($(e.target).hasClass("icon-f-left")){
              $(".slider-time-tip").hide();
              var length = that.allYears().length * 80 + "px";
              $(".controls-slider-timeLine").animate({
                  width: length
              }, 500, 'swing', function () {
                  $(".slider-tip-all-year").show();
                  $(e.target).removeClass("icon-f-left").addClass("icon-f-right");
              }).addClass("slider-fold-shadow");
          }else {
              $(".slider-time-tip").show();
              $(".slider-tip-all-year").hide();
              $(".controls-slider-timeLine").animate({
                  width: "180px"
              }, 500, 'swing', function () {
                  $(e.target).removeClass("icon-f-right").addClass("icon-f-left");
              }).removeClass("slider-fold-shadow");
          }
      },

      /**
       * 传递默认年份值
       * @param string
       */
      setYear: function (string, years) {
          this.year(string);
          this.allYears(years);
      },

      moveonScale: function (btn,e) {
          if(btn.isDefault) {
              // $(e).css("background", "white !important")
              // $(".slider-scale-left").addClass('test-add-class')
              // $(e.currentTarget).css("background", "white")
          }
      },

      /**
       * 点击刻度更新状态
       * @param btn
       * @param e
       */
      clickScale: function (btn,event) {
          that.year(btn.year);
          $.each(that.list(),function (i,e) {
              var temp = clone(e);
              temp.isDefault = (btn.year === e.year)?true:false
              that.list.replace(e,temp);
          });
          if(LISTEN) {
              LISTEN(btn);
          }
      },

      /**
       * 监听刻度变化事件
       * @param event
       */
      addEventListen: function (event) {
          LISTEN = event;
      },

      /**
       * 清除监听
       */
      clearEventListen: function () {
          LISTEN = null;
      },

      /**
       * 提供更新时间轴的接口
       * @param data
       */
      update: function (data) {
          if(data.defaultYear){
              updataBaseLayer(data)
              $(".controls-slider-timeLine").show();
          }else {
              $(".controls-slider-timeLine").hide();
          }
      }
  };

  /*******************************【逻辑层】***********/

  /*根据系统时间塞默认时间年份*/
  function initTime() {
      // 获取默认底图的时间轴情况
      var options = WidgetUtils.appConfig.baseLayer;
      // 获取地图切换配置
      var hisLayers;
      $.each(WidgetUtils._controlConfig, function (index, value) {
          if(value.id === "baseLayerCard")
              hisLayers = value
      });
      // 是否需要展示时间轴
      var showTimeLine = false;
      var layers = [];
      $.each(hisLayers.config.hisLayers, function (index, value) {
          if(options[0].id === value.parentId && value.hasOwnProperty("layers") && value.layers.length > 0){
              $.each(value.layers, function (count, temp) {
                  (temp.year === value.defaultYear)?layers.push({year:temp.year,isDefault:true}):layers.push({year:temp.year,isDefault:false})
              });
              that.setYear(value.defaultYear, layers);
              showTimeLine = true;
          }
      });
      if(!showTimeLine) {
          setTimeout(function () {
              $(".controls-slider-timeLine").hide();
          }, 100)
      }
      return layers;
  }


    /**
     * clone
     * @param source
     * @returns {{}}
     */
   function clone(source) {
        var obj = {};
        for (var p in source)
            obj[p] = source[p];
        return obj;
    }


    /**
     * 处理底图切换逻辑
     * @param data
     */
   function updataBaseLayer(data) {
       var defaultYear = data.defaultYear;
       var allYears = [];
       var hisLayers = JSON.parse(JSON.stringify(data.hisLayers));
       $.each(hisLayers,function (i, e) {
           e.isDefault = (defaultYear === e.year.toString())? true: false
       });
        that.year(defaultYear);
        that.list(hisLayers);
        that.allYears(hisLayers);
       if($(".controls-slider-timeLine").width() !== 180){
           var length = that.allYears().length * 80 + "px";
           $(".controls-slider-timeLine").animate({
               width: length
           }, 500, 'swing')
       }
   }




  return  SliderTimeLine;
});