define([
    'Cesium',
    './TimeLineViewModel',
    'jquery',
    'global/core/index',
    'global/utils/WidgetUtils',
    './TimeLineSliderViewModel',
    'text!./timeLineTpl.html'
], function(
    Cesium,
    TimeLine,
    $,
    Utils,
    WidgetUtils,
    STimeLine,
    STimeLineTpl) {
    'use strict';

    //<#--timeline-->

    var timeLineTemplate = "<div class=\"cesium-controls-timeline\">\n" +
        "            <div class=\"icon-f-pauseTimeline gt-timeline-pause\"></div>\n" +
        "            <div id=\"timeControlsContainer\"></div>\n" +
        "            </div>";

    var timeLineSlider = STimeLineTpl;

    var controlConfig = [],timeLineConfig = {};

    /**
     * 渲染viewModel
     * @param viewerCesiumWidget
     * @param controlContainer
     */
    function createTimeLine(viewerCesiumWidget, controlContainer) {
        try {
            controlConfig = WidgetUtils._controlConfig;

            if (!Cesium.defined(viewerCesiumWidget)) {
                throw new Cesium.DeveloperError('CesiumWidget or Viewer is required.');
            }
            if (!Cesium.defined(controlContainer)) {
                throw new Cesium.DeveloperError('controlContainer or Viewer is required.');
            }
            // 拿到时间轴配置
            $.each(controlConfig,function (i,e) {
                if(e.id === "timeLine"){
                    timeLineConfig = e.config.styles;
                }
            });

            // 读取渲染时间轴
            $.each(timeLineConfig,function (i,e) {
                if(e.id === "clock" && e.display){
                    initClockTimeLine(viewerCesiumWidget, controlContainer);
                }else if(e.id === "slider" && e.display){
                    initSliderTimeLine(viewerCesiumWidget, controlContainer);
                }
            });
        }catch (e){
            console.log(e);
        }
    }

    /**
     * 初始化复写的cesium时间轴
     * @param viewerCesiumWidget
     * @param controlContainer
     */
    function initClockTimeLine(viewerCesiumWidget, controlContainer) {
        $(controlContainer).append(timeLineTemplate);
        for(var i=0;i<controlConfig.length;i++){
            if(controlConfig[i].id =="timeLine"){
                var visible =controlConfig[i].config.visible;
                if(visible==false){
                    $(".cesium-controls-timeline").css("visibility","hidden");
                }
            }
        }

        // 定义clock 同步组件里的clock
        var timeControlsContainer = document.getElementById('timeControlsContainer');
        var clock = viewerCesiumWidget.cesiumWidget.clock;
        clock.clockRange = Cesium.ClockRange.UNBOUNDED;
        clock.shouldAnimate = false;
        clock.multiplier = 100;
        var clockViewModel = new Cesium.ClockViewModel(clock);


        // 定义时间轴容器
        var timelineContainer = document.createElement('div');
        timelineContainer.className = 'gt-viewer-timelineContainer';
        timeControlsContainer.appendChild(timelineContainer);

        //构造时间轴
        var timeline = new TimeLine(timelineContainer, clock);
        timeline.addEventListener('settime', onTimelineScrubfunction, false);
        timeline.zoomTo(clock.startTime, clock.stopTime);

        // view进行独立存储时间轴
        viewerCesiumWidget.gtTimeLine = timeline;
        window.setInterval(function() {
            clock.tick();
        }, 32);


        $(".gt-timeline-pause").on("click",function () {
            var self = this;
            // 当禁止播放时
            if(!viewerCesiumWidget.clock.shouldAnimate) {
                // 改变播放状态
                $(self).removeClass("icon-f-pauseTimeline").addClass("icon-f-playTimeline");
                viewerCesiumWidget.clock.shouldAnimate = true;
                // 展开折叠 重新计算刻度
                $(".cesium-controls-timeline").animate({
                    width: "450px"
                }, 500, 'swing', function () {
                    timeline.resize();
                }).css("box-shadow", "2px 2px 6px #333");
            }else {
                // 改变播放状态
                $(self).removeClass("icon-f-playTimeline").addClass("icon-f-pauseTimeline");
                viewerCesiumWidget.clock.shouldAnimate = false;
            }

        });
    }

    // 创建时间轴
    function onTimelineScrubfunction(e) {
        var clock = e.clock;
        clock.currentTime = e.timeJulian;
        clock.shouldAnimate = false;
    }

    /**
     * 初始化滑块样式的滚动条
     * @param viewerCesiumWidget
     * @param controlContainer
     */
    function initSliderTimeLine(viewerCesiumWidget, controlContainer) {
        var viewModel = new STimeLine();
        Utils.loadView(timeLineSlider, controlContainer, viewModel);
    }

    return createTimeLine;
});
