/**
 *  baseLayerCardViewModel
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/7/24/20:34  Copyright gtmap Corp
 */

define(['knockout',
    'jquery',
    'Cesium',
    'global/utils/MapUtils',
    'global/utils/WidgetUtils',
    'global/controls/timeLine/TimeLineSliderViewModel',
    'global/core/EventBus'
], function (
    ko,
    $,
    Cesium,
    MapUtils,
    WidgetUtils,
    TimeLineSliderViewModel,
    EventBus
) {
    var baseLayers = [], self, isChangeLayer = false;
    var that, form;
    var sliderTimeLine;
    // 存放所有需要check的图层
    var allCheckLayer = [];

    function BaseLayerCardViewModel(viewer) {

        self = this;

        self.tmpLayers = [];

        self.viewer = viewer;

        baseLayers = [];

        var options = WidgetUtils.appConfig.baseLayer;
        var hisLayers = [];
        //获取地图切换配置
        var controlConfig = WidgetUtils._controlConfig;
        for (var i = 0; i < controlConfig.length; i++) {
            if (controlConfig[i].id === "baseLayerCard") {
                hisLayers = controlConfig[i].config.hisLayers;
                hisLayers.defaultYear = controlConfig[i].config.defaultYear;
            }
        }

        options.forEach(function (item, index) {
            var params = {
                id: item.id,
                title: item.title,
                name: item.layers.length > 0 ? item.layers[0].alias : "",
                layer: item.layers
            };
            for (var i = 0; i < hisLayers.length; i++) {
                if (hisLayers[i].parentId === params.id) {
                    params.hisLayers = hisLayers[i].layers;
                    params.defaultYear = hisLayers[i].defaultYear;
                    // 底图绑定的地形或白模
                    if (hisLayers[i].hasOwnProperty("demLayer")) {
                        params.demLayer = hisLayers[i].demLayer;
                        allCheckLayer.push(hisLayers[i].demLayer);
                        params.haveDemLayer = true
                    } else {
                        params.haveDemLayer = false
                    }
                }
            }

            index === 0 ?
                (params.visible = true , self._activeLayer = params) :
                params.visible = false;
            baseLayers.push(params);
        });

        self.baseLayers = ko.observableArray(baseLayers);

        // 实例化时间轴
        sliderTimeLine = new TimeLineSliderViewModel;

        self.showDem = ko.observable(false);
    }


    BaseLayerCardViewModel.prototype.mouseenterCard = function (e, event) {

        if (isChangeLayer) {
            self.baseLayers.reverse();
            isChangeLayer = false;
        }
        $(".his-layers-container").hide();
        $(".his-list").hide();
        baseLayers.forEach(function (value) {
            var title = $('.baseLayers-' + value.title);
            if (!value.visible) {
                title.show("slow");
                var id = e._activeLayer.id;
                // $(".baseLayers-" + id).show("slow");
            }
        });

        form.render();
        //表单初始赋值
        $.each(allCheckLayer, function (index, value) {
            var temp = {};
            temp[value.name] = value.checked;
            form.val(value.name, temp)
        });
        $(".his-list").addClass("close");
        // $(".his-layers-container .icon-f-left").removeClass("rotate");

        // 左移时间轴
        $(".controls-slider-timeLine").animate({
            right: 135 * baseLayers.length + 30
        }, 300, "", function () {
            // $(".slider-timeLine-fold").click();
        });

        // self.showDem(true);
        $(".dem_container").show("slow");
    };

    BaseLayerCardViewModel.prototype.mouseleaveCard = function (e, event) {
        baseLayers.forEach(function (value) {
            var title = $('.baseLayers-' + value.title);
            if (!value.visible) {
                title.hide("slow");
                $(".his-layers-container").hide();
            }
        });

        // 右移时间轴
        $(".controls-slider-timeLine").animate({
            right: "155px"
        }, 300, "", function () {
            // $(".slider-timeLine-fold").click()
        });

        // self.showDem(false);
        $(".dem_container").hide("slow");
    };

    BaseLayerCardViewModel.prototype.changeLayer = function (lyr) {
        var scene = self.viewer.scene;
        for (var i = 0; i < self.tmpLayers.length; i++) {
            scene.imageryLayers.remove(self.tmpLayers[i]);
        }
        this.tmpLayers = [];
        // 判断是否是第一个元素
        if (self.baseLayers()[0].title !== lyr.title) {
            isChangeLayer = true;
            try {
                BaseLayerCardViewModel._activeLayer = lyr;
                self._activeLayer = lyr;
            } catch (e) {
                console.log(e);
            }
            // $(".his-layers-container").css("zIndex", 10);
            var $his = $('.baseLayers-' + lyr.id).css("zIndex", 99);
        }
        // 更改图片
        baseLayers.forEach(function (value, index) {
            var title = $('.baseLayers-' + value.title);
            if (value.title === lyr.title) {
                title.show("slow");
                value.visible = true;
                var $his = $('.baseLayers-' + lyr.id);
                if (lyr.hisLayers && lyr.hisLayers.length > 0) {
                    $(".his-layer-btn-active").removeClass("his-layer-btn-active").addClass("his-layer-btn-icon");
                    $("[year=" + lyr.defaultYear + "] .his-layer-btn-icon").addClass("his-layer-btn-active").removeClass("his-layer-btn-icon");
                    $his.hide();
                } else {
                    $his.hide();
                }
            } else {
                title.hide("slow");
                value.visible = false;
                var $his = $('.baseLayers-' + lyr.id);
                $his.hide();
            }
        });

        // 传递数据
        sliderTimeLine.addEventListen(self.changeYear);
        sliderTimeLine.update(lyr);
    };

    BaseLayerCardViewModel.prototype.changeYear = function (obj) {
        $(".his-layer-btn-active").removeClass("his-layer-btn-active").addClass("his-layer-btn-icon");
        $("[year=" + obj.year + "] .his-layer-btn-icon").addClass("his-layer-btn-active").removeClass("his-layer-btn-icon");
        var scene = self.viewer.scene;

        for (var i = 0; i < self.tmpLayers.length; i++) {
            scene.imageryLayers.remove(self.tmpLayers[i]);
        }
        for (var i = 0; i < obj.layers.length; i++) {
            var lyr = obj.layers[i];
            var provider = MapUtils.createGlobalLayer(lyr);
            if (lyr.type !== 'spm_terr') {
                var imageryLayer = $.extend(new Cesium.ImageryLayer(provider), {
                    layerId: lyr.id,
                    layerAlias: lyr.alias,
                    alpha: 1.0
                });
                if (provider) {
                    scene.imageryLayers.add(imageryLayer);
                    self.tmpLayers.push(imageryLayer);
                }
            } else {
                scene.terrainProvider = provider;
            }
        }

    }

    BaseLayerCardViewModel.prototype.toggleHis = function (obj) {
        if ($(".his-list").hasClass("close")) {
            $(".his-list").removeClass("close");
            // $(".his-layers-container .icon-f-left").addClass("rotate");
        } else {
            $(".his-list").addClass("close");
            // $(".his-layers-container .icon-f-left").removeClass("rotate");
        }
    }

    BaseLayerCardViewModel.prototype.init = function (obj) {
        layui.use('form', function () {
            form = layui.form;
        });
        var defaultYear = this._activeLayer.defaultYear;
        $(".his-layer-btn-active").removeClass("his-layer-btn-active").addClass("his-layer-btn-icon");
        $("[year=" + defaultYear + "] .his-layer-btn-icon").addClass("his-layer-btn-active").removeClass("his-layer-btn-icon");

        $.each(this.baseLayers(), function (index, value) {
            form.on('checkbox(' + value.demLayer.name + ')', function (data) {
                $.each(allCheckLayer, function (index, value) {
                    if (value.name === data.othis.parent().attr('lay-filter')) {
                        if (value.type === "spm_terr") {
                            var isChecked = data.elem.checked;
                            var scene = MapUtils.getViewer().scene;
                            if (isChecked) {
                                //添加图层
                                window.demLayer = MapUtils.createGlobalLayer(value);
                                scene.terrainProvider = demLayer;
                                EventBus.trigger("checkDemLayer", value);
                            } else {
                                MapUtils.removeSpmTerrain();
                                EventBus.trigger("unCheckDemLayer");
                            }
                            value.checked = isChecked;
                        } else if (value.type === "spm_tile") {
                            var isChecked = data.elem.checked;
                            var buildingLoad = MapUtils.modelLayer;
                            var poiLoad = MapUtils.poiLayer;
                            if (Cesium.defined(buildingLoad.start)) {
                                if (isChecked) {
                                    buildingLoad.start();
                                    poiLoad.start();
                                    EventBus.trigger("checkModel", value);
                                } else {
                                    buildingLoad.stop();
                                    poiLoad.stop();
                                    EventBus.trigger("unCheckModel");
                                }
                            } else {
                                if (isChecked) {
                                    //添加图层
                                    buildingLoad.layerName = buildingLoad.name;
                                    buildingLoad.fillColor = "#FAEAEAEA";
                                    buildingLoad.brightness = 0.76;
                                    if (MapUtils.zoomLevel > 15) {
                                        buildingLoad.defaultVisible = true;
                                    } else if (MapUtils.zoomLevel < 16) {
                                        buildingLoad.defaultVisible = false;
                                    }
                                    MapUtils.createGlobalLayer(buildingLoad, MapUtils.getViewer());
                                    poiLoad.start()
                                    EventBus.trigger("checkModel", value);
                                } else {
                                    MapUtils.getViewer().scene.layers.remove(buildingLoad.layerName);
                                    delete buildingLoad.modelLayerDetails;
                                    poiLoad.stop();
                                    EventBus.trigger("unCheckModel");
                                }
                            }

                            value.checked = isChecked;
                        }
                    }
                });
            });
        })
        // self.viewer.imageryLayers.addImageryProvider(layer);

    }
    // 自定义监听
    return BaseLayerCardViewModel = new Proxy(BaseLayerCardViewModel, {
        get: function (target, key, receiver) {
            return Reflect.get(target, key, receiver);
        },
        set: function (target, key, value, receiver) {
            // 添加图层控制底图
            if (key === '_activeLayer' && MapUtils.baseImageryLayers.length > 0) {
                // 移除图层
                var baseLayers = [], scene = self.viewer.scene;
                MapUtils.baseImageryLayers.forEach(function (item) {
                    scene.imageryLayers.remove(item);
                });
                //移除年度图层
                self.tmpLayers.forEach(function (item) {
                    scene.imageryLayers.remove(item);
                });
                self.tmpLayers = [];
                // 移除地形图
                if (scene.terrainProvider._layers) {
                    scene.terrainProvider = new Cesium.EllipsoidTerrainProvider({});
                }

                value.layer.forEach(function (lyr) {
                    var provider = MapUtils.createGlobalLayer(lyr);
                    if (lyr.type !== 'spm_terr') {
                        var imageryLayer = $.extend(new Cesium.ImageryLayer(provider), {
                            layerId: lyr.id,
                            layerAlias: lyr.alias,
                            alpha: 1.0
                        });
                        if (provider) {
                            scene.imageryLayers.add(imageryLayer);
                            baseLayers.push(imageryLayer);
                            self.tmpLayers.push(imageryLayer);
                        }
                    } else {
                        scene.terrainProvider = provider;
                    }
                });

                // 设置新底图
                MapUtils.setBaseImageryLayers(baseLayers, true);
            }

            return Reflect.set(target, key, value, receiver);
        }
    });
});