/**
 *  底图切换控件
 *  基于cesium进行复写 进行底图切换
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/7/24/20:32  Copyright gtmap Corp
 */

define(['Cesium',
    './BaseLayerCardViewModel',
    'knockout',
    'global/core/index',
    'text!./BaseLayerCardTpl.html'
], function (Cesium, BaseLayerCardViewModel, ko, Utils,template) {


    /**
     * BaseLayerCard
     * @param viewerCesiumWidget
     * @param options
     * @constructor
     */
    function BaseLayerCard(viewerCesiumWidget, controlContainer) {

        if (!Cesium.defined(viewerCesiumWidget)) {
            throw new Cesium.DeveloperError('CesiumWidget or Viewer is required.');
        }

        if (!Cesium.defined(controlContainer)) {
            throw new Cesium.DeveloperError('controlContainer or Viewer is required.');
        }

        // 创建实体
        var viewModel = new BaseLayerCardViewModel(viewerCesiumWidget);

        this._container = controlContainer;

        Utils.loadView(template, this._container, viewModel);
        viewModel.init();
    }


    Object.defineProperties(BaseLayerCard.prototype, {
        /**
         * Gets the parent container.
         * @memberof HomeButton.prototype
         *
         * @type {Element}
         */
        container: {
            get: function (target, key, receiver) {
             return this._container
            }
        },

        /**
         * Gets the view model.
         * @memberof HomeButton.prototype
         *
         * @type {HomeButtonViewModel}
         */
        viewModel: {
            get: function () {
                return this._viewModel;
            }
        }
    });

    /**
     * @returns {Boolean} true if the object has been destroyed, false otherwise.
     */
    BaseLayerCard.prototype.isDestroyed = function () {
        return false;
    };

    /**
     * Destroys the widget.  Should be called if permanently
     * removing the widget from layout.
     */
    BaseLayerCard.prototype.destroy = function () {
        ko.cleanNode(this._container);
        this._container.removeChild(this._container);

        return destroyObject(this);
    };


    return BaseLayerCard;
});