/**
 *  control index mixin
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/7/24/20:38  Copyright gtmap Corp
 */

define(['./index', 'Cesium'], function (Controls, Cesium) {

    /**
     * 混合组件
     * @constructor
     */
    function ViewerCesiumControlsMixin(viewer, options) {
        if (!Cesium.defined(viewer)) {
            throw new Cesium.DeveloperError('viewer is required.');
        }

        var container = viewer.container.firstChild;
        // 创建控件div
        var controlContainer = document.createElement('div');
        controlContainer.className = 'cesium-widget-controls';
        container.appendChild(controlContainer);

        // //
        var controls = {};
        Object.keys(options).forEach(function (key) {
            if (key === 'Compass' || key === 'DistanceLegend' || key === 'ZoomControls') {
                controls['enable' + key] = options[key];
            } else if (options[key]) {
                try {
                    viewer.extend(Controls[key], controlContainer);
                } catch (e) {
                    console.error("控件--" + key + "加载出错：" + e)
                }
            }
        });

        // add NavigationMixin
        viewer.extend(Controls.viewerCesiumNavigationMixin, controls)
    }


    return ViewerCesiumControlsMixin;
});