/**
 *  requireJS 配置
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/04/28/11:07  Copyright gtmap Corp
 */

var root = "/" + window.location.pathname.split("/")[1];

require.config({
    baseUrl: "/",
    waitSeconds: 200,
    optimizeCss: 'standard',
    urlArgs: "re=" + (new Date()).getTime(),
    paths: {
        knockout: '/webjars/knockout/knockout',
        mustache: '/webjars/mustache.js/mustache',
        jquery: '/webjars/jquery/jquery.min',
        lodash: '/webjars/lodash/lodash',
        leaflet: '/webjars/leaflet/Leaflet-1.0.3/dist/leaflet-src',
        'esri-leaflet': '/webjars/leaflet/esri-leaflet-2.2.3/dist/esri-leaflet-debug',
        'leaflet-pip': 'tp/leaflet-pip-gh-pages/leaflet-pip',
        json: 'tp/require-plugins/json',
        text: 'tp/require-plugins/text',
        less: 'tp/require-plugins/less',
        ztree: 'webjars/ztree/js/jquery.ztree.all.min',
        ztreeExhide: 'webjars/ztree/js/jquery.ztree.exhide.min',
        Cesium: 'webjars/SuperMap_WebGL/Build/Cesium/Cesium',
        //_Cesium: 'webjars/Cesium/Cesium/Build/CesiumUnminified/Cesium',
        EventBus: 'global/core/EventBus',
        utils: 'global/core/index',
        mapUtils: 'global/utils/MapUtils',
        widgetUtils: 'global/utils/WidgetUtils',
        ViewerCesiumControlsMixin: 'global/controls/ViewerCesiumControlsMixin',
        VectorTileProvider: 'global/core/VectorTileProvider',
        ol: 'tp/ol/ol-debug',
        echarts: 'tp/echartsCesium/echarts/echarts',
        echartsGL: 'tp/echartsCesium/echarts/echarts-gl',
        windy: 'tp/windMap/Windy',
        heatMap: 'tp/heatMap/heatmap.min',
        CompositeView: 'tp/echartsCesium/CompositeView',
        scroll: 'tp/scroll/jquery.slimscroll',
        jqueryUpload2: 'tp/jqueryUpload/jquery.upload2',
        readShp: 'tp/readShp/shp.min',
        catiline: 'tp/readShp/catiline',
        mapV: 'tp/mapV/mapv',
        inputSpinner: 'tp/inputSpinner/bootstrap-input-spinner',
        drag: 'tp/DragSort/ddsort',
        model: 'global/core/Model',
        mock: 'tp/mock/mock-min',
        d3: 'js/public/d3.v4.min',
        bytebuffer: 'tp/protobuf/bytebuffer.min',
        long: 'tp/protobuf/long.min'
    },
    shim: {
        ztree: {
            deps: ['jquery'],
            exports: 'ztree'
        },
        ztreeExhide: {
            deps: ['ztree'],
            exports: 'ztreeExhide'
        },
        Cesium: {
            exports: 'Cesium'
        },
        /*_Cesium: {
            exports: '_Cesium'
        },*/
        echartsGL: {
            deps: ["echarts"],
            exports: 'echartsGL'
        },
        scroll: {
            deps: ['jquery'],
            exports: 'scroll'
        },
        'esri-leaflet': {
            deps: ['leaflet'],
            exports: 'L.esri'
        },
        'leaflet-pip': {
            deps: ['leaflet'],
            exports: 'leafletPip'
        },
        d3: {
            deps: ['jquery'],
            exports: 'd3'
        }
    },
    map: {
        '*': {
            text: 'tp/require-plugins/text',
            css: 'tp/require-plugins/css.min',
            less: 'tp/require-plugins/less'
        }
    }
    // packages: [
    //     {
    //         name: 'global',
    //         location: 'global'
    //     }
    // ]
});
