/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.common.domain.core.PageBean;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.dg.web.BaseController;
import cn.gtmap.gtc.resource.clients.resource.ResourceClient;
import cn.gtmap.gtc.resource.domain.resource.dto.resource.ResourceView;
import cn.gtmap.gtc.resource.domain.resource.metadata.ResourceApply;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.workflow.clients.manage.SimpleProcessClient;
import cn.gtmap.gtc.workflow.domain.manage.TransferData;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/yzy/apply"})
public class YzyApplyController
extends BaseController {
    @Autowired
    UserManagerClient userManagerClient;
    @Autowired
    ResourceClient resourceClient;
    @Autowired
    SimpleProcessClient simpleProcessClient;

    @PostMapping(value={"/start"})
    public ResultBean StartApply(@RequestParam(value="params") String jsonResourceParams, @RequestParam(value="reason") String applyReason) {
        Map resourceParams = (Map)JSON.parse((String)jsonResourceParams);
        String tmpCapables = "";
        List lstCapables = (List)resourceParams.get("capables");
        for (Map capable : lstCapables) {
            tmpCapables = capable.get("id") + ",";
        }
        if (tmpCapables.length() > 0) {
            tmpCapables = tmpCapables.substring(0, tmpCapables.length() - 1);
        }
        String resourceId = resourceParams.get("id").toString();
        ResourceApply resourceApply = new ResourceApply();
        List listApplies = this.QueryApply(1, 1000, "", "nopass").getData();
        if (listApplies.size() > 0) {
            for (ResourceApply apply : listApplies) {
                if (!apply.getResourceId().equals(resourceId)) continue;
                resourceApply = apply;
                break;
            }
            ResourceView resourceView = this.resourceClient.queryResourceById(resourceId);
            UserDto user = this.userManagerClient.getUserDetailByUsername(resourceView.getCreator());
            String taskId = resourceApply.getTaskId();
            HashMap<String, String> taskMap = new HashMap<String, String>();
            HashMap<String, String> processMap = new HashMap<String, String>();
            taskMap.put("applicant", resourceApply.getApplicant());
            taskMap.put("appReason", resourceApply.getApplyReason());
            taskMap.put("appDepartment", resourceApply.getDepartment());
            taskMap.put("auditor", user.getAlias());
            processMap.put("appState", "unchecked");
            TransferData transferData = new TransferData();
            transferData.setTaskVars(taskMap);
            transferData.setAssignee(user.getUsername());
            transferData.setProcessVars(processMap);
            this.simpleProcessClient.transferProcess(taskId, transferData);
            return new ResultBean((Object)true);
        }
        resourceApply.setCapables(tmpCapables);
        resourceApply.setResourceId(resourceParams.get("id").toString());
        resourceApply.setApplyReason(applyReason);
        resourceApply.setTitle(resourceParams.get("title").toString());
        resourceApply.setDescription(resourceParams.get("description").toString());
        resourceApply.setAuditor(resourceParams.get("creator").toString());
        resourceApply.setType(resourceParams.get("type").toString());
        resourceApply.setIcon(resourceParams.get("icon").toString());
        resourceApply.setApplicationData("");
        return new ResultBean((Object)this.resourceClient.applyResource(resourceApply));
    }

    @GetMapping(value={"/query"})
    public PageBean QueryApply(@RequestParam(value="page") int page, @RequestParam(value="limit") int limit, @RequestParam(value="resourceName") String resourceName, @RequestParam(value="state") String state) {
        PageRequest pageable = new PageRequest(page - 1, limit);
        Page pageApplies = null;
        if ("uncheck".equals(state)) {
            pageApplies = this.resourceClient.applyIsendAndUnCheck(resourceName, (Pageable)pageable);
        } else if ("pass".equals(state)) {
            pageApplies = this.resourceClient.applyIsendAndChecked(resourceName, (Pageable)pageable);
        } else if ("nopass".equals(state)) {
            pageApplies = this.resourceClient.applyTurnBack(resourceName, (Pageable)pageable);
        }
        return new PageBean(Integer.valueOf(page), Integer.valueOf(limit), Integer.valueOf((int)pageApplies.getTotalElements()), pageApplies.getContent());
    }

    @GetMapping(value={"/review"})
    public PageBean QueryReview(@RequestParam(value="page") int page, @RequestParam(value="limit") int limit, @RequestParam(value="resourceName") String resourceName, @RequestParam(value="state") String state) {
        PageRequest pageable = new PageRequest(page - 1, limit);
        Page pageApplies = null;
        if ("undo".equals(state)) {
            pageApplies = this.resourceClient.applyINeedCheck(resourceName, (Pageable)pageable);
        } else if ("done".equals(state)) {
            pageApplies = this.resourceClient.applyIChecked(resourceName, (Pageable)pageable);
        }
        if (pageApplies == null) {
            return new PageBean(Integer.valueOf(page), Integer.valueOf(limit), Integer.valueOf(0), null);
        }
        return new PageBean(Integer.valueOf(page), Integer.valueOf(limit), Integer.valueOf((int)pageApplies.getTotalElements()), pageApplies.getContent());
    }

    @PostMapping(value={"/check"})
    public ResultBean checkApply(@RequestParam(value="params") String jsonResourceParams, @RequestParam(value="state") String state) {
        Map resourceParams = (Map)JSON.parse((String)jsonResourceParams);
        String tmpCapables = "";
        ResourceApply resourceApply = new ResourceApply();
        resourceApply.setId(resourceParams.get("id").toString());
        resourceApply.setTaskId(resourceParams.get("taskId").toString());
        resourceApply.setProcessId(resourceParams.get("processId").toString());
        resourceApply.setApplicant(resourceParams.get("applicant").toString());
        resourceApply.setApplicantName(resourceParams.get("applicantName").toString());
        resourceApply.setResourceId(resourceParams.get("resourceId").toString());
        resourceApply.setApplyReason(resourceParams.get("applyReason").toString());
        resourceApply.setTitle(resourceParams.get("title").toString());
        resourceApply.setDescription(resourceParams.get("description").toString());
        resourceApply.setAuditor(resourceParams.get("auditor").toString());
        resourceApply.setType(resourceParams.get("type").toString());
        resourceApply.setIcon(resourceParams.get("icon").toString());
        if ("agree".equals(state)) {
            return new ResultBean((Object)this.resourceClient.checkApply(resourceApply));
        }
        return new ResultBean((Object)this.resourceClient.backApply(resourceApply));
    }
}

