/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.clients.RegionManagerClient;
import cn.gtmap.gtc.resource.clients.tpl.TplClient;
import cn.gtmap.gtc.resource.domain.resource.dto.tpl.Tpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/tpl"})
public class TplController {
    private final Logger logger = LoggerFactory.getLogger(TplController.class);
    @Autowired
    private TplClient tplClient;
    @Autowired
    private RegionManagerClient regionManagerClient;

    @GetMapping(value={"/all"})
    public List<Tpl> fetchAll() {
        return this.tplClient.fetchAll();
    }

    @GetMapping(value={"/allExceptContent"})
    public List<Tpl> fetchAllExceptContent() {
        return this.tplClient.fetchAllExceptContent();
    }

    @PostMapping(value={"/save"})
    public Tpl saveTplConfig(@RequestBody Tpl tpl) {
        return this.tplClient.saveTplConfig(tpl);
    }

    @GetMapping(value={"/find/{id}"})
    public Tpl getOne(@PathVariable String id) {
        return this.tplClient.getOne(id);
    }

    @GetMapping(value={"/delete/{id}"})
    public boolean deleteTpl(@PathVariable String id) {
        return this.tplClient.delete(id);
    }

    @RequestMapping(value={"/queryTplListByRegionCode"})
    public List<Tpl> queryTplListByRegionCode(@RequestParam(name="regionCode", required=false) String regionCode) {
        return this.tplClient.queryTplListByRegionCode(regionCode);
    }

    @GetMapping(value={"/query/queryAllTpls"})
    public List<Map> queryAllTpls() {
        return this.getAllTpls(this.tplClient.fetchAll());
    }

    @GetMapping(value={"/query/queryTplsByPage"})
    public Page<Tpl> queryAllTpls(int page, int limit) {
        PageRequest pageable = new PageRequest(--page, limit);
        return this.tplClient.getPage((Pageable)pageable);
    }

    @GetMapping(value={"/query/queryAllTplsExceptContent"})
    public List<Map> queryAllTplsExceptContent() {
        return this.getAllTpls(this.tplClient.fetchAllExceptContent());
    }

    @RequestMapping(value={"/queryTplRoleRefsByTplId/{tplId}"})
    public List<String> queryMenuRoleRefsByMenuId(@PathVariable(name="tplId") String tplId) {
        return this.tplClient.queryTplRoleRefsByTplId(tplId);
    }

    @RequestMapping(value={"/associate/associateTplAndRoles"})
    public Object associateTplAndRoles(@RequestParam(name="tplId") String tplId, @RequestParam(name="roleIds[]", required=false) String[] roles) {
        try {
            return this.tplClient.associateTplAndRoles(tplId, roles);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<Map> getAllTpls(List<Tpl> tplList) {
        tplList.stream().sorted(Comparator.comparing(Tpl::getRegionCode));
        ArrayList<Map> mapList = new ArrayList<Map>();
        String regionName = "";
        for (Tpl tpl : tplList) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("id", tpl.getId());
            map.put("title", tpl.getTitle());
            try {
                regionName = this.regionManagerClient.findRegionByCode(tpl.getRegionCode()).getName();
            }
            catch (Exception e) {
                this.logger.error("\u67e5\u8be2\u533a\u5212\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
            map.put("regionCode", regionName);
            map.put("createAt", tpl.getCreateAt());
            map.put("sr", tpl.getSr());
            mapList.add(map);
        }
        return mapList;
    }

    @RequestMapping(value={"/queryTplbyRoleIdAndSr"})
    String queryTplbyRoleIdAndSr(@RequestParam(name="roleId") String roleId, @RequestParam(name="sr") String sr) {
        return this.tplClient.queryTplbyRoleIdAndSr(roleId, sr);
    }
}

