/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.common.domain.core.PageBean;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.common.domain.dw.mdb.entity.TbInfo;
import cn.gtmap.gtc.dg.service.AuthorityService;
import cn.gtmap.gtc.dg.service.TablesInfoService;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tablesinfo"})
public class TablesInfoController {
    @Autowired
    private TablesInfoService tabinfoService;
    @Autowired
    private AuthorityService authService;
    @Autowired
    private UserManagerClient userClient;

    @GetMapping(value={"/search"})
    PageBean getFieldInfosbyPage(@RequestParam(value="page") int page, @RequestParam(value="limit") int limit, @RequestParam(name="keyword", required=false, defaultValue="") String keyword, @RequestParam(name="moduleCode", required=false, defaultValue="ccglzy") String moduleCode, @RequestParam(name="ownState", required=false, defaultValue="private") String ownState, @RequestParam(name="tableIds", required=false, defaultValue="") String tableIds, @RequestParam(name="returnAll", defaultValue="false") Boolean returnAll) {
        HashMap mapCreator;
        PageBean result;
        UserDto user = this.userClient.getCurrentUser();
        String userName = user.getUsername();
        List<String> listTablesIds = new ArrayList<String>(Arrays.asList(tableIds.split(",")));
        if ("private".equals(ownState)) {
            HashMap<String, String> mapCreator2 = new HashMap<String, String>();
            mapCreator2.put("createBy", userName);
            return this.tabinfoService.getTablesByPage(page, limit, keyword, new HashSet<String>(listTablesIds), mapCreator2, returnAll);
        }
        if (!"null".equals(moduleCode)) {
            String authorityCode = "";
            boolean isEqual = !"private".equals(ownState);
            List authoritiesList = this.authService.getAllOperation();
            for (Map map : authoritiesList) {
                if ((!"private".equals(ownState) || !map.get("name").toString().equals("\u4fee\u6539")) && (!"public".equals(ownState) || !map.get("name").toString().equals("\u67e5\u8be2"))) continue;
                authorityCode = map.get("value").toString();
            }
            listTablesIds = this.authService.queryCode(userName, moduleCode, authorityCode, isEqual);
            if (listTablesIds.size() == 0) {
                return new PageBean();
            }
        }
        if ((result = this.tabinfoService.getTablesByPage(page, limit, keyword, new HashSet<String>(listTablesIds), mapCreator = new HashMap(), returnAll)) == null) {
            return new PageBean();
        }
        return result;
    }

    @GetMapping(value={"/instance"})
    PageBean getDbInstance() {
        return this.tabinfoService.getDbInstance();
    }

    @GetMapping(value={"/listlayer"})
    ResultBean getListLayer(@RequestParam(value="id") String id) {
        return this.tabinfoService.getListLayer(id);
    }

    @PostMapping(value={"/delete"})
    ResultBean delete(@RequestParam(value="id") String id, @RequestParam(value="moduleCode") String moduleCode, @RequestParam(value="moduleName") String moduleName) {
        ResultBean deleteResult = this.tabinfoService.deleteTableInfo(id);
        if (deleteResult.getCode() == 0) {
            UserDto user = this.userClient.getCurrentUser();
            String userName = user.getUsername();
            try {
                return new ResultBean((Object)this.authService.deleteAuthorityAndDataSource(userName, moduleCode, moduleName, id));
            }
            catch (Exception ex) {
                return new ResultBean((Object)true);
            }
        }
        return new ResultBean((Object)false);
    }

    @PostMapping(value={"/register"})
    ResultBean registerTable(@RequestParam(value="id") String instanceId, @RequestParam(value="layerName") String layerName, @RequestParam(value="moduleCode") String moduleCode, @RequestParam(value="moduleName") String moduleName, @RequestParam(value="tableName", required=false) String tableName) {
        ResultBean result;
        UserDto user = this.userClient.getCurrentUser();
        String userName = user.getUsername();
        JSONObject attributes = new JSONObject();
        attributes.put("createBy", (Object)userName);
        if (StringUtils.isNotEmpty((CharSequence)tableName)) {
            attributes.put("tableName", (Object)tableName);
        }
        if ((result = this.tabinfoService.registerTable(instanceId, layerName, attributes.toJSONString())).getCode() > 0) {
            return result;
        }
        String tableid = result.getData().toString();
        List listResult = this.authService.saveDataAuthority("self", moduleCode, moduleName, tableid, "");
        return result;
    }

    @PostMapping(value={"/newtable"})
    @ApiOperation(value="\u65b0\u5efa\u8868")
    ResultBean newtable(@RequestBody TbInfo tbInfo) {
        ResultBean rsBean = this.tabinfoService.createThenRegisterTableByuser(tbInfo.getInstanceid(), tbInfo.getCreateBy(), tbInfo.getName(), tbInfo.getParamJson());
        if (rsBean.getCode() > 0) {
            return rsBean;
        }
        String tableid = rsBean.getData().toString();
        List listResult = this.authService.saveDataAuthority("self", "ccglzy", "\u4ed3\u50a8\u7ba1\u7406\u8d44\u6e90", tableid, "");
        return rsBean;
    }
}

