/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.common.clients.dm.wdm.DataMiningModelClient;
import cn.gtmap.gtc.common.clients.dm.wdm.RapidMinerClient;
import cn.gtmap.gtc.common.clients.dw.mdb.AnalysisClient;
import cn.gtmap.gtc.common.clients.dw.mdb.DataStoreClient;
import cn.gtmap.gtc.common.domain.core.PageBean;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.common.domain.dm.wdm.entity.DMModelInfo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/rest/rapid"})
public class RapidMinerController {
    @Autowired
    private RapidMinerClient rapidMinerClient;
    @Autowired
    private DataMiningModelClient dataMiningModelClient;
    @Autowired
    private DataStoreClient dataStoreClient;
    @Autowired
    private UserManagerClient userManagerClient;
    @Autowired
    private AnalysisClient analysisClient;

    @GetMapping(value={"/exec/{service}"})
    @ApiOperation(value="\u6267\u884cRapidService")
    public String execService(@PathVariable(name="service") String service) {
        return this.rapidMinerClient.execService(service, "").toString();
    }

    @GetMapping(value={"/job/{id}"})
    @ApiOperation(value="\u67e5\u8be2job")
    public ResultBean job(@PathVariable(name="id") String id) {
        return this.rapidMinerClient.job(id);
    }

    @GetMapping(value={"/jobs"})
    @ApiOperation(value="\u67e5\u8be2jobs")
    public PageBean jobs(@RequestParam(name="id") String id, @RequestParam(value="page") int page, @RequestParam(value="limit") int limit) {
        String location = "";
        ResultBean resultBean = this.dataMiningModelClient.findById(id);
        Map json = (Map)resultBean.getData();
        PageBean pageBean = new PageBean();
        if (MapUtils.isNotEmpty((Map)json)) {
            location = MapUtils.getString((Map)json, (Object)"location", (String)"");
            pageBean = this.rapidMinerClient.jobs(location, page - 1, limit);
        }
        return pageBean;
    }

    @RequestMapping(value={"/delete/job/{id}"})
    @ApiOperation(value="\u505c\u6b62job")
    public ResultBean deletejob(@PathVariable(name="id") String id) {
        ResultBean deletejob = this.rapidMinerClient.deletejob(id);
        return deletejob;
    }

    @RequestMapping(value={"/log/job/{id}"})
    @ApiOperation(value="job\u65e5\u5fd7")
    public ResultBean log(@PathVariable(name="id") String id) {
        ResultBean log = this.rapidMinerClient.log(id);
        return log;
    }

    @ApiOperation(value="\u591a\u7c7b\u578b\u8f6cgeojson")
    @PostMapping(value={"/togeojson"})
    public ResultBean getGeojson(@RequestParam(name="sourceType") String sourceType, @RequestParam(name="layerName") String layerName, @RequestParam(name="file", required=false) MultipartFile file) {
        ResultBean geojson = this.dataStoreClient.getGeojson(sourceType, layerName, file);
        return geojson;
    }

    @PostMapping(value={"/fxgeojson"})
    @ResponseBody
    public ResultBean execute(HttpServletRequest request) {
        MultipartHttpServletRequest mpRequest = (MultipartHttpServletRequest)request;
        String exeType = mpRequest.getParameter("exeType");
        String sourceType = mpRequest.getParameter("sourceType");
        String layerName = mpRequest.getParameter("layerName");
        String jspara = mpRequest.getParameter("jspara");
        MultipartFile file = mpRequest.getFile("file");
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"exeType", (Object)exeType);
        param.add((Object)"sourceType", (Object)sourceType);
        param.add((Object)"layerName", (Object)layerName);
        param.add((Object)"jspara", (Object)jspara);
        if (!StringUtils.equalsIgnoreCase((String)sourceType, (String)"shp")) {
            ResultBean result = this.analysisClient.fxGeojsonNoShp((MultiValueMap)param);
            return result;
        }
        param.add((Object)"file", (Object)file);
        ResultBean result = this.analysisClient.fxGeojson(exeType, sourceType, layerName, file, jspara);
        return result;
    }

    @PostMapping(value={"/fxsthjzs"})
    @ResponseBody
    public ResultBean sthjzsAnalysis(HttpServletRequest request) {
        String username = this.userManagerClient.getCurrentUser().getUsername();
        MultipartHttpServletRequest mpRequest = (MultipartHttpServletRequest)request;
        MultipartFile file = mpRequest.getFile("file");
        String sourceType = mpRequest.getParameter("sourceType");
        String layerName = mpRequest.getParameter("layerName");
        String jspara = mpRequest.getParameter("jspara");
        JSONObject mapJspara = JSON.parseObject((String)jspara);
        mapJspara.put("userName", username);
        jspara = JSON.toJSONString((Object)mapJspara);
        if (sourceType.equals("shp")) {
            ResultBean resultBean = this.analysisClient.sthjzsAnalysis(sourceType, layerName, file, jspara);
            return resultBean;
        }
        ResultBean resultBean = this.analysisClient.sthjzsAnalysisNoShp(sourceType, layerName, jspara);
        return resultBean;
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u4ed3\u50a8geojson")
    @PostMapping(value={"/table/geojson"})
    public ResultBean queryTableGeojson(@RequestParam(name="tableId") String tableId) {
        ResultBean geojson = this.dataStoreClient.queryTableGeojson(tableId);
        return geojson;
    }

    @RequestMapping(value={"/submit/job"})
    @ApiOperation(value="\u63d0\u4ea4\u4e00\u4e2ajob")
    public String submitJob(String id, String paramString) {
        ResultBean resultBean = this.dataMiningModelClient.findById(id);
        DMModelInfo data = (DMModelInfo)resultBean.getData();
        JSONObject param = new JSONObject();
        JSONObject context = new JSONObject();
        JSONObject macros = new JSONObject();
        param.put("location", (Object)data.getLocation());
        macros.put("macros", (Object)paramString);
        param.put("context", (Object)macros);
        param.put("reportError", (Object)true);
        return this.rapidMinerClient.submitJob(param.toString()).getData().toString();
    }
}

