/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.workflow.clients.define.v1.ProcessModelClient;
import cn.gtmap.gtc.workflow.domain.define.ModelStatus;
import cn.gtmap.gtc.workflow.domain.define.ProcessModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/process-models"})
public class ProcessModelController {
    @Autowired
    private ProcessModelClient processModelClient;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    public Page<ProcessModel> queryProcessModels(@RequestParam(required=false, value="filter") String filter, @RequestParam(required=false, value="statusKey") String statusKey, @RequestParam(required=false, value="userName") String userName, @RequestParam(value="modelType", defaultValue="0") Integer modelType, Pageable pageable) {
        return this.processModelClient.queryProcessModels(filter, statusKey, userName, modelType, pageable);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ProcessModel addModelAndUpdStatus(@RequestParam(value="userId") String userId, @RequestBody ProcessModel processModel) {
        return this.processModelClient.addModelAndUpdStatus(userId, processModel);
    }

    @RequestMapping(value={"/update/{modelId}"}, method={RequestMethod.PATCH})
    public ProcessModel updateProcessModel(@PathVariable(value="modelId") String modelId, @RequestBody ProcessModel processModel) {
        return this.processModelClient.updateProcessModel(modelId, processModel);
    }

    @RequestMapping(value={"/status"}, method={RequestMethod.POST})
    public void saveModelStatus(@RequestBody ModelStatus modelStatus) {
        this.processModelClient.saveModelStatus(modelStatus);
    }

    @RequestMapping(value={"/deploy/{modelId}/deployment"}, method={RequestMethod.GET})
    public void deployModel(@PathVariable(value="modelId") String modelId) {
        this.processModelClient.deployModel(modelId);
    }

    @RequestMapping(value={"/detail/{modelId}"}, method={RequestMethod.GET})
    public ProcessModel getModel(@PathVariable(value="modelId") String modelId) {
        return this.processModelClient.getModel(modelId);
    }

    @RequestMapping(value={"/delete/{modelId}"}, method={RequestMethod.DELETE})
    public void deleteProcessModel(@PathVariable(value="modelId") String modelId) {
        this.processModelClient.deleteProcessModel(modelId);
    }
}

