/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.dg.client.ProcessTestClient;
import cn.gtmap.gtc.workflow.clients.define.v1.ProcessModelClient;
import cn.gtmap.gtc.workflow.domain.define.ModelStatus;
import java.util.List;
import java.util.Map;
import org.flowable.engine.runtime.Execution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/process-instances"})
public class ProcessInstanceController {
    @Autowired
    private ProcessTestClient processTestClient;
    @Autowired
    private ProcessModelClient processModelClient;

    @GetMapping(value={"/queryActiveExcution"})
    public List<Execution> queryActiveExcution(@RequestParam(value="processInstanceId") String processInstanceId) {
        return this.processTestClient.queryActiveExcution(processInstanceId);
    }

    @GetMapping(value={"/queryActiveExcutionByActName"})
    public List<String> queryActiveExcutionByActName(@RequestParam(value="processInstanceId") String processInstanceId, @RequestParam(value="actName") String actName) {
        return this.processTestClient.queryActiveExcutionByActName(processInstanceId, actName);
    }

    @GetMapping(value={"/getProcessInsListByDefKey"})
    public List<String> getProcessInsListByDefKey(@RequestParam(value="processDefKey") String processDefKey) {
        return this.processTestClient.getProcessInsListByDefKey(processDefKey);
    }

    @DeleteMapping(value={"/dropProcessInstance"})
    public String dropProcessInstance(@RequestParam(value="processInstanceId") String processInstanceId, @RequestParam(value="reason") String reason) {
        return this.processTestClient.dropProcessInstance(processInstanceId, reason);
    }

    @PostMapping(value={"/createNewTask"})
    public Map createNewTask(@RequestParam(value="processDefKey") String processDefKey, @RequestBody Map<String, Object> variables) {
        return this.processTestClient.createNewTask(processDefKey, variables);
    }

    @PostMapping(value={"/createNewTaskAuto"})
    public Map createNewTaskAuto(@RequestParam(value="processDefKey") String processDefKey, @RequestParam(value="processDefId") String processDefId, @RequestBody Map<String, Object> variables) {
        ModelStatus modelStatus = new ModelStatus();
        modelStatus.setId(processDefId);
        modelStatus.setModelStatusKey("full");
        modelStatus.setModelCategoryName("\u5b8c\u6210");
        this.processModelClient.saveModelStatus(modelStatus);
        this.processModelClient.deployModel(processDefId);
        return this.processTestClient.createNewTask(processDefKey, variables);
    }
}

