/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.category.client.v1.DomainCategoryClient;
import cn.gtmap.gtc.category.common.dto.DomainCategory;
import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.common.clients.dw.mdb.ApplyDataClient;
import cn.gtmap.gtc.common.clients.dw.mdb.DataStoreClient;
import cn.gtmap.gtc.common.domain.core.PageBean;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.MultipartDto;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import cn.gtmap.gtc.workflow.clients.manage.ProcessDefinitionClient;
import cn.gtmap.gtc.workflow.clients.manage.ProcessInstanceClient;
import cn.gtmap.gtc.workflow.clients.manage.ProcessTaskClient;
import cn.gtmap.gtc.workflow.clients.manage.TaskHandleClient;
import cn.gtmap.gtc.workflow.domain.manage.ProcessDefData;
import cn.gtmap.gtc.workflow.domain.manage.TaskData;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/personal"})
public class PersonalController {
    @Autowired
    private ProcessDefinitionClient processDefClient;
    @Autowired
    private ProcessInstanceClient processInsClient;
    @Autowired
    private DomainCategoryClient categoryClient;
    @Autowired
    private UserManagerClient userClient;
    @Autowired
    private ProcessTaskClient taskClient;
    @Autowired
    private TaskHandleClient taskHandleClient;
    @Autowired
    private StorageClient storageClient;
    @Autowired
    private DataStoreClient dataStoreClient;
    @Autowired
    private ApplyDataClient applyDataClient;

    @GetMapping(value={"/getProcessDefine"})
    public ResultBean getAllProDef() {
        PageResult ResourceResult = this.categoryClient.list("oa", "");
        List listCategories = (List)ResourceResult.getData();
        if (listCategories.size() == 0) {
            return null;
        }
        DomainCategory categoryOA = (DomainCategory)listCategories.get(0);
        Collection colChildCategories = categoryOA.getChildCategories();
        List listProcessDefData = this.processDefClient.getProcessDefDataByUserId("admin");
        ArrayList listResult = new ArrayList();
        for (DomainCategory category : colChildCategories) {
            HashMap<String, Object> mapResult = new HashMap<String, Object>();
            String categoryName = category.getName();
            String categoryDescription = category.getDescription();
            ArrayList<ProcessDefData> listTempProcessDefs = new ArrayList<ProcessDefData>();
            for (ProcessDefData procDef : listProcessDefData) {
                if (!procDef.getCategory().equals(categoryName)) continue;
                listTempProcessDefs.add(procDef);
            }
            if (listTempProcessDefs.size() == 0) continue;
            mapResult.put("processType", categoryDescription);
            mapResult.put("processDefs", listTempProcessDefs);
            listResult.add(mapResult);
        }
        return new ResultBean(listResult);
    }

    @GetMapping(value={"/getProcessDefineByKey"})
    public ResultBean getProDefByKey(@RequestParam(value="key") String key) {
        return new ResultBean((Object)this.processDefClient.getProcessDefByProcessDefKey(key));
    }

    @PostMapping(value={"/startUpTask"})
    public ResultBean startUpProcess(@RequestParam(value="processDefKey") String processDefKey, @RequestParam(value="workDayId", required=false) String workDayId, @RequestParam(value="processInstanceName", required=false) String processInstanceName, @RequestParam(value="priority", required=false) Integer priority, @RequestParam(value="category") String category, @RequestParam(value="department") String department, @RequestParam(value="procDueLimt") Integer procDueLimt, @RequestParam(value="isPriority") Integer isPriority, @RequestParam(value="desc", required=false) String desc) throws Exception {
        UserDto user = this.userClient.getCurrentUser();
        return new ResultBean((Object)this.processInsClient.startUpProcess(processDefKey, user.getUsername(), workDayId, processInstanceName, priority, category, department, procDueLimt, isPriority, desc));
    }

    @GetMapping(value={"/tasksundone"})
    public Map getUndoneTasks(@RequestParam(value="limit") int size, @RequestParam(value="page") int page, @RequestParam(value="category", required=false) String category, @RequestParam(value="instanceName", required=false) String instanceName) {
        UserDto user = this.userClient.getCurrentUser();
        PageRequest pageable = new PageRequest(page - 1, size);
        Page pageTasks = this.taskClient.todoTaskList(user.getUsername(), category, instanceName, (Pageable)pageable);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 0);
        result.put("count", pageTasks.getTotalElements());
        result.put("msg", "");
        result.put("data", pageTasks.getContent());
        return result;
    }

    @GetMapping(value={"/tasksFinish"})
    public Map getDoneTasks(@RequestParam(value="limit") int size, @RequestParam(value="page") int page, @RequestParam(value="category", required=false) String category, @RequestParam(value="instanceName", required=false) String instanceName) {
        UserDto user = this.userClient.getCurrentUser();
        PageRequest pageable = new PageRequest(page - 1, size);
        Page pageTasks = this.taskClient.completeTaskList(user.getUsername(), category, instanceName, (Pageable)pageable);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 0);
        result.put("count", pageTasks.getTotalElements());
        result.put("msg", "");
        result.put("data", pageTasks.getContent());
        return result;
    }

    @PostMapping(value={"/delete"})
    public ResultBean deleteTask(@RequestParam(value="taskId") String taskId) {
        return new ResultBean((Object)this.taskHandleClient.deleteTask(taskId));
    }

    @PostMapping(value={"/fetchback"})
    public ResultBean fetchback(@RequestParam(value="taskId") String taskId) {
        return new ResultBean((Object)this.taskHandleClient.fetchBack(taskId));
    }

    @GetMapping(value={"/listfiles"})
    public PageBean listFiles(@RequestParam(value="nodeId") String nodeId, @RequestParam(value="clientId") String clientId, @RequestParam(value="page") int page, @RequestParam(value="limit") int limit, @RequestParam(value="fileName", required=false) String fileName) {
        PageRequest pageable = new PageRequest(page - 1, limit);
        UserDto user = this.userClient.getCurrentUser();
        PageResult result = nodeId.equals("") ? this.storageClient.listRootStorages((Pageable)pageable, clientId, null, user.getId(), fileName, null, null) : this.storageClient.listSubsetStorages((Pageable)pageable, nodeId, fileName, null, null);
        if (page != 1 && ((List)result.getData()).size() == 0) {
            return this.listFiles(nodeId, clientId, page - 1, limit, fileName);
        }
        return new PageBean(Integer.valueOf(page), Integer.valueOf(limit), Integer.valueOf((int)result.toPage().getTotalElements()), (List)result.getData());
    }

    @PostMapping(value={"/upload"})
    public ResultBean uploadFiles(@RequestParam(value="nodeId") String nodeId, @RequestParam(value="clientId") String clientId, @RequestParam(name="file") MultipartFile file) throws IOException {
        UserDto user = this.userClient.getCurrentUser();
        MultipartDto multipartDto = new MultipartDto();
        multipartDto.setName(file.getName());
        multipartDto.setContentType(file.getContentType());
        multipartDto.setData(file.getBytes());
        multipartDto.setOriginalFilename(file.getOriginalFilename());
        multipartDto.setSize(file.getSize());
        multipartDto.setClientId(clientId);
        multipartDto.setOwner(user.getId());
        multipartDto.setNodeId(nodeId);
        StorageDto storageDto = this.storageClient.multipartUpload(multipartDto);
        return new ResultBean((Object)storageDto);
    }

    @PostMapping(value={"/createfolder"})
    public ResultBean createFolder(@RequestParam(value="name") String name, @RequestParam(value="nodeId", required=false, defaultValue="") String nodeId, @RequestParam(value="clientId") String clientId) {
        UserDto user = this.userClient.getCurrentUser();
        StorageDto result = nodeId.equals("") ? this.storageClient.createRootFolder(clientId, null, name, user.getId()) : this.storageClient.createFolder(clientId, null, nodeId, name, user.getId());
        return new ResultBean((Object)result);
    }

    @GetMapping(value={"/existfile"})
    public ResultBean existFile(@RequestParam(value="name") String name, @RequestParam(value="nodeId", required=false, defaultValue="") String nodeId, @RequestParam(value="clientId") String clientId, @RequestParam(value="type") int type) {
        UserDto user = this.userClient.getCurrentUser();
        return new ResultBean((Object)this.storageClient.checkExist(clientId, null, nodeId, name, user.getId(), Integer.valueOf(type)));
    }

    @PostMapping(value={"/deletefiles"})
    public ResultBean deleteFiles(@RequestParam(value="ids") String ids) {
        return new ResultBean((Object)this.storageClient.deleteStorages((List)JSON.parse((String)ids)));
    }

    @GetMapping(value={"/queryApply"})
    public PageBean getApplyTasks(@RequestParam(value="limit") int size, @RequestParam(value="page") int page, @RequestParam(value="layerName", required=false, defaultValue="") String layerName, @RequestParam(value="state") String state) {
        UserDto currentUser = this.userClient.getCurrentUser();
        String currentUserName = currentUser.getUsername();
        if ("".equals(layerName)) {
            return this.applyDataClient.queryApplyDataByUserNameAndState(page - 1, size, currentUserName, state);
        }
        return this.applyDataClient.queryApplyDataByUserNameAndStateAndLayerName(page - 1, size, currentUserName, state, layerName);
    }

    @GetMapping(value={"/queryReview"})
    public PageBean getReviewTasks(@RequestParam(value="limit") int size, @RequestParam(value="page") int page, @RequestParam(value="layerName", required=false, defaultValue="") String layerName, @RequestParam(value="state") String state) {
        UserDto user = this.userClient.getCurrentUser();
        if ("0".equals(state)) {
            PageRequest pageable = new PageRequest(0, 1000);
            Page pageTasks = this.taskClient.todoTaskList(user.getUsername(), null, null, (Pageable)pageable);
            ArrayList<Map> listResult = new ArrayList<Map>();
            for (TaskData task : pageTasks.getContent()) {
                String processInsId = task.getProcessInstanceId();
                ResultBean result = this.applyDataClient.queryDownload(processInsId);
                List listTemp = (List)result.getData();
                for (Map info : listTemp) {
                    if (!"0".equals(info.get("state")) || !"".equals(layerName) && !info.get("layerName").equals(layerName)) continue;
                    listResult.add(info);
                }
            }
            int maxNum = page * size > listResult.size() ? listResult.size() : page * size;
            return new PageBean(Integer.valueOf(page - 1), Integer.valueOf(size), Integer.valueOf(listResult.size()), listResult.subList((page - 1) * size, maxNum));
        }
        return this.applyDataClient.queryApplyDataByReviewerAndLayerName(page - 1, size, user.getUsername(), layerName);
    }
}

