/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.common.clients.dw.mdb.ApplyDataClient;
import cn.gtmap.gtc.common.clients.dw.mdb.DataStoreClient;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.common.domain.dw.mdb.entity.ApplyDataInfo;
import cn.gtmap.gtc.dg.service.AuthorityService;
import cn.gtmap.gtc.dg.web.BaseController;
import cn.gtmap.gtc.gis.core.geojson.BaseConverter;
import cn.gtmap.gtc.gis.core.jtsgeo.JTSGeometryHelper;
import cn.gtmap.gtc.gis.domain.esm.Feature;
import cn.gtmap.gtc.gis.utils.UUIDGenerator;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.workflow.clients.manage.ProcessDefinitionClient;
import cn.gtmap.gtc.workflow.clients.manage.ProcessInstanceClient;
import cn.gtmap.gtc.workflow.clients.manage.SimpleProcessClient;
import cn.gtmap.gtc.workflow.domain.manage.TaskData;
import cn.gtmap.gtc.workflow.domain.manage.TransferData;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geojson.geom.GeometryJSON;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/overlay"})
public class OverlayController
extends BaseController {
    @Autowired
    private DataStoreClient dataStoreClient;
    @Autowired
    private UserManagerClient userClient;
    @Autowired
    private ProcessDefinitionClient processDefClient;
    @Autowired
    private ProcessInstanceClient processInsClient;
    @Autowired
    private SimpleProcessClient simpleProcessClient;
    @Autowired
    private ApplyDataClient applyDataClient;
    @Autowired
    private AuthorityService authService;

    @PostMapping(value={"/execute"})
    public ResultBean execute(@RequestParam(name="data") String sourcelayers, @RequestParam(name="overlay") String overlayer, @RequestParam(name="type") String type) {
        HashMap mapAll = new HashMap();
        HashMap<String, Map> mapJson = new HashMap<String, Map>();
        List listGeometries = this.geoJson2jtwJson(overlayer);
        JSONArray arrLayers = JSON.parseArray((String)sourcelayers);
        HashMap mapYears = new HashMap();
        for (int i = 0; i < arrLayers.size(); ++i) {
            JSONObject object = JSON.parseObject((String)arrLayers.get(i).toString());
            String year = MapUtils.getString((Map)object, (Object)"year");
            String layerName = MapUtils.getString((Map)object, (Object)"name");
            String layerCrs = MapUtils.getString((Map)object, (Object)"crs");
            HashMap<String, Object> infos = new HashMap<String, Object>();
            infos.put("operate", "intersect");
            infos.put("destCrs", layerCrs);
            infos.put("layerName", layerName);
            infos.put("features", listGeometries);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("service", "wps");
            params.put("request", "featuresIntersect");
            params.put("version", "2017.06.21");
            params.put("featuresIntersect", JSON.toJSONString(infos));
            String result = OverlayController.sendPost((String)"http://192.168.19.46:8030/hgis/wps", params);
            if (StringUtils.isEmpty((String)result)) {
                return new ResultBean(null);
            }
            Map templayerMap = null;
            try {
                templayerMap = (Map)JSON.parse((String)result);
            }
            catch (Exception e) {
                return new ResultBean(null);
            }
            templayerMap = (Map)JSON.parse((String)result);
            String tempLayerName = MapUtils.getString((Map)templayerMap, (Object)"data");
            if (StringUtils.isEmpty((String)tempLayerName)) {
                return new ResultBean(null);
            }
            HashMap<String, String> tempInfos = new HashMap<String, String>();
            tempInfos.put("layerName", tempLayerName);
            tempInfos.put("calformula", "getarea");
            tempInfos.put("resultfield", "geo_area");
            tempInfos.put("descrs", "EPSG:4528");
            params = new HashMap();
            params.put("service", "wps");
            params.put("request", "fieldcal");
            params.put("version", "2017.06.21");
            params.put("fieldcal", JSON.toJSONString(tempInfos));
            result = OverlayController.sendPost((String)"http://192.168.19.46:8030/hgis/wps", params);
            if (StringUtils.isEmpty((String)result)) {
                return new ResultBean(null);
            }
            templayerMap = (Map)JSON.parse((String)result);
            tempLayerName = MapUtils.getString((Map)templayerMap, (Object)"data");
            params = new HashMap();
            params.put("service", "wfs");
            params.put("request", "GetFeature");
            params.put("version", "1.1.0");
            params.put("typeName", tempLayerName);
            params.put("outputFormat", "application/json");
            params.put("maxFeatures", "100000");
            result = OverlayController.sendPost((String)"http://192.168.19.46:8030/hgis/wfs", params);
            if (StringUtils.isEmpty((String)result)) {
                return new ResultBean(null);
            }
            Map mapResult = (Map)JSON.parse((String)result);
            mapJson.put(year, mapResult);
            List lstFeatures = (List)MapUtils.getObject((Map)mapResult, (Object)"features");
            Map mapTypes = (Map)JSON.parse((String)type);
            DecimalFormat df = new DecimalFormat("0.00");
            double allArea = 0.0;
            for (int n = 0; n < lstFeatures.size(); ++n) {
                Map mapFeature = (Map)lstFeatures.get(n);
                Map mapProps = (Map)mapFeature.get("properties");
                allArea += Double.parseDouble(mapProps.get("geo_area").toString()) / 1000000.0;
            }
            ArrayList listStatistic = new ArrayList();
            for (String key : mapTypes.keySet()) {
                double tempArea = 0.0;
                for (int j = 0; j < lstFeatures.size(); ++j) {
                    Map mapFeature = (Map)lstFeatures.get(j);
                    Map mapProps = (Map)mapFeature.get("properties");
                    if (!mapProps.get("CC").toString().startsWith((String)mapTypes.get(key))) continue;
                    tempArea += Double.parseDouble(mapProps.get("geo_area").toString()) / 1000000.0;
                }
                HashMap<String, String> mapTemp = new HashMap<String, String>();
                mapTemp.put("area", String.valueOf(df.format(tempArea)));
                mapTemp.put("percent", String.valueOf(df.format(tempArea / allArea)));
                mapTemp.put("type", key);
                listStatistic.add(mapTemp);
            }
            mapYears.put(year, listStatistic);
            mapAll.put("statistic", mapYears);
        }
        mapAll.put("geometry", mapJson);
        return new ResultBean(mapAll);
    }

    private List<Map<String, ?>> geoJson2jtwJson(String geojson) {
        BaseConverter baseConverter = new BaseConverter();
        JTSGeometryHelper jtsGeometryHelper = new JTSGeometryHelper();
        SimpleFeatureCollection simpleFeatureCollection = (SimpleFeatureCollection)jtsGeometryHelper.readUnTypeGeoJSON(geojson);
        List mapList = baseConverter.convertToListMap(simpleFeatureCollection, "the_geom", true);
        return mapList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String url, String param) {
        OutputStreamWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            String line;
            URL realUrl = new URL(url);
            HttpURLConnection conn = null;
            conn = (HttpURLConnection)realUrl.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.connect();
            out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            out.write(param);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            System.out.println("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static String sendPost(String urlStr, Map<String, String> parameterMap) {
        StringBuilder sb = new StringBuilder();
        try {
            URL url = new URL(urlStr);
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("charset", "utf-8");
            System.out.println(httpURLConnection.getURL().toString());
            PrintWriter pw = new PrintWriter(new BufferedOutputStream(httpURLConnection.getOutputStream()));
            StringBuffer parameter = new StringBuffer();
            parameter.append("1=1");
            for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
                parameter.append("&" + entry.getKey() + "=" + entry.getValue());
            }
            pw.write(parameter.toString());
            pw.flush();
            pw.close();
            System.out.println("parameter: " + parameter.toString());
            BufferedReader br = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "utf-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String httpPost(String urlStr, Map<String, String> params) {
        StringBuffer data = new StringBuffer();
        try {
            String line;
            URL connect = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)connect.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            OutputStreamWriter paramout = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
            String paramsStr = "";
            for (String param : params.keySet()) {
                paramsStr = paramsStr + "&" + param + "=" + params.get(param);
            }
            if (!paramsStr.isEmpty()) {
                paramsStr = paramsStr.substring(1);
            }
            paramout.write(paramsStr);
            paramout.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                data.append(line);
            }
            paramout.close();
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return data.toString();
    }

    @PostMapping(value={"/compare"})
    public ResultBean Compare2Years(@RequestParam(name="json1") String json1, @RequestParam(name="json2") String json2, @RequestParam(name="type") String type) {
        Map mapTypes = (Map)JSON.parse((String)type);
        DecimalFormat df = new DecimalFormat("0.00");
        JTSGeometryHelper jtsGeometryHelper = new JTSGeometryHelper();
        SimpleFeatureCollection simpleFeatureCollection1 = (SimpleFeatureCollection)jtsGeometryHelper.readUnTypeGeoJSON(json1);
        SimpleFeatureCollection simpleFeatureCollection2 = (SimpleFeatureCollection)jtsGeometryHelper.readUnTypeGeoJSON(json2);
        SimpleFeatureIterator iterator2 = simpleFeatureCollection2.features();
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
        ArrayList listPart = new ArrayList();
        while (iterator2.hasNext()) {
            Map<String, Double> mapPart = new HashMap<String, String>();
            SimpleFeature feature2 = (SimpleFeature)iterator2.next();
            Geometry geometry2 = (Geometry)feature2.getDefaultGeometry();
            String type2 = "";
            boolean hasPart = false;
            for (Property p : feature2.getProperties()) {
                if (!"CC".equals(p.getName().getLocalPart())) continue;
                type2 = p.getValue().toString();
                for (String string : mapTypes.keySet()) {
                    if (!type2.startsWith(((String)mapTypes.get(string)).toString())) continue;
                    type2 = string;
                    break;
                }
                for (Map map : listPart) {
                    if (!map.get("type").equals(type2)) continue;
                    hasPart = true;
                    mapPart = map;
                    break;
                }
                if (hasPart) break;
                mapPart.put("type", (Double)((Object)type2));
                break;
            }
            SimpleFeatureType featureType2 = feature2.getFeatureType();
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType2);
            SimpleFeatureIterator iterator1 = simpleFeatureCollection1.features();
            while (iterator1.hasNext()) {
                Geometry geometry1;
                Geometry intersection;
                SimpleFeature simpleFeature = (SimpleFeature)iterator1.next();
                String type1 = "";
                for (Property p : simpleFeature.getProperties()) {
                    if (!"type".equals(p.getName().getLocalPart())) continue;
                    type1 = p.getValue().toString();
                    break;
                }
                if (type1.equals(type2) || (intersection = OverlayController.validate((Geometry)OverlayController.validate((Geometry)(geometry1 = (Geometry)simpleFeature.getDefaultGeometry())).intersection(OverlayController.validate((Geometry)geometry2)))).isEmpty() || !"POLYGON".equals(intersection.getGeometryType().toUpperCase())) continue;
                featureBuilder.add((Object)intersection);
                collection.add(featureBuilder.buildFeature("feature".concat(UUIDGenerator.generate())));
                double area = intersection.getArea();
                if (mapPart.containsKey(type1)) {
                    Double value = (Double)mapPart.get(type1);
                    value = value + area / 1000000.0;
                    mapPart.replace(type1, Double.parseDouble(df.format(value)));
                    continue;
                }
                mapPart.put(type1, Double.parseDouble(df.format(area / 1000000.0)));
            }
            if (hasPart) continue;
            listPart.add(mapPart);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String geojson = this.toFeatureJSON((Object)collection);
        map.put("statistic", listPart);
        map.put("geometries", geojson);
        return new ResultBean(map);
    }

    public static Geometry validate(Geometry geom) {
        if (geom instanceof Polygon) {
            if (geom.isValid()) {
                geom.normalize();
                return geom;
            }
            Polygonizer polygonizer = new Polygonizer();
            OverlayController.addPolygon((Polygon)((Polygon)geom), (Polygonizer)polygonizer);
            return OverlayController.toPolygonGeometry((Collection)polygonizer.getPolygons(), (GeometryFactory)geom.getFactory());
        }
        if (geom instanceof MultiPolygon) {
            if (geom.isValid()) {
                geom.normalize();
                return geom;
            }
            Polygonizer polygonizer = new Polygonizer();
            int n = geom.getNumGeometries();
            while (n-- > 0) {
                OverlayController.addPolygon((Polygon)((Polygon)geom.getGeometryN(n)), (Polygonizer)polygonizer);
            }
            return OverlayController.toPolygonGeometry((Collection)polygonizer.getPolygons(), (GeometryFactory)geom.getFactory());
        }
        return geom;
    }

    static void addPolygon(Polygon polygon, Polygonizer polygonizer) {
        OverlayController.addLineString((LineString)polygon.getExteriorRing(), (Polygonizer)polygonizer);
        int n = polygon.getNumInteriorRing();
        while (n-- > 0) {
            OverlayController.addLineString((LineString)polygon.getInteriorRingN(n), (Polygonizer)polygonizer);
        }
    }

    static void addLineString(LineString lineString, Polygonizer polygonizer) {
        if (lineString instanceof LinearRing) {
            lineString = lineString.getFactory().createLineString(lineString.getCoordinateSequence());
        }
        Point point = lineString.getFactory().createPoint(lineString.getCoordinateN(0));
        Geometry toAdd = lineString.union((Geometry)point);
        polygonizer.add(toAdd);
    }

    static Geometry toPolygonGeometry(Collection<Polygon> polygons, GeometryFactory factory) {
        switch (polygons.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Geometry)polygons.iterator().next();
            }
        }
        return factory.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
    }

    public String toFeatureJSON(Object feature) {
        try {
            FeatureJSON featureJSON = new FeatureJSON(new GeometryJSON(14));
            StringWriter out = new StringWriter();
            if (feature instanceof SimpleFeature) {
                featureJSON.setEncodeFeatureBounds(((SimpleFeature)feature).getBounds() != null);
                featureJSON.setEncodeFeatureCRS(((SimpleFeature)feature).getFeatureType().getCoordinateReferenceSystem() != null);
                featureJSON.writeFeature((SimpleFeature)feature, (Object)out);
            } else if (feature instanceof FeatureCollection) {
                if (((FeatureCollection)feature).size() > 0) {
                    featureJSON.setEncodeFeatureCollectionBounds(((SimpleFeature)((FeatureCollection)feature).toArray()[0]).getBounds() != null);
                    featureJSON.setEncodeFeatureCollectionCRS(((SimpleFeature)((FeatureCollection)feature).toArray()[0]).getFeatureType().getCoordinateReferenceSystem() != null);
                }
                featureJSON.writeFeatureCollection((FeatureCollection)feature, (Object)out);
            }
            return out.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static List<Map> getYearMap(JSONArray features, String type, Map<String, String> mapTypes) {
        String areaStr;
        JSONObject jsonObject;
        DecimalFormat df = new DecimalFormat("#.0000");
        ArrayList returnList = Lists.newArrayList();
        double sumArea = 0.0;
        for (int j = 0; j < features.size(); ++j) {
            jsonObject = features.getJSONObject(j);
            areaStr = jsonObject.getJSONObject("properties").getString("AREA");
            sumArea += Double.valueOf(areaStr).doubleValue();
        }
        for (int i = 0; i < features.size(); ++i) {
            HashMap<String, String> mapYearResult;
            jsonObject = features.getJSONObject(i);
            areaStr = jsonObject.getJSONObject("properties").getString("AREA");
            String typeStr = "";
            typeStr = type.equals("thisyear") ? jsonObject.getJSONObject("properties").getString("newcc") : jsonObject.getJSONObject("properties").getString("newcc_overlay");
            if (mapTypes.containsKey(typeStr)) {
                mapYearResult = new HashMap<String, String>();
                mapYearResult.put("area", areaStr);
                mapYearResult.put("type", mapTypes.get(typeStr));
                mapYearResult.put("percent", df.format(Double.valueOf(areaStr) / sumArea));
                returnList.add(mapYearResult);
                continue;
            }
            mapYearResult = new HashMap();
            mapYearResult.put("area", areaStr);
            mapYearResult.put("type", "\u5176\u4ed6");
            mapYearResult.put("percent", df.format(Double.valueOf(areaStr) / sumArea));
            returnList.add(mapYearResult);
        }
        return returnList;
    }

    public String getYearFeatureCol(JSONObject parse1, String typeField) {
        JSONArray features;
        if (parse1.containsKey((Object)"features") && (features = parse1.getJSONArray("features")) != null && features.size() > 0) {
            for (int i = 0; i < features.size(); ++i) {
                JSONObject o = features.getJSONObject(i);
                if (!o.containsKey((Object)"properties")) continue;
                JSONObject o1 = o.getJSONObject("properties");
                if (!o1.containsKey((Object)typeField)) {
                    JSONObject map = o1;
                    map.put(typeField, "qt");
                    continue;
                }
                if (o1.get((Object)typeField) != null) continue;
                o1.put(typeField, (Object)"qt");
            }
        }
        return parse1.toJSONString();
    }

    public String getFeatureCollection(String fxresult) {
        JTSGeometryHelper jtsGeometryHelper = new JTSGeometryHelper();
        BaseConverter baseConverter = new BaseConverter();
        ArrayList featureList = Lists.newArrayList();
        Object fxmap1 = ((Map)JSON.parseObject((String)fxresult, Map.class)).get("data");
        List list = (List)JSON.parseObject((String)fxmap1.toString(), List.class);
        FeatureCollection featureCollection = jtsGeometryHelper.list2FeatureCollection(list, jtsGeometryHelper.parseUndefineSR("4490"));
        cn.gtmap.gtc.gis.domain.esm.FeatureCollection featureCollection1 = baseConverter.convertToFeatureCollection((SimpleFeatureCollection)featureCollection);
        return featureCollection1.toJson();
    }

    static List<Map> getResultMap(String fxresult, String type, Map<String, String> mapTypes) {
        DecimalFormat df = new DecimalFormat("#.0000");
        ArrayList returnList = Lists.newArrayList();
        JSONArray fxmap1 = (JSONArray)((Map)JSON.parseObject((String)fxresult, Map.class)).get("data");
        if (fxmap1 != null && fxmap1.size() > 0) {
            String areaStr;
            JSONObject resultObj;
            int i;
            double sumArea = 0.0;
            for (i = 0; i < fxmap1.size(); ++i) {
                resultObj = fxmap1.getJSONObject(i);
                areaStr = resultObj.getJSONObject("properties").getString("pSUM_SHAPE_Leng");
                sumArea += Double.valueOf(areaStr).doubleValue();
            }
            for (i = 0; i < fxmap1.size(); ++i) {
                HashMap<String, String> mapYearResult;
                resultObj = fxmap1.getJSONObject(i);
                areaStr = resultObj.getJSONObject("properties").getString("pSUM_SHAPE_Leng");
                String typeStr = "";
                typeStr = type.equals("thisyear") ? resultObj.getJSONObject("properties").getString("NEWCC") : (type.equals("preyear") ? resultObj.getJSONObject("properties").getString("NEWCC_overlay") : resultObj.getJSONObject("properties").getString("CCCHANGE"));
                if (mapTypes.containsKey(typeStr)) {
                    mapYearResult = new HashMap<String, String>();
                    mapYearResult.put("area", areaStr);
                    mapYearResult.put("type", mapTypes.get(typeStr));
                    mapYearResult.put("percent", df.format(Double.valueOf(areaStr) / sumArea));
                    returnList.add(mapYearResult);
                    continue;
                }
                mapYearResult = new HashMap();
                mapYearResult.put("area", areaStr);
                mapYearResult.put("type", "\u5176\u4ed6");
                mapYearResult.put("percent", df.format(Double.valueOf(areaStr) / sumArea));
                returnList.add(mapYearResult);
            }
        }
        return returnList;
    }

    @PostMapping(value={"/common"})
    public ResultBean CommonAnalysis(HttpServletRequest request) {
        HashMap<String, String> tempInfos;
        MultipartHttpServletRequest mpRequest = (MultipartHttpServletRequest)request;
        String sourceLayer = mpRequest.getParameter("sourceLayer");
        String field = mpRequest.getParameter("field");
        String crs = mpRequest.getParameter("crs");
        String geoType = mpRequest.getParameter("geoType");
        String GB = mpRequest.getParameter("GB");
        String overlayer = mpRequest.getParameter("file");
        List listGeometries = this.geoJson2jtwJson(overlayer);
        ArrayList<String> listTableIds = new ArrayList<String>();
        HashMap<String, Object> mapAll = new HashMap<String, Object>();
        DecimalFormat df = new DecimalFormat("0.00");
        JTSGeometryHelper jtsGeometryHelper = new JTSGeometryHelper();
        Map mapGB = (Map)JSON.parse((String)GB);
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("operate", "intersect");
        infos.put("destCrs", crs);
        infos.put("layerName", sourceLayer);
        infos.put("features", listGeometries);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", "wps");
        params.put("request", "featuresIntersect");
        params.put("version", "2017.06.21");
        params.put("featuresIntersect", JSON.toJSONString(infos));
        String result = OverlayController.sendPost((String)"http://192.168.19.46:8030/hgis/wps", params);
        Map templayerMap = null;
        try {
            templayerMap = (Map)JSON.parse((String)result);
        }
        catch (Exception e) {
            return new ResultBean((Object)"");
        }
        String tempLayerName = MapUtils.getString((Map)templayerMap, (Object)"data");
        if (StringUtils.isEmpty((String)tempLayerName)) {
            return new ResultBean(null);
        }
        if ("polygon".equals(geoType)) {
            tempInfos = new HashMap<String, String>();
            tempInfos.put("layerName", tempLayerName);
            tempInfos.put("calformula", "getarea");
            tempInfos.put("resultfield", "geo_area");
            tempInfos.put("descrs", "EPSG:4528");
            params = new HashMap();
            params.put("service", "wps");
            params.put("request", "fieldcal");
            params.put("version", "2017.06.21");
            params.put("fieldcal", JSON.toJSONString(tempInfos));
            result = OverlayController.sendPost((String)"http://192.168.19.46:8030/hgis/wps", params);
        } else if ("polyline".equals(geoType)) {
            tempInfos = new HashMap();
            tempInfos.put("layerName", tempLayerName);
            tempInfos.put("calformula", "getlength");
            tempInfos.put("resultfield", "geo_length");
            tempInfos.put("descrs", "EPSG:4528");
            params = new HashMap();
            params.put("service", "wps");
            params.put("request", "fieldcal");
            params.put("version", "2017.06.21");
            params.put("fieldcal", JSON.toJSONString(tempInfos));
            result = OverlayController.sendPost((String)"http://192.168.19.46:8030/hgis/wps", params);
        }
        templayerMap = (Map)JSON.parse((String)result);
        tempLayerName = MapUtils.getString((Map)templayerMap, (Object)"data");
        params = new HashMap();
        params.put("service", "wfs");
        params.put("request", "GetFeature");
        params.put("version", "1.1.0");
        params.put("typeName", tempLayerName);
        params.put("outputFormat", "application/json");
        params.put("maxFeatures", "1000000000");
        result = OverlayController.sendPost((String)"http://192.168.19.46:8030/hgis/wfs", params);
        String tempJson = jtsGeometryHelper.project(result, "EPSG:4490", "EPSG:4490");
        Map mapResult = (Map)JSON.parse((String)tempJson);
        mapAll.put("geometry", mapResult);
        List lstFeatures = (List)MapUtils.getObject((Map)mapResult, (Object)"features");
        HashMap<String, Double> mapStatistic = new HashMap<String, Double>();
        Double allArea = 0.0;
        int allCount = 0;
        for (Object mapFeat : lstFeatures) {
            Map mapProps = (Map)mapFeat.get("properties");
            if (!mapProps.containsKey(field)) continue;
            String value = mapProps.get(field).toString();
            for (String key : mapGB.keySet()) {
                if (!value.contains(key)) continue;
                value = (String)mapGB.get(key);
                break;
            }
            if ("polygon".equals(geoType)) {
                allArea = allArea + Double.parseDouble(mapProps.get("geo_area").toString());
            } else if ("polyline".equals(geoType)) {
                allArea = allArea + Double.parseDouble(mapProps.get("geo_length").toString());
            } else {
                allArea = allArea + Double.parseDouble(mapProps.get("area").toString());
                ++allCount;
            }
            if (mapStatistic.containsKey(value)) {
                Double count = (Double)mapStatistic.get(value);
                if ("polygon".equals(geoType)) {
                    mapStatistic.replace(value, count + Double.parseDouble(mapProps.get("geo_area").toString()));
                    continue;
                }
                if ("polyline".equals(geoType)) {
                    mapStatistic.replace(value, count + Double.parseDouble(mapProps.get("geo_length").toString()));
                    continue;
                }
                mapStatistic.replace(value, count + 1.0);
                continue;
            }
            if ("polygon".equals(geoType)) {
                mapStatistic.put(value, Double.parseDouble(mapProps.get("geo_area").toString()));
                continue;
            }
            if ("polyline".equals(geoType)) {
                mapStatistic.put(value, Double.parseDouble(mapProps.get("geo_length").toString()));
                continue;
            }
            mapStatistic.put(value, 1.0);
        }
        ArrayList listStatistic = new ArrayList();
        for (String key : mapStatistic.keySet()) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("type", key);
            if ("point".equals(geoType)) {
                temp.put("area", allCount);
                temp.put("percent", allArea);
            } else {
                temp.put("area", df.format(mapStatistic.get(key)));
                temp.put("percent", df.format((Double)mapStatistic.get(key) / allArea));
            }
            listStatistic.add(temp);
        }
        mapAll.put("statistic", listStatistic);
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyyMMdd");
        Date date = new Date();
        try {
            listTableIds.add(this.saveResult(sourceLayer + sdf.format(date), tempJson).getData().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        mapAll.put("layerName", sourceLayer);
        mapAll.put("tableIds", listTableIds);
        return new ResultBean(mapAll);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/analysis"})
    public ResultBean Analysis(@RequestParam(name="data") String sourcelayers, @RequestParam(name="overlay") String overlayer, @RequestParam(name="type") String type) {
        HashMap<String, Cloneable> mapResult = new HashMap<String, Cloneable>();
        HashMap<Object, Object> mapGeometries = new HashMap<Object, Object>();
        HashMap<Object, Object> mapAllStatistic = new HashMap<Object, Object>();
        ArrayList<String> listNames = new ArrayList<String>();
        ArrayList<String> listTableIds = new ArrayList<String>();
        HashMap<String, String> mapParams = new HashMap<String, String>();
        HashMap<String, Object> mapTemp = new HashMap<String, Object>();
        HashMap<Object, String> mapTempGeometries = new HashMap<Object, String>();
        DecimalFormat df = new DecimalFormat("0.00");
        JTSGeometryHelper jtsGeometryHelper = new JTSGeometryHelper();
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyyMMdd");
        List listJsonOverlayer = this.geoJson2jtwJson(overlayer);
        JSONArray arrJsonSourceLayers = JSON.parseArray((String)sourcelayers);
        Map mapTypes = (Map)JSON.parse((String)type);
        for (int i = 0; i < arrJsonSourceLayers.size(); ++i) {
            JSONObject sourceLayerInfo = JSON.parseObject((String)arrJsonSourceLayers.get(i).toString());
            String sourceYear = MapUtils.getString((Map)sourceLayerInfo, (Object)"year");
            String sourceLayerName = MapUtils.getString((Map)sourceLayerInfo, (Object)"name");
            String sourceLayerCrs = MapUtils.getString((Map)sourceLayerInfo, (Object)"crs");
            mapTemp.put("operate", "intersect");
            mapTemp.put("destCrs", sourceLayerCrs);
            mapTemp.put("layerName", sourceLayerName);
            mapTemp.put("features", listJsonOverlayer);
            mapParams.put("service", "wps");
            mapParams.put("request", "featuresIntersect");
            mapParams.put("version", "2017.06.21");
            mapParams.put("featuresIntersect", JSON.toJSONString(mapTemp));
            String overResult = OverlayController.sendPost((String)"http://192.168.19.46:8030/hgis/wps", mapParams);
            String tempLayerName = "";
            try {
                tempLayerName = MapUtils.getString((Map)((Map)JSON.parse((String)overResult)), (Object)"data");
            }
            catch (Exception ex) {
                tempLayerName = MapUtils.getString((Map)((Map)JSON.parse((String)JSON.parse((String)overResult).toString())), (Object)"data");
            }
            mapParams = new HashMap();
            mapTemp = new HashMap();
            mapTemp.put("layerName", tempLayerName);
            mapTemp.put("calformula", "getarea");
            mapTemp.put("resultfield", "geo_area");
            mapTemp.put("descrs", "EPSG:4528");
            mapParams.put("service", "wps");
            mapParams.put("request", "fieldcal");
            mapParams.put("version", "2017.06.21");
            mapParams.put("fieldcal", JSON.toJSONString(mapTemp));
            String areaResult = OverlayController.sendPost((String)"http://192.168.19.46:8030/hgis/wps", mapParams);
            try {
                tempLayerName = MapUtils.getString((Map)((Map)JSON.parse((String)areaResult)), (Object)"data");
            }
            catch (Exception ex) {
                return new ResultBean(null);
            }
            mapParams = new HashMap();
            mapParams.put("service", "wfs");
            mapParams.put("request", "GetFeature");
            mapParams.put("version", "1.1.0");
            mapParams.put("typeName", tempLayerName);
            mapParams.put("outputFormat", "application/json");
            mapParams.put("maxFeatures", "1000000000");
            String dataResult = OverlayController.sendPost((String)"http://192.168.19.46:8030/hgis/wfs", mapParams);
            String tempJson = jtsGeometryHelper.project(dataResult, "EPSG:4528", "EPSG:4490");
            Map mapData = (Map)JSON.parse((String)tempJson);
            mapGeometries.put(sourceYear, mapData);
            mapTempGeometries.put(sourceYear, dataResult);
            try {
                Date date = new Date();
                listTableIds.add(this.saveResult(sourceLayerName + sdf.format(date), tempJson).getData().toString());
                listNames.add(sourceLayerName + sdf.format(date));
            }
            catch (Exception date) {
                // empty catch block
            }
            Double allArea = 0.0;
            List listFeatures = (List)MapUtils.getObject((Map)mapData, (Object)"features");
            Iterator iterator = listFeatures.iterator();
            while (iterator.hasNext()) {
                Map mapAttribute = (Map)iterator.next();
                Map mapProperties = (Map)mapAttribute.get("properties");
                allArea = allArea + Double.parseDouble(mapProperties.get("geo_area").toString()) / 10000.0;
            }
            BaseConverter iterator2 = new BaseConverter();
            ArrayList listStatisticResult = new ArrayList();
            for (Object typeName : mapTypes.keySet()) {
                Object mapProperties;
                ArrayList listFeature = Lists.newArrayList();
                Double typeArea = 0.0;
                Iterator iterator3 = listFeatures.iterator();
                while (iterator3.hasNext()) {
                    Map mapAttribute = (Map)iterator3.next();
                    mapProperties = (Map)mapAttribute.get("properties");
                    if (!mapProperties.get("CC").toString().startsWith((String)typeName)) continue;
                    typeArea = typeArea + Double.parseDouble(mapProperties.get("geo_area").toString()) / 10000.0;
                    if (!(Double.parseDouble(mapProperties.get("geo_area").toString()) > 0.0)) continue;
                    listFeature.add(JSON.parseObject((String)mapAttribute.toString(), Feature.class));
                }
                cn.gtmap.gtc.gis.domain.esm.FeatureCollection featureCollection = new cn.gtmap.gtc.gis.domain.esm.FeatureCollection();
                if (listFeature.size() > 0) {
                    featureCollection.setFeatures((List)listFeature);
                }
                if (((String)typeName).equals("02") || ((String)typeName).equals("01") || ((String)typeName).equals("03") || ((String)typeName).equals("04")) {
                    boolean hasType = false;
                    mapProperties = listStatisticResult.iterator();
                    while (mapProperties.hasNext()) {
                        Map map = (Map)mapProperties.next();
                        if (!map.get("type").equals(mapTypes.get(typeName))) continue;
                        hasType = true;
                        map.replace("area", Double.parseDouble(map.get("area").toString()) + typeArea);
                    }
                    if (hasType) continue;
                    HashMap<String, String> mapStatistic = new HashMap<String, String>();
                    mapStatistic.put("area", String.valueOf(df.format(typeArea)));
                    mapStatistic.put("percent", String.valueOf(df.format(typeArea / allArea)));
                    mapStatistic.put("type", (String)mapTypes.get(typeName));
                    try {
                        mapStatistic.put("geo", featureCollection.toJson());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    listStatisticResult.add(mapStatistic);
                    continue;
                }
                HashMap<String, String> mapStatistic = new HashMap<String, String>();
                mapStatistic.put("area", String.valueOf(df.format(typeArea)));
                mapStatistic.put("percent", String.valueOf(df.format(typeArea / allArea)));
                mapStatistic.put("type", (String)mapTypes.get(typeName));
                try {
                    mapStatistic.put("geo", featureCollection.toJson());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                listStatisticResult.add(mapStatistic);
            }
            mapAllStatistic.put(sourceYear, listStatisticResult);
        }
        mapResult.put("statistic", mapAllStatistic);
        mapResult.put("geometry", mapGeometries);
        if (arrJsonSourceLayers.size() > 1) {
            DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
            ArrayList<SimpleFeatureCollection> listFeatureCollections = new ArrayList<SimpleFeatureCollection>();
            for (String sourceYear : mapGeometries.keySet()) {
                listFeatureCollections.add((SimpleFeatureCollection)jtsGeometryHelper.readUnTypeGeoJSON(mapTempGeometries.get(sourceYear).toString()));
            }
            SimpleFeatureIterator iterator2 = ((SimpleFeatureCollection)listFeatureCollections.get(1)).features();
            ArrayList listPart = new ArrayList();
            while (iterator2.hasNext()) {
                Map<void, Double> mapPart = new HashMap<String, String>();
                SimpleFeature feature2 = (SimpleFeature)iterator2.next();
                Geometry geometry2 = (Geometry)feature2.getDefaultGeometry();
                String type2Code = "";
                String type2 = "";
                boolean hasPart = false;
                for (Property p : feature2.getProperties()) {
                    if (!"CC".equals(p.getName().getLocalPart())) continue;
                    type2 = p.getValue().toString();
                    type2Code = p.getValue().toString();
                    for (String string : mapTypes.keySet()) {
                        if (!type2.startsWith(string)) continue;
                        type2 = (String)mapTypes.get(string);
                        break;
                    }
                    for (Map map : listPart) {
                        if (!map.get("type").equals(type2)) continue;
                        hasPart = true;
                        mapPart = map;
                        break;
                    }
                    if (hasPart) break;
                    mapPart.put((void)"type", (Double)((Object)type2));
                    break;
                }
                SimpleFeatureType featureType2 = feature2.getFeatureType();
                SimpleFeatureIterator iterator1 = ((SimpleFeatureCollection)listFeatureCollections.get(0)).features();
                while (iterator1.hasNext()) {
                    Geometry geometry1;
                    Geometry intersection;
                    void var31_46;
                    SimpleFeature feature1 = (SimpleFeature)iterator1.next();
                    String string = "";
                    block23: for (Property p : feature1.getProperties()) {
                        if (!"CC".equals(p.getName().getLocalPart())) continue;
                        String string2 = p.getValue().toString();
                        for (String key : mapTypes.keySet()) {
                            if (!string2.startsWith(key)) continue;
                            String string3 = (String)mapTypes.get(key);
                            break block23;
                        }
                    }
                    if (var31_46.equals(type2) || (intersection = OverlayController.validate((Geometry)OverlayController.validate((Geometry)(geometry1 = (Geometry)feature1.getDefaultGeometry())).intersection(OverlayController.validate((Geometry)geometry2)))).isEmpty() || !"POLYGON".equals(intersection.getGeometryType().toUpperCase())) continue;
                    SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType2);
                    featureBuilder.add((Object)intersection);
                    featureBuilder.set("CC", (Object)type2Code);
                    collection.add(featureBuilder.buildFeature("feature".concat(UUIDGenerator.generate())));
                    double area = intersection.getArea();
                    if (mapPart.containsKey(var31_46)) {
                        Double value = (Double)mapPart.get(var31_46);
                        value = value + area / 10000.0;
                        mapPart.replace(var31_46, Double.parseDouble(df.format(value)));
                        continue;
                    }
                    mapPart.put(var31_46, Double.parseDouble(df.format(area / 10000.0)));
                }
                if (hasPart) continue;
                listPart.add(mapPart);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            String geojson = this.toFeatureJSON((Object)collection);
            if (StringUtils.isNotBlank((String)geojson)) {
                geojson = jtsGeometryHelper.project(geojson, "EPSG:4528", "EPSG:4490");
                try {
                    Date date = new Date();
                    listTableIds.add(this.saveResult("\u5bf9\u6bd4\u7ed3\u679c" + sdf.format(date), geojson).getData().toString());
                    listNames.add("\u5bf9\u6bd4\u7ed3\u679c" + sdf.format(date));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            map.put("statistic", listPart);
            map.put("geometries", geojson);
            mapResult.put("compare", map);
        }
        mapResult.put("names", listNames);
        mapResult.put("tableIds", listTableIds);
        return new ResultBean(mapResult);
    }

    @PostMapping(value={"/ga/analysis"})
    public ResultBean GaAnalysis(@RequestParam(name="data") String sourcelayers, @RequestParam(name="overlay") String overlayer, @RequestParam(name="type") String type) {
        HashMap<String, Cloneable> mapResult = new HashMap<String, Cloneable>();
        HashMap<String, List> mapStatic = new HashMap<String, List>();
        HashMap<String, ArrayList> map2 = new HashMap<String, ArrayList>();
        ArrayList listTableIds = Lists.newArrayList();
        ArrayList listNames = Lists.newArrayList();
        HashMap geometrys = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyyMMdd");
        JSONArray arrJsonSourceLayers = JSON.parseArray((String)sourcelayers);
        Map mapTypes = (Map)JSON.parse((String)type);
        String thisyear = "";
        String preyear = "";
        String fxtype = "";
        for (int i = 0; i < arrJsonSourceLayers.size(); ++i) {
            JSONObject sourceLayerInfo = JSON.parseObject((String)arrJsonSourceLayers.get(i).toString());
            String sourceYear = MapUtils.getString((Map)sourceLayerInfo, (Object)"year");
            if (StringUtils.isEmpty((String)thisyear)) {
                thisyear = sourceYear;
                continue;
            }
            preyear = sourceYear;
        }
        if (arrJsonSourceLayers.size() > 1) {
            fxtype = "allyear";
            if (Double.valueOf(thisyear) < Double.valueOf(preyear)) {
                String zjz = thisyear;
                thisyear = preyear;
                preyear = zjz;
            }
        } else if (thisyear.equals("2015")) {
            fxtype = "preyear";
            thisyear = "2016";
            preyear = "2015";
        } else if (thisyear.equals("2017")) {
            fxtype = "preyear";
            thisyear = "2018";
            preyear = "2017";
        } else {
            fxtype = "thisyear";
            preyear = String.valueOf(Integer.valueOf(thisyear) - 1);
        }
        String analysisUrl = "http://192.168.18.126:9016/v2/gis/analysis/ga/summarize/year";
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("thisyear", thisyear);
        map1.put("preyear", preyear);
        map1.put("fxtype", fxtype);
        map1.put("geoJson", overlayer);
        String analysisResult = OverlayController.httpPost((String)analysisUrl, map1);
        Map fxmap = (Map)((Map)JSON.parseObject((String)analysisResult, Map.class)).get("data");
        if (fxtype.equals("thisyear") || fxtype.equals("preyear")) {
            String keyStr = "";
            String typefield = "";
            if (fxtype.equals("thisyear")) {
                keyStr = thisyear;
                typefield = "newcc";
            } else {
                keyStr = preyear;
                typefield = "newcc_overlay";
            }
            JSONObject jsonObject1 = (JSONObject)fxmap.get(keyStr);
            String geojson = this.getYearFeatureCol(jsonObject1, typefield);
            Date date = new Date();
            listTableIds.add(geojson);
            listNames.add(keyStr + "\u5e74\u7edf\u8ba1\u7ed3\u679c" + sdf.format(date));
            JSONArray features1 = (JSONArray)jsonObject1.get((Object)"features");
            List mapYearResult = OverlayController.getYearMap((JSONArray)features1, (String)fxtype, (Map)mapTypes);
            mapStatic.put(keyStr, mapYearResult);
        } else {
            Date date = new Date();
            JSONObject jsonObject1 = (JSONObject)fxmap.get(thisyear);
            String geojson1 = this.getYearFeatureCol(jsonObject1, "newcc");
            listTableIds.add(geojson1);
            listNames.add(thisyear + "\u5e74\u7edf\u8ba1\u7ed3\u679c" + sdf.format(date));
            JSONArray features1 = (JSONArray)jsonObject1.get((Object)"features");
            List mapYearResult1 = OverlayController.getYearMap((JSONArray)features1, (String)"thisyear", (Map)mapTypes);
            mapStatic.put(thisyear, mapYearResult1);
            date = new Date();
            JSONObject jsonObject2 = (JSONObject)fxmap.get(preyear);
            String geojson2 = this.getYearFeatureCol(jsonObject2, "newcc_overlay");
            listTableIds.add(geojson2);
            listNames.add(preyear + "\u5e74\u7edf\u8ba1\u7ed3\u679c" + sdf.format(date));
            JSONArray features2 = (JSONArray)jsonObject2.get((Object)"features");
            List mapYearResult2 = OverlayController.getYearMap((JSONArray)features2, (String)"preyear", (Map)mapTypes);
            mapStatic.put(preyear, mapYearResult2);
            date = new Date();
            DecimalFormat df = new DecimalFormat("#.0000");
            ArrayList listMap = Lists.newArrayList();
            JSONObject jsonObject3 = (JSONObject)fxmap.get("compare");
            String geojson3 = this.getYearFeatureCol(jsonObject3, "ccchange");
            listTableIds.add(geojson3);
            listNames.add("\u5bf9\u6bd4\u7ed3\u679c" + sdf.format(date));
            JSONArray features3 = (JSONArray)jsonObject3.get((Object)"features");
            for (String key : mapTypes.keySet()) {
                String value = (String)mapTypes.get(key);
                HashMap tpMap = new HashMap();
                tpMap.put("type", value);
                for (int j = 0; j < features3.size(); ++j) {
                    JSONObject jsonObject = features3.getJSONObject(j);
                    String areaStr = jsonObject.getJSONObject("properties").getString("AREA");
                    String typeStr = jsonObject.getJSONObject("properties").getString("ccchange");
                    if (!typeStr.contains("-")) continue;
                    if (typeStr.substring(0, 1).equals("-")) {
                        String string = typeStr.split("-")[0];
                        continue;
                    }
                    if (typeStr.split("-").length == 1) {
                        tpMap.put("\u5176\u4ed6", df.format(Double.valueOf(areaStr)));
                        continue;
                    }
                    try {
                        String preType = typeStr.split("-")[0];
                        String thisType = typeStr.split("-")[1];
                        if (!preType.equals(key) || preType.equals(thisType)) continue;
                        tpMap.put(mapTypes.get(thisType), df.format(Double.valueOf(areaStr)));
                        continue;
                    }
                    catch (Exception ex) {
                        String string = ex.getMessage();
                    }
                }
                listMap.add(tpMap);
            }
            map2.put("statistic", listMap);
        }
        mapResult.put("statistic", mapStatic);
        mapResult.put("geometry", geometrys);
        mapResult.put("compare", map2);
        mapResult.put("names", listNames);
        mapResult.put("tableIds", listTableIds);
        return new ResultBean(mapResult);
    }

    @PostMapping(value={"/apply"})
    public ResultBean applyDownload(@RequestParam(name="id") String tableIds, @RequestParam(name="reason") String reason) {
        UserDto userDto = this.userClient.getCurrentUser();
        String userName = userDto.getUsername();
        String userId = userDto.getId();
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyyMMdd");
        try {
            String processInsId = "";
            TaskData applyTask = this.processInsClient.startUpProcess(this.applyDefKey, userName, "a8deac2e-7ce1-4896-b0bf-9d765ba0c3ce", "\u7533\u8bf7\u6570\u636e", Integer.valueOf(50), "dataGovernance", "8aaa1d436bb1ff5a016bdbb987540056", Integer.valueOf(30), Integer.valueOf(0), "");
            processInsId = applyTask.getProcessInstanceId();
            TransferData transferData = new TransferData();
            this.simpleProcessClient.transferProcess(applyTask.getTaskId(), transferData);
            List listTableIds = (List)JSON.parse((String)tableIds);
            for (String tableId : listTableIds) {
                ApplyDataInfo info = new ApplyDataInfo();
                info.setTableId(tableId);
                Map tableInfo = (Map)this.dataStoreClient.RegisteredTable(tableId).getData();
                info.setUserId(userId);
                info.setUserName(userName);
                info.setLayerName(((Map)tableInfo.get("tableName")).get("value").toString());
                info.setReason(reason);
                info.setState("0");
                info.setTime(sdf.format(now));
                info.setReviewer("");
                info.setProcessInsId(processInsId);
                this.applyDataClient.submitDownload(info);
            }
            return new ResultBean((Object)processInsId);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @PostMapping(value={"/apply/update"})
    public ResultBean updateApply(@RequestParam(value="processInsId") String processInsId, @RequestParam(value="result") String result, @RequestParam(value="option") String option) {
        UserDto userDto = this.userClient.getCurrentUser();
        String userName = userDto.getUsername();
        return this.applyDataClient.updateApply(processInsId, result, option, userName);
    }

    @PostMapping(value={"/saveResult"})
    public ResultBean saveResult(@RequestParam(name="layerName") String layerName, @RequestParam(name="featureCollection") String featureCollection) {
        HashMap params = Maps.newHashMap();
        params.put("instanceId", this.instanceId);
        params.put("dataStore", null);
        params.put("featureCollection", featureCollection);
        params.put("layerName", layerName);
        ResultBean result = this.dataStoreClient.createTableByFeatureCollection2((Map)params);
        if (result != null) {
            String id = result.getData().toString();
            UserDto user = this.userClient.getCurrentUser();
            String userName = user.getUsername();
            String createBy = "{\"createBy\":\"" + userName + "\"}";
            this.dataStoreClient.updateRegisterTable(id, createBy);
            List list = this.authService.saveDataAuthority("self", "ccglzy", "\u4ed3\u50a8\u7ba1\u7406\u8d44\u6e90", id, "");
        }
        return result;
    }

    @PostMapping(value={"/editLayerName"})
    public ResultBean editLayerName(@RequestParam(value="layerName") String layerName, @RequestParam(value="tableId") String tableId) {
        String attr = "{\"tableName\":\"" + layerName + "\"}";
        return this.dataStoreClient.updateRegisterTable(tableId, attr);
    }
}

