/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.dg.service.MockService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/config"})
public class MockRestController {
    @Autowired
    private MockService mockService;
    @Value(value="${app.version}")
    protected String appVersion;

    @GetMapping(value={"/mock/{type}"})
    public String getMockInfoByType(@PathVariable(name="type") String type) {
        return this.mockService.getMockInfoByTypeAndVersion(type, this.appVersion);
    }

    @GetMapping(value={"/mock/{type}/{version}"})
    public String getMockInfoByTypeAndVersion(@PathVariable(name="type") String type, @PathVariable(name="version") String version) {
        if (version.equals("default")) {
            return this.mockService.getMockInfoByTypeAndVersion(type, "");
        }
        return this.mockService.getMockInfoByTypeAndVersion(type, version);
    }
}

