/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.common.domain.core.PageBean;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.dg.service.MetaInfoService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/metainfo"})
public class MetaInfoController {
    @Autowired
    private MetaInfoService metainfoService;

    @GetMapping(value={"/meta"})
    Map getMetaInfo(@RequestParam(value="id") String id) {
        ResultBean result = this.metainfoService.getDataDescription(id);
        HashMap<String, Object> metaMap = new HashMap<String, Object>();
        if (result.getCode() == 0) {
            metaMap.put("code", "0");
            metaMap.put("msg", "");
            metaMap.put("count", "1000");
            String sjson = "[";
            String tags = "";
            Map dataMap = (Map)result.getData();
            for (Map.Entry entry : dataMap.entrySet()) {
                if (entry.getKey() == "columns" || entry.getKey() == "id" || entry.getKey() == "instanceId" || entry.getKey() == "layerName" || entry.getValue() == null) continue;
                HashMap valueMap = (HashMap)entry.getValue();
                String label = "";
                String value = "";
                for (Map.Entry entry1 : valueMap.entrySet()) {
                    if (entry1.getKey() == "alias" && entry1.getValue() != null) {
                        label = entry1.getValue().toString();
                        continue;
                    }
                    if (entry1.getKey() != "value" || entry1.getValue() == null) continue;
                    if ("\u6570\u636e\u6807\u7b7e".equals(label)) {
                        tags = JSON.toJSONString(entry1.getValue());
                    }
                    value = entry1.getValue().toString();
                }
                sjson = sjson + "{\"name\": \"" + (String)entry.getKey() + "\",\"label\":\"" + label + "\",\"value\":\"" + value + "\"},";
            }
            sjson = sjson.substring(0, sjson.length() - 1);
            sjson = sjson + "]";
            metaMap.put("data", JSON.parse((String)sjson));
            metaMap.put("tags", tags);
        }
        return metaMap;
    }

    @GetMapping(value={"/field"})
    Map getFieldInfosbyPage(@RequestParam(value="id") String id, @RequestParam(value="page", required=false, defaultValue="1") int page, @RequestParam(value="limit", required=false, defaultValue="100") int limit) {
        int maxCount = page * limit;
        int minCount = (page - 1) * limit;
        boolean currentCount = false;
        ResultBean result = this.metainfoService.getDataDescription(id);
        HashMap<String, Object> metaMap = new HashMap<String, Object>();
        if (result.getCode() == 0) {
            metaMap.put("code", "0");
            metaMap.put("msg", "");
            Map dataMap = (Map)result.getData();
            for (Map.Entry entry : dataMap.entrySet()) {
                if (entry.getKey() != "columns") continue;
                HashMap resultMap = new HashMap();
                ArrayList fieldArray = (ArrayList)entry.getValue();
                metaMap.put("count", fieldArray.size());
                if (maxCount > fieldArray.size()) {
                    metaMap.put("data", fieldArray.subList(minCount, fieldArray.size()));
                    continue;
                }
                metaMap.put("data", fieldArray.subList(minCount, maxCount));
            }
        }
        return metaMap;
    }

    @PostMapping(value={"/edit"})
    ResultBean editMetaInfo(@RequestParam(value="id") String id, @RequestParam(value="info") String info) {
        return this.metainfoService.editMetaInfo(id, info);
    }

    @PostMapping(value={"/edit-tags"})
    ResultBean editMetaInfoTags(HttpServletRequest req) {
        String[] tags = req.getParameterValues("tags[]");
        String id = req.getParameter("id");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "1");
        HashSet<String> set = new HashSet<String>(Arrays.asList(tags));
        return this.metainfoService.editMetaInfoTags(id, JSON.toJSONString(map), set);
    }

    @PostMapping(value={"/editfield"})
    ResultBean editFieldInfo(@RequestParam(value="id") String id, @RequestParam(value="info") String info) {
        return this.metainfoService.editFieldInfo(id, info);
    }

    @PostMapping(value={"/add"})
    ResultBean addField(@RequestParam(value="id") String id, @RequestParam(value="info") String info) {
        return this.metainfoService.addField(id, info);
    }

    @PostMapping(value={"/delete"})
    ResultBean deleteField(@RequestParam(value="id") String id) {
        return this.metainfoService.deleteinfo(id);
    }

    @GetMapping(value={"/type"})
    Map getFieldType() {
        String json = "[{\"id\":\"1\",\"name\":\"\u6574\u578b\"},{\"id\":\"2\",\"name\":\"\u6d6e\u70b9\u578b\"},{\"id\":\"3\",\"name\":\"\u6587\u672c\"},{\"id\":\"4\",\"name\":\"\u65f6\u95f4\"},]";
        HashMap<String, Object> metaMap = new HashMap<String, Object>();
        metaMap.put("data", JSON.parse((String)json));
        return metaMap;
    }

    @GetMapping(value={"/data"})
    Map getDataInfosbyPage(@RequestParam(value="id") String id, @RequestParam(value="page") int page, @RequestParam(value="limit") int limit) {
        PageBean data = this.metainfoService.getDataInfo(id, page, limit);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String props = "[";
        ArrayList dataMap = new ArrayList();
        String sCount = data.getCount().toString();
        if (data.getCode() == 0) {
            ArrayList list = (ArrayList)data.getData();
            Map map = (Map)list.get(0);
            String json = JSON.toJSONString((Object)map);
            JSONObject jsObj = JSONObject.parseObject((String)json);
            JSONArray features = jsObj.getJSONArray("features");
            for (int i = 0; i < features.size(); ++i) {
                JSONObject feature = features.getJSONObject(i);
                JSONObject properties = feature.getJSONObject("properties");
                props = props + properties.toJSONString() + ",";
            }
            props = props.substring(0, props.length() - 1);
            props = props + "]";
        }
        resultMap.put("code", 0);
        resultMap.put("msg", "");
        resultMap.put("count", sCount);
        resultMap.put("data", JSON.parse((String)props));
        return resultMap;
    }

    @GetMapping(value={"/geo"})
    Map getGeoJson(@RequestParam(value="id") String id) {
        PageBean data = this.metainfoService.getGeoInfo(id);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (data.getCode() == 0) {
            List listGeo = data.getData();
            String json = JSON.toJSONString((Object)listGeo);
            resultMap.put("code", 0);
            resultMap.put("msg", "");
            resultMap.put("data", json);
        }
        return resultMap;
    }

    @GetMapping(value={"/tags"})
    List<Map> queryTags() {
        ArrayList<Map> listTags = new ArrayList<Map>();
        ResultBean resultTags = this.metainfoService.queryTags();
        ArrayList arrayTags = (ArrayList)resultTags.getData();
        for (String tag : arrayTags) {
            HashMap<String, String> t = new HashMap<String, String>();
            t.put("name", tag);
            t.put("value", tag);
            listTags.add(t);
        }
        listTags.sort((tag1, tag2) -> tag1.get("name").toString().compareTo(tag2.get("name").toString()));
        return listTags;
    }

    @GetMapping(value={"/instance"})
    ResultBean getInstanceInfos(@RequestParam(value="instanceId") String instanceId) {
        return this.metainfoService.getInstanceInfos(instanceId);
    }
}

