/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.dg.service.LogService;
import cn.gtmap.gtc.sso.domain.dto.AccessStatsDto;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/yzylog"})
public class LogController {
    @Autowired
    private LogService logService;

    @GetMapping(value={"/hot"})
    public ResultBean getHotResource(@RequestParam(name="start") long start, @RequestParam(name="end") long end) {
        try {
            return new ResultBean((Object)this.logService.getHotResource(start, end));
        }
        catch (Exception e) {
            return new ResultBean();
        }
    }

    @GetMapping(value={"/getHotResourcePercent"})
    public Map getHotResourcePercent(@RequestParam(name="start") long start, @RequestParam(name="end") long end) {
        return this.logService.getHotResourcePercent(start, end);
    }

    @GetMapping(value={"/year/number"})
    public long getResourceYearNumber(String resourceId) {
        return this.logService.getResourceCountByYear(resourceId);
    }

    @GetMapping(value={"/week/number"})
    public long getResourceWeekNumber(String resourceId) {
        return this.logService.getResourceCountByWeek(resourceId);
    }

    @GetMapping(value={"/year/detail"})
    public List<String> getDetailYear(String resourceId) {
        return this.logService.getResourceDetailByYear(resourceId);
    }

    @GetMapping(value={"/week/detail"})
    public ResultBean getDetailWeek(@RequestParam(name="id") String resourceId) {
        return new ResultBean((Object)this.logService.getResourceDetailByWeek(resourceId));
    }

    @GetMapping(value={"/total/ids"})
    public long getToltalByIds(String resourceIds, String startTime, String endTime) {
        Date date = new Date();
        return this.logService.getResourceByResourceId(resourceIds, 0L, date.getTime());
    }

    @GetMapping(value={"/access-stats"})
    @ApiOperation(value="\u8d44\u6e90\u8bbf\u95ee\u603b\u91cf\u7edf\u8ba1")
    public AccessStatsDto accessStatistics(@RequestParam(name="event", required=false) String event, @RequestParam(name="principal", required=false) String principal, @RequestParam(name="begin", required=false) Long begin, @RequestParam(name="end", required=false) Long end) {
        return this.logService.accessStatistics(event, principal, begin, end);
    }
}

