/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.common.clients.dc.dgk.JobClient;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/job"})
public class JobController {
    @Autowired
    private JobClient jobClient;

    @RequestMapping(value={"/list"})
    public ResultBean list() {
        return this.jobClient.getJobList();
    }

    @RequestMapping(value={"/start"})
    public ResultBean start(String id) {
        return this.jobClient.startJob(id);
    }

    @RequestMapping(value={"/stop"})
    public ResultBean stop(String id) {
        return this.jobClient.stopJob(id);
    }

    @PostMapping(value={"/edit"})
    public ResultBean edit(@RequestParam(name="id", defaultValue="") String id, @RequestParam(name="description", defaultValue="") String description, @RequestParam(name="name", defaultValue="") String name, @RequestParam(name="status", defaultValue="") String status) {
        return this.jobClient.edit(id, description, name, status);
    }

    @PostMapping(value={"/timing/set"})
    public ResultBean setTiming(@RequestParam(name="id", defaultValue="") String id, @RequestBody Map data) throws Exception {
        return this.jobClient.setTiming(id, data);
    }

    @GetMapping(value={"/timing/get"})
    public ResultBean getTiming(@RequestParam(name="id", defaultValue="") String id) {
        return this.jobClient.getTiming(id);
    }

    @RequestMapping(value={"/log/his"})
    public ResultBean getLogHis(@RequestParam(name="id") String id, @RequestParam(name="page", defaultValue="-1") int page, @RequestParam(name="size", defaultValue="-1") int size) {
        return this.jobClient.getLogHis(id, page, size);
    }

    @PostMapping(value={"/add"}, consumes={"multipart/form-data"})
    public ResultBean add(@RequestParam(name="description") String description, @RequestParam(name="name") String name, @RequestPart(name="kjbfile") MultipartFile kjbfile) {
        return this.jobClient.add(description, name, kjbfile);
    }
}

