/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.common.clients.dw.mdb.DataStoreClient;
import cn.gtmap.gtc.common.clients.dw.mdb.MapServiceClient;
import cn.gtmap.gtc.common.domain.core.PageBean;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.dg.service.AuthorityService;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RequestMapping(value={"/gs"})
@RestController
public class GeoServerController {
    @Autowired
    private MapServiceClient geoClient;
    @Autowired
    private DataStoreClient dataStoreClient;
    @Autowired
    UserManagerClient userClient;
    @Autowired
    AuthorityService authService;

    @ApiOperation(value="\u521b\u5efa\u5de5\u4f5c\u533a")
    @PostMapping(value={"/create/workspace"})
    public ResultBean createWorkspace(@RequestParam(value="workspace") String workspace) {
        return this.geoClient.createWorkspace(workspace);
    }

    @ApiOperation(value="\u521b\u5efa\u6570\u636e\u4ed3\u5e93\u8fde\u63a5")
    @PostMapping(value={"/create/datastore"})
    public ResultBean createDataStore(@RequestParam(value="datastore") String storeName, @RequestParam(value="parameters") String parameters) {
        return this.geoClient.createDataStore(storeName, parameters);
    }

    @ApiOperation(value="\u56fe\u5c42\u53d1\u5e03\uff0c\u9ed8\u8ba4\u6837\u5f0f")
    @PostMapping(value={"/layer/publish"})
    public ResultBean pulishLayerDefaultStyle(HttpServletRequest req) {
        HashSet<String> set;
        String styleName;
        String serviceName;
        UserDto user = this.userClient.getCurrentUser();
        String userName = user.getUsername();
        String[] array = req.getParameterValues("keywords[]");
        String tableId = req.getParameter("tableId");
        ResultBean result = this.geoClient.pulishLayerDefaultStyle(tableId, serviceName = req.getParameter("serviceName"), userName, styleName = req.getParameter("addstyleName"), set = new HashSet<String>(Arrays.asList(array)));
        if (result.getCode() > 0) {
            return result;
        }
        String moduleCode = req.getParameter("moduleCode");
        String moduleName = req.getParameter("moduleName");
        String serviceid = ((ArrayList)result.getData()).get(1).toString();
        List listResult = this.authService.saveDataAuthority("self", moduleCode, moduleName, serviceid, "");
        return result;
    }

    @ApiOperation(value="\u56fe\u5c42\u9884\u53d1\u5e03")
    @PostMapping(value={"/layer/temppublish"})
    public ResultBean pulishTempLayer(HttpServletRequest req) {
        String tableId = req.getParameter("tableId");
        String styleName = req.getParameter("addstyleName");
        ResultBean result = this.geoClient.pulishTempLayer(tableId, styleName);
        return result;
    }

    @ApiOperation(value="\u5217\u51fa\u5df2\u53d1\u5e03\u670d\u52a1")
    @GetMapping(value={"/mapservice/list"})
    public PageBean listMetaMapService(@RequestParam(name="page", defaultValue="1") Integer pageIndex, @RequestParam(name="limit", defaultValue="20") Integer pageSize, @RequestParam(name="withthumbnail", required=false, defaultValue="false") boolean withthumbnail, @RequestParam(name="keywords", required=false, defaultValue="") String keywords, @RequestParam(name="moduleCode", required=false, defaultValue="fwglzy") String moduleCode, @RequestParam(name="ownState", required=false, defaultValue="private") String ownState) {
        HashMap mapCreator;
        PageBean result;
        UserDto user = this.userClient.getCurrentUser();
        String userName = user.getUsername();
        List listServiceIds = new ArrayList();
        if (!"null".equals(moduleCode)) {
            String authorityCode = "";
            boolean isEqual = !"private".equals(ownState);
            List authoritiesList = this.authService.getAllOperation();
            for (Map map : authoritiesList) {
                if ((!"private".equals(ownState) || !map.get("name").toString().equals("\u4fee\u6539")) && (!"public".equals(ownState) || !map.get("name").toString().equals("\u67e5\u8be2"))) continue;
                authorityCode = map.get("value").toString();
            }
            listServiceIds = this.authService.queryCode(userName, moduleCode, authorityCode, isEqual);
            if (listServiceIds.size() == 0) {
                return new PageBean();
            }
        }
        if ((result = this.geoClient.listMetaMapService1(keywords, JSON.toJSONString(mapCreator = new HashMap()), new HashSet(listServiceIds), withthumbnail, pageIndex, pageSize)) == null) {
            return new PageBean();
        }
        return result;
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u53d1\u5e03\u670d\u52a1")
    @GetMapping(value={"/mapservice/{id}"})
    public PageBean getMapServiceByID(@PathVariable(name="id") String id) {
        return this.geoClient.getMapServiceByID(id);
    }

    @ApiOperation(value="\u6839\u636etableId\u83b7\u53d6\u53d1\u5e03\u670d\u52a1")
    @GetMapping(value={"/mapservice1/{tableId}"})
    public PageBean getMapServiceByTableID(@PathVariable(name="tableId") String tableId) {
        return this.geoClient.getMapServiceByTableID(tableId);
    }

    @ApiOperation(value="\u7ed1\u5b9a\u53d1\u5e03\u56fe\u5c42\u9ed8\u8ba4\u6837\u5f0f")
    @PutMapping(value={"/layer/style"})
    public ResultBean updateMapStyle(@RequestParam(name="serviceId") String serviceId, @RequestParam(name="styleName") String styleName) {
        return this.geoClient.updateMapStyle(serviceId, styleName);
    }

    @ApiOperation(value="\u5f00\u542f\u5173\u95ed\u5730\u56fe\u670d\u52a1")
    @PostMapping(value={"/layer/enable"})
    public ResultBean setMapServiceEnabled(@RequestParam(name="serviceId") String serviceId, @RequestParam(name="enable") boolean enable) {
        return this.geoClient.setMapServiceEnabled(serviceId, enable);
    }

    @ApiOperation(value="\u5220\u9664\u5730\u56fe\u670d\u52a1")
    @PostMapping(value={"/layer/delete"})
    public ResultBean deleteMapService(@RequestParam(name="serviceId") String serviceId, @RequestParam(value="moduleCode") String moduleCode, @RequestParam(value="moduleName") String moduleName) {
        ResultBean deleteResult = this.geoClient.deleteMapService(serviceId);
        if (deleteResult.getCode() == 0) {
            UserDto user = this.userClient.getCurrentUser();
            String userName = user.getUsername();
            return new ResultBean((Object)this.authService.deleteAuthorityAndDataSource(userName, moduleCode, moduleName, serviceId));
        }
        return new ResultBean((Object)false);
    }

    @ApiOperation(value="\u66f4\u65b0\u670d\u52a1\u4fe1\u606f")
    @PostMapping(value={"/layer/update"})
    public ResultBean updateMapservice(HttpServletRequest req) {
        String[] array = req.getParameterValues("keywords[]");
        String serviceId = req.getParameter("id");
        String attributes = req.getParameter("attributes");
        HashSet<String> set = new HashSet<String>(Arrays.asList(array));
        return this.geoClient.updateMapservice(serviceId, attributes, set);
    }

    @ApiOperation(value="\u83b7\u53d6\u6807\u7b7e")
    @PostMapping(value={"/layer/tags"})
    public List<Map> getAllTags() {
        ArrayList<Map> result = new ArrayList<Map>();
        List keywordList = null;
        for (int i = 0; i < keywordList.size(); ++i) {
            HashMap t = new HashMap();
            t.put("name", keywordList.get(i));
            t.put("value", keywordList.get(i));
            result.add(t);
        }
        return result;
    }

    @PostMapping(value={"/style/publish"})
    @ResponseBody
    public ResultBean execute(HttpServletRequest request) {
        MultipartHttpServletRequest mpRequest = (MultipartHttpServletRequest)request;
        MultipartFile file = mpRequest.getFile("file");
        return new ResultBean((Object)this.geoClient.publishSLDStyle(file));
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6837\u5f0f")
    @GetMapping(value={"/publishedstyle"})
    public PageBean listStyles(@RequestParam(name="page") Integer page, @RequestParam(name="limit") Integer limit) {
        PageBean rsb = this.geoClient.listSLDStyles(page, limit);
        return rsb;
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6837\u5f0f")
    @PostMapping(value={"/stylewiththumbnail"})
    public PageBean listStylesWithThumbnail(@RequestParam(name="page") Integer page, @RequestParam(name="limit") Integer limit) {
        PageBean rsb = this.geoClient.listSLDStylesWithThumbnail(page, limit);
        return rsb;
    }

    @ApiOperation(value="\u5220\u9664\u6837\u5f0f")
    @PostMapping(value={"/delmapstyle"})
    public ResultBean delMapStyles(@RequestParam(name="styleNames") String styleNames) {
        ResultBean rsb = this.geoClient.delMapStyles(JSON.parseArray((String)styleNames, String.class));
        return rsb;
    }

    @ApiOperation(value="\u83b7\u53d6geoserver\u56fe\u5c42\u53ca\u5bf9\u5e94\u8303\u56f4")
    @GetMapping(value={"/publishedlayers"})
    public PageBean listLayersWithExtent() {
        PageBean rsb = this.geoClient.listLayersWithExtent(Integer.valueOf(1), Integer.valueOf(5));
        return rsb;
    }

    @ApiOperation(value="\u6839\u636e\u540d\u79f0\u83b7\u53d6\u56fe\u5c42\u53ca\u5bf9\u5e94\u8303\u56f4")
    @GetMapping(value={"/layerinfo"})
    public ResultBean getLayerWithExtentByName(@RequestParam(name="layerName") String layerName) {
        ResultBean rsb = this.geoClient.getLayerWithExtentByName(layerName);
        return rsb;
    }

    @ApiOperation(value="\u83b7\u53d6\u7f29\u7565\u56fe")
    @PostMapping(value={"/thumbnail"})
    public ResultBean createThumbnail(@RequestParam(name="layerName") String layerName, @RequestParam(name="styleName") String styleName) {
        ResultBean rsb = this.geoClient.createThumbnail(layerName, styleName);
        return rsb;
    }
}

