/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.common.clients.dw.mdb.SearchClient;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.dg.config.CustomConfig;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/es"})
public class ElasticSearchController {
    @Autowired
    private SearchClient searchClient;
    @Autowired
    private CustomConfig customConfig;

    @ApiOperation(value="\u5206\u9875\u641c\u7d22")
    @GetMapping(value={"/search/all/page"})
    public ResultBean allSearch(@RequestParam(name="instanceId") String instanceId, @RequestParam(name="typeName", defaultValue="FeatureCollection") String typeName, @RequestParam(name="pageIndex", defaultValue="1") int pageIndex, @RequestParam(name="pageSize", defaultValue="120") int pageSize, @RequestParam(name="returnExtent", required=false, defaultValue="false") boolean returnExtent) {
        return this.searchClient.allSearch(instanceId, typeName, pageIndex, pageSize, returnExtent);
    }

    @ApiOperation(value="bool\u5168\u90e8\u67e5\u8be2")
    @GetMapping(value={"/search/boolall"})
    public ResultBean boolQueryByAttr(@RequestParam(name="tableid") String tableid) {
        String instanceId = this.customConfig.getElasticsearch().versioninstanceid;
        String typeName = "sys_table";
        String filterfields = "{\"tableid.keyword\": \"" + tableid + "\"}";
        ResultBean resultBean = this.searchClient.boolQueryAll(instanceId, typeName, filterfields, "and");
        return resultBean;
    }

    @ApiOperation(value="ES\u63d2\u5165\u6570\u636e")
    @PostMapping(value={"/documents"})
    public ResultBean insertDocuments(@RequestParam(name="datamap") String datamap) {
        String instanceId = this.customConfig.getElasticsearch().versioninstanceid;
        String typeName = "sys_table";
        String insertData = JSON.toJSONString((Object)datamap);
        ResultBean resultBean = this.searchClient.insertDocuments(instanceId, typeName, insertData);
        return resultBean;
    }
}

