/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.common.clients.dm.wdm.DMClient;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.common.domain.dm.wdm.entity.DMToolInfo;
import cn.gtmap.gtc.dg.service.AuthorityService;
import cn.gtmap.gtc.resource.clients.resource.DictClient;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import java.util.ArrayList;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/dm"})
public class DmController {
    @Autowired
    private DMClient dmClient;
    @Autowired
    private UserManagerClient userClient;
    @Autowired
    private DictClient dictClient;
    @Autowired
    private AuthorityService authService;

    @PostMapping(value={"/tool/save"})
    public ResultBean saveTool(DMToolInfo dmToolInfo) {
        UserDto user = this.userClient.getCurrentUser();
        dmToolInfo.setCreateBy(user.getUsername());
        return this.dmClient.toolSave(dmToolInfo);
    }

    @GetMapping(value={"/tool/list"})
    public ResultBean toolList() {
        UserDto user = this.userClient.getCurrentUser();
        String userName = user.getUsername();
        ArrayList ids = new ArrayList();
        return this.dmClient.toolList(userName, new HashSet(ids));
    }

    @GetMapping(value={"/tool/find/{id}"})
    public ResultBean getFindById(@PathVariable(name="id") String id) {
        return this.dmClient.findById(id);
    }

    @GetMapping(value={"/tool/delete/{id}"})
    public ResultBean toolDelete(@PathVariable(name="id") String id) throws Exception {
        return this.dmClient.toolDelete(id);
    }

    @PostMapping(value={"/tool/execute"})
    public ResultBean execute(String url, String paramJson) {
        return this.dmClient.execute(url, paramJson, "ArcGIS");
    }
}

