/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.common.clients.dw.mdb.DataStoreClient;
import cn.gtmap.gtc.common.domain.core.PageBean;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.dg.service.DbInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dbinfo"})
public class DbInfoController {
    @Autowired
    private DbInfoService dbinfoService;
    @Autowired
    private DataStoreClient dataStore;

    @PostMapping(value={"/access"})
    public ResultBean getDataAccess(@RequestParam(name="parameters") String parameters) {
        return this.dbinfoService.access(parameters);
    }

    @GetMapping(value={"/list"})
    public PageBean getDbInfo(@RequestParam(value="page") int page, @RequestParam(value="limit") int limit, @RequestParam(value="keywords") String keywords) {
        return this.dataStore.listRegisteredInstance(page, limit, null);
    }

    @PostMapping(value={"/delete"})
    public ResultBean deleteDbInfo(@RequestParam(name="id") String id) {
        return this.dataStore.unRegisterInstance(id);
    }

    @GetMapping(value={"/listdbtype"})
    public ResultBean getDbtype() {
        return this.dataStore.ListDbType();
    }

    @PostMapping(value={"/register"})
    public ResultBean register(@RequestParam(name="dbTypeId") String dbTypeId, @RequestParam(name="instanceName") String instanceName, @RequestParam(name="description") String description, @RequestParam(name="parameters") String parameters) {
        return this.dataStore.registerInstance(dbTypeId, instanceName, description, parameters);
    }

    @PostMapping(value={"/update"})
    public ResultBean update(@RequestParam(name="instanceId") String instanceId, @RequestParam(name="parameters") String parameters) {
        return this.dataStore.updateRegisteredInstance1(instanceId, parameters);
    }
}

