/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.common.clients.dw.mdb.DataStoreClient;
import cn.gtmap.gtc.common.clients.dw.mdb.ImporterClient;
import cn.gtmap.gtc.common.domain.core.Document;
import cn.gtmap.gtc.common.domain.core.PageBean;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.common.domain.dw.mdb.MetaInstance;
import cn.gtmap.gtc.common.domain.dw.mdb.dto.DeletePreview;
import cn.gtmap.gtc.common.domain.dw.mdb.dto.FieldConfig;
import cn.gtmap.gtc.common.domain.dw.mdb.dto.ImporterDeleteTask;
import cn.gtmap.gtc.common.domain.dw.mdb.dto.ImporterSubTask;
import cn.gtmap.gtc.common.domain.dw.mdb.dto.ImporterTask;
import cn.gtmap.gtc.common.domain.dw.mdb.dto.WhereConfig;
import cn.gtmap.gtc.gis.domain.esm.Feature;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/data-insert"})
public class DataInsertController {
    @Autowired
    private ImporterClient importerClient;
    @Autowired
    private DataStoreClient dataStoreClient;
    @Autowired
    private UserManagerClient userClient;

    @GetMapping(value={"/file"})
    public ResultBean getImportFiles(@RequestParam(name="page") int page, @RequestParam(name="limit") int limit, @RequestParam(name="keywords") String keywords) {
        ResultBean result = new ResultBean();
        PageBean info = this.importerClient.getImporterZip(Integer.valueOf(page - 1), Integer.valueOf(limit), keywords);
        result.setData((Object)info.getData());
        result.setMsg(info.getMsg());
        result.setCode(info.getCode());
        return result;
    }

    @GetMapping(value={"/listlayer"})
    ResultBean getListLayer(@RequestParam(value="id") String id) {
        return new ResultBean((Object)this.importerClient.getInstanceTables(id));
    }

    @RequestMapping(value={"/parseFile"})
    @ResponseBody
    public ResultBean execute(HttpServletRequest request) throws IOException {
        MultipartHttpServletRequest mpRequest = (MultipartHttpServletRequest)request;
        MultipartFile file = mpRequest.getFile("file");
        String folderPath = mpRequest.getParameter("folderPath");
        String tableId = mpRequest.getParameter("tableId");
        int size = Integer.valueOf(mpRequest.getParameter("size"));
        String json = "";
        if (file != null && !file.isEmpty()) {
            byte[] buffer = file.getBytes();
            Document doc = Document.getDocByName((String)file.getOriginalFilename());
            doc.setContent(buffer);
            json = JSON.toJSONString((Object)doc);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("file", json);
        map.put("filePath", folderPath);
        map.put("tableId", tableId);
        map.put("size", size);
        return new ResultBean((Object)this.importerClient.parseFile2(map));
    }

    @RequestMapping(value={"/deletePreview"})
    @ResponseBody
    public ResultBean previewDeleteData(HttpServletRequest request) throws IOException {
        MultipartHttpServletRequest mpRequest = (MultipartHttpServletRequest)request;
        MultipartFile file = mpRequest.getFile("file");
        String params = mpRequest.getParameter("params");
        String tableId = mpRequest.getParameter("tableId");
        String deleteAll = mpRequest.getParameter("deleteAll");
        String fileJson = "";
        if (file != null && !file.isEmpty()) {
            byte[] buffer = file.getBytes();
            Document doc = Document.getDocByName((String)file.getOriginalFilename());
            doc.setContent(buffer);
            fileJson = JSON.toJSONString((Object)doc);
        }
        ArrayList<WhereConfig> listWheres = new ArrayList<WhereConfig>();
        JSONArray jsonParams = JSON.parseArray((String)params);
        for (int i = 0; i < jsonParams.size(); ++i) {
            JSONObject object = (JSONObject)jsonParams.get(i);
            WhereConfig config = new WhereConfig();
            config.setAttrName(MapUtils.getString((Map)object, (Object)"fieldName", (String)""));
            config.setPredicate(MapUtils.getString((Map)object, (Object)"predicate", (String)""));
            config.setAttrValue(MapUtils.getString((Map)object, (Object)"fieldValue", (String)""));
            if (i != jsonParams.size() - 1) {
                config.setConjunction("and");
            }
            listWheres.add(config);
        }
        ImporterDeleteTask deleteTask = new ImporterDeleteTask();
        deleteTask.setTableId(tableId);
        if (deleteAll.equals("false")) {
            deleteTask.setWhereConfigs(listWheres);
        } else {
            deleteTask.setWhere("1=1");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("file", fileJson);
        map.put("deleteTask", JSON.toJSONString((Object)deleteTask));
        DeletePreview preview = this.importerClient.getDeletePreview2(map);
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        mapResult.put("preview", preview);
        mapResult.put("task", deleteTask);
        return new ResultBean(mapResult);
    }

    @GetMapping(value={"/previewData"})
    public ResultBean previewData(@RequestParam(name="page") int page, @RequestParam(name="limit") int limit, @RequestParam(name="preview") String preview) {
        DeletePreview deletePreview = (DeletePreview)JSON.parseObject((String)preview, DeletePreview.class);
        deletePreview.setPageIndex(page);
        deletePreview.setPageSize(limit);
        PageBean deleteData = this.importerClient.previewDeleteDate(deletePreview);
        List listFeatures = deleteData.getData();
        ArrayList<Map> listProperties = new ArrayList<Map>();
        for (int i = 0; i < listFeatures.size(); ++i) {
            listProperties.add(((Feature)listFeatures.get(i)).getProperties());
        }
        return new ResultBean(listProperties);
    }

    @PostMapping(value={"/import"})
    public ResultBean ImportTask(@RequestParam(name="params") String params, @RequestParam(name="fields") String fields, @RequestParam(name="tableId") String tableId, @RequestParam(name="folderPath") String folderPath, @RequestParam(name="taskType") String taskType) {
        ImporterTask importerTask = new ImporterTask();
        if (tableId != null) {
            importerTask.setTableId(tableId);
        }
        if (folderPath != null) {
            importerTask.setFolderPath(folderPath);
        }
        if (taskType != null) {
            importerTask.setTaskType(taskType);
        }
        ArrayList<ImporterSubTask> listImporterInfo = new ArrayList<ImporterSubTask>();
        HashMap<String, FieldConfig> mapFields = new HashMap<String, FieldConfig>();
        JSONArray jsonFields = JSON.parseArray((String)fields);
        for (int i = 0; i < jsonFields.size(); ++i) {
            JSONObject object = (JSONObject)jsonFields.get(i);
            FieldConfig config = new FieldConfig();
            config.setMappedFieldName(MapUtils.getString((Map)object, (Object)"contrastName", (String)""));
            config.setDataType(MapUtils.getString((Map)object, (Object)"type", (String)""));
            config.setIndexed(MapUtils.getBoolean((Map)object, (Object)"LAY_CHECKED", (Boolean)false).booleanValue());
            mapFields.put(MapUtils.getString((Map)object, (Object)"name", (String)""), config);
        }
        JSONArray jsonParams = JSON.parseArray((String)params);
        for (int i = 0; i < jsonParams.size(); ++i) {
            JSONObject object = (JSONObject)jsonParams.get(i);
            ImporterSubTask info = new ImporterSubTask();
            info.setInstanceId(MapUtils.getString((Map)object, (Object)"instanceId", (String)""));
            info.setTableName(MapUtils.getString((Map)object, (Object)"tableName", (String)""));
            info.setFields(mapFields);
            listImporterInfo.add(info);
        }
        importerTask.setSubTaskInfos(listImporterInfo);
        UserDto user = this.userClient.getCurrentUser();
        importerTask.setCreateBy(user.getUsername());
        return new ResultBean((Object)this.importerClient.createImportTask(importerTask));
    }

    @PostMapping(value={"/createDeleteTask"})
    public ResultBean createDeleteTask(@RequestParam(value="task") String task) {
        ImporterDeleteTask deleteTask = (ImporterDeleteTask)JSON.parseObject((String)task, ImporterDeleteTask.class);
        return new ResultBean((Object)this.importerClient.createDeleteTask(deleteTask));
    }

    @GetMapping(value={"/taskInfos"})
    public PageBean getImportTask(@RequestParam(name="page") int page, @RequestParam(name="limit") int limit, @RequestParam(name="keywords") String keywords) {
        UserDto user = this.userClient.getCurrentUser();
        PageBean pageTasks = this.importerClient.getTaskStatus(page - 1, limit, keywords, user.getUsername());
        List listTasks = pageTasks.getData();
        for (ImporterTask task : listTasks) {
            List listSubTasks = task.getSubTaskInfos();
            for (ImporterSubTask subTask : listSubTasks) {
                String instanceId = subTask.getInstanceId();
                MetaInstance metaInstance = (MetaInstance)this.dataStoreClient.queryInstanceById(instanceId).getData();
                subTask.setInstanceId(metaInstance.getInstanceName());
            }
        }
        return pageTasks;
    }

    @GetMapping(value={"/deleteTasks"})
    public PageBean getDeleteTask(@RequestParam(name="page") int page, @RequestParam(name="limit") int limit, @RequestParam(name="keywords") String keywords) {
        UserDto user = this.userClient.getCurrentUser();
        return this.importerClient.queryDeleteTask(page, limit, keywords, user.getUsername());
    }
}

