/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.common.clients.dm.wdm.DataMiningModelClient;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.common.domain.dm.wdm.entity.DMModelInfo;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/dmm"})
public class DMModelRestController {
    @Autowired
    private DataMiningModelClient dataMiningModelClient;

    @PostMapping(value={"/model"})
    @ApiOperation(value="\u589e\u52a0\u6216\u7f16\u8f91\u6a21\u578b")
    public ResultBean save(@RequestBody DMModelInfo dmModelInfo) {
        if (dmModelInfo.getId().equals("")) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dmModelInfo.setCreateTime(df.format(new Date()));
        }
        return this.dataMiningModelClient.save(dmModelInfo);
    }

    @DeleteMapping(value={"/model/{id}"})
    @ApiOperation(value="\u5220\u9664\u6a21\u578b")
    public ResultBean delete(@PathVariable(name="id") String id) throws Exception {
        return this.dataMiningModelClient.delete(id);
    }

    @GetMapping(value={"/model"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6a21\u578b")
    public ResultBean list() {
        return this.dataMiningModelClient.list();
    }

    @GetMapping(value={"/model/{id}"})
    @ApiOperation(value="\u6839\u636eId\u67e5\u627e\u6a21\u578b")
    public ResultBean findById(@PathVariable(name="id") String id) {
        return this.dataMiningModelClient.findById(id);
    }

    @GetMapping(value={"/model/page"})
    @ApiOperation(value="\u6309\u9875\u83b7\u53d6\u6a21\u578b")
    public Map listByPage(@RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="size", defaultValue="10") int size, @RequestParam(value="keywords", defaultValue="") String keywords) {
        return this.dataMiningModelClient.listByPage(page, size, keywords);
    }

    @GetMapping(value={"/modeltype/page"})
    @ApiOperation(value="\u6309\u9875\u53ca\u6a21\u578b\u7c7b\u578b\u83b7\u53d6\u6a21\u578b")
    public Map listByModeltype(@RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="size", defaultValue="10") int size, @RequestParam(value="keywords", defaultValue="") String keywords, @RequestParam(value="modeltype") String modeltype) {
        return this.dataMiningModelClient.listByModeltype(page, size, keywords, modeltype);
    }
}

