/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web.rest;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.common.clients.dc.dh.DataHandleClient;
import cn.gtmap.gtc.common.domain.core.PageBean;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.dg.service.AuthorityService;
import cn.gtmap.gtc.sso.domain.dto.DataAuthorityDto;
import cn.gtmap.gtc.sso.domain.dto.DataResourceDto;
import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/authority"})
public class AuthorityController {
    @Autowired
    private AuthorityService authSerive;
    @Autowired
    private UserManagerClient userClient;
    @Autowired
    DataHandleClient dataHandleClient;

    @PostMapping(value={"/findSource"})
    public DataResourceDto findDataSource(@RequestParam(name="moduleCode") String moduleCode, @RequestParam(name="moduleName") String moduleName, @RequestParam(name="code") String code) {
        return this.authSerive.findDataSource(moduleCode, moduleName, code);
    }

    @GetMapping(value={"/currentUser"})
    public ResultBean getCurrentUser() {
        return new ResultBean((Object)this.authSerive.getCurrentUser());
    }

    @PostMapping(value={"/save"})
    public List<DataAuthorityDto> saveDataAuthority(@RequestParam(name="users", required=false, defaultValue="self") String users, @RequestParam(name="moduleCode") String moduleCode, @RequestParam(name="moduleName") String moduleName, @RequestParam(name="code") String code, @RequestParam(name="authority", required=false, defaultValue="") String authorityCode) {
        return this.authSerive.saveDataAuthority(users, moduleCode, moduleName, code, authorityCode);
    }

    @GetMapping(value={"/users"})
    public List<Map> getAllUsers() {
        return this.authSerive.getAllUsers();
    }

    @GetMapping(value={"/userbyPage"})
    public PageBean getUsersByPage(@RequestParam(name="page") int page, @RequestParam(name="size") int size, @RequestParam(name="searchName") String searchName, @RequestParam(name="searchAlisa") String searchAlisa) {
        return this.authSerive.getUsersByPage(page - 1, size, searchName, searchAlisa);
    }

    @GetMapping(value={"/operations"})
    public List<Map> getAllOperation() {
        return this.authSerive.getAllOperation();
    }

    @PostMapping(value={"/query-authority"})
    public String queryUserDataAuthority(@RequestParam(name="username") String userName, @RequestParam(name="moduleCode") String moduleCode, @RequestParam(name="code") String code) {
        return this.authSerive.queryUserDataAuthority(userName, moduleCode, code);
    }

    @PostMapping(value={"/userModuleAuthority"})
    public ResultBean queryUserModuleAuthority(@RequestParam(value="userName") String userName, @RequestParam(value="moduleCode") String moduleCode) {
        return new ResultBean((Object)this.authSerive.queryUserModuleAuthority(userName, moduleCode));
    }

    @GetMapping(value={"/modules"})
    public ResultBean getSubsModules(@RequestParam(value="clientId") String clientId) {
        return this.authSerive.getSubsModules(clientId);
    }

    @GetMapping(value={"/exist"})
    public boolean exist(@RequestParam(name="username") String userName) {
        return this.authSerive.exist(userName);
    }

    @GetMapping(value={"/orgs"})
    public ResultBean buildOrgs() {
        return this.authSerive.buildOrgTree();
    }

    @PostMapping(value={"/getOrg"})
    public ResultBean getOrgByIds(@RequestParam(name="ids") String jsonIds) {
        List ids = (List)JSON.parse((String)jsonIds);
        return this.authSerive.getOrgByIds(ids);
    }

    @PostMapping(value={"/adduser"})
    public ResultBean addUser(UserDto user) {
        return this.authSerive.addUser(user);
    }

    @PostMapping(value={"/edituser"})
    public ResultBean editUser(UserDto user) {
        UserDto beforeUser = this.userClient.getUserDetailByUsername(user.getUsername());
        user.setRoleRecordList(beforeUser.getRoleRecordList());
        user.setEnabled(beforeUser.getEnabled());
        user.setLocked(beforeUser.getLocked());
        return this.authSerive.editUser(user);
    }

    @PostMapping(value={"/enableUser"})
    public ResultBean enableUser(@RequestParam(name="id") String id, @RequestParam(name="enable") int enable) {
        return this.authSerive.enableUser(id, enable);
    }

    @PostMapping(value={"/delete"})
    public ResultBean deleteUser(@RequestParam(name="id") String id) {
        return this.authSerive.deleteUser(id);
    }

    @PostMapping(value={"/editorg"})
    public ResultBean editOrg(OrganizationDto org) {
        return this.authSerive.editOrg(org);
    }

    @PostMapping(value={"/addorg"})
    public ResultBean addOrg(OrganizationDto org) {
        return this.authSerive.addOrg(org);
    }

    @PostMapping(value={"/deleteorg"})
    public boolean deleteOrg(@RequestParam(name="id") String id) {
        return this.authSerive.deleteOrg(id);
    }

    @PostMapping(value={"/saveModuleAuthority"})
    public ResultBean saveUserModuleAuthority(@RequestParam(value="username") String userName, @RequestParam(value="moduleId") String moduleId, @RequestParam(value="Operations") String jsonOperations) {
        return new ResultBean((Object)this.authSerive.saveModuleAuthority(userName, moduleId, jsonOperations));
    }

    @PostMapping(value={"/test"})
    public ResultBean test(@RequestParam(value="tableId") String tableId, @RequestParam(value="fieldName") String fieldName) {
        this.dataHandleClient.createAddGeometryTask(tableId, fieldName);
        return null;
    }
}

