/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.common.clients.dw.mdb.DataStoreClient;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.dg.config.CustomConfig;
import cn.gtmap.gtc.dg.dao.CollectionRepo;
import cn.gtmap.gtc.dg.dao.FavRepo;
import cn.gtmap.gtc.dg.dao.ThemeRepo;
import cn.gtmap.gtc.dg.entity.Favorites;
import cn.gtmap.gtc.dg.entity.MapCollections;
import cn.gtmap.gtc.dg.entity.ThemeInfo;
import cn.gtmap.gtc.dg.utils.SessionMap;
import cn.gtmap.gtc.dg.web.BaseController;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.servlet4preview.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/map"})
public class MapController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String PRIVATE = "private";
    private final String PUBLIC = "public";
    static SessionMap sessionMap = new SessionMap();
    @Autowired
    private Environment environment;
    @Autowired
    private CustomConfig customConfig;
    @Autowired
    private UserManagerClient userManagerClient;
    @Autowired
    FavRepo favRepo;
    @Autowired
    ThemeRepo themeRepo;
    @Autowired
    CollectionRepo collectionRepo;
    @Autowired
    private DataStoreClient dataStoreCore;

    @RequestMapping(value={"/index"})
    public String index(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException {
        String data = "";
        String localAddr = "localhost";
        String localAddr1 = "127.0.0.1";
        String ip = request.getLocalAddr();
        UserDto user = null;
        try {
            user = this.userManagerClient.getCurrentUser();
            model.addAttribute("username", (Object)this.userManagerClient.getCurrentUser().getUsername());
            model.addAttribute("userId", (Object)this.userManagerClient.getCurrentUser().getId());
        }
        catch (Exception er) {
            System.out.println("\u7528\u6237\u672a\u767b\u5f55");
        }
        ClassPathResource cpr = ip.equals(localAddr) || ip.equals(localAddr1) || ip.equals("192.168.2.124") ? new ClassPathResource("static/mock/tpl_test.json") : new ClassPathResource("static/mock/tpl.json");
        switch (this.appVersion) {
            case "ningxia": {
                cpr = new ClassPathResource("static/mock/tpl_ningxia.json");
                break;
            }
            case "yantai": {
                cpr = new ClassPathResource("static/mock/tpl_yantai.json");
                break;
            }
        }
        try {
            byte[] bdata = FileCopyUtils.copyToByteArray((InputStream)cpr.getInputStream());
            data = new String(bdata, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.logger.warn("IOException", (Throwable)e);
        }
        request.setAttribute("graphEnable", (Object)this.customConfig.getJanusgraph().getEnable());
        request.setAttribute("url", (Object)this.customConfig.getJanusgraph().getBaseUrl());
        request.setAttribute("smartSearchSearchInView", (Object)this.customConfig.getSmartSearch().getSearchInView());
        request.setAttribute("smartSearchSearchOnMove", (Object)this.customConfig.getSmartSearch().getSearchOnMove());
        request.setAttribute("smartSearchClearOnPause", (Object)this.customConfig.getSmartSearch().getClearOnPause());
        request.setAttribute("tpl", (Object)data);
        request.setAttribute("menuCode", (Object)"clf");
        response.setHeader("x-frame-options", "ALLOW-FROM");
        return "globalx/index";
    }

    @RequestMapping(value={"/app/{app}"})
    public String app(HttpServletRequest request, HttpServletResponse response, Model model, @PathVariable(name="app") String app) throws IOException {
        String data = "";
        UserDto user = null;
        try {
            user = this.userManagerClient.getCurrentUser();
            model.addAttribute("username", (Object)this.userManagerClient.getCurrentUser().getUsername());
            model.addAttribute("userId", (Object)this.userManagerClient.getCurrentUser().getId());
        }
        catch (Exception er) {
            System.out.println("\u7528\u6237\u672a\u767b\u5f55");
        }
        ClassPathResource cpr = new ClassPathResource("static/mock/tpl_" + app + ".json");
        try {
            byte[] bdata = FileCopyUtils.copyToByteArray((InputStream)cpr.getInputStream());
            data = new String(bdata, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.logger.warn("IOException", (Throwable)e);
        }
        switch (this.appVersion) {
            case "dmdz": {
                request.setAttribute("menuCode", (Object)"zsfw");
                break;
            }
            default: {
                request.setAttribute("menuCode", (Object)"clf");
            }
        }
        request.setAttribute("graphEnable", (Object)this.customConfig.getJanusgraph().getEnable());
        request.setAttribute("url", (Object)this.customConfig.getJanusgraph().getBaseUrl());
        request.setAttribute("smartSearchSearchInView", (Object)this.customConfig.getSmartSearch().getSearchInView());
        request.setAttribute("smartSearchSearchOnMove", (Object)this.customConfig.getSmartSearch().getSearchOnMove());
        request.setAttribute("smartSearchClearOnPause", (Object)this.customConfig.getSmartSearch().getClearOnPause());
        request.setAttribute("tpl", (Object)data);
        response.setHeader("x-frame-options", "ALLOW-FROM");
        return "globalx/index";
    }

    public static void readFileACCESS(File mdbFile) {
        Properties prop = new Properties();
        prop.put("charSet", "gb2312");
        prop.put("user", "");
        prop.put("password", "");
        Statement stmt = null;
        ResultSet rs = null;
        String tableName = null;
        try {
            Class.forName("net.ucanaccess.jdbc.UcanaccessDriver");
            String strConnectionString = "jdbc\uff1aucanaccess\uff1a//" + mdbFile.getAbsolutePath();
            Connection conn = DriverManager.getConnection(strConnectionString);
            ResultSet tables = conn.getMetaData().getTables(mdbFile.getAbsolutePath(), null, null, new String[]{"TABLE"});
            if (!tables.next()) {
                return;
            }
            tableName = tables.getString(3);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select * from " + tableName);
            ResultSetMetaData data = rs.getMetaData();
            while (rs.next()) {
                for (int i = 1; i <= data.getColumnCount(); ++i) {
                    System.out.print(rs.getString(i) + "    ");
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/geoserver/style"})
    public String getNewTb(Model model) {
        return "dw/mdb/mapStyleManage";
    }

    @RequestMapping(value={"/easy_map"})
    public String easyMap(@RequestParam String map_type, @RequestParam(required=false) String geojson, Model model) {
        model.addAttribute("layerUrl", (Object)this.environment.getProperty("easy-map." + map_type + ".base_layer.url"));
        model.addAttribute("layerType", (Object)this.environment.getProperty("easy-map." + map_type + ".base_layer.type"));
        model.addAttribute("layerUrl1", (Object)this.environment.getProperty("easy-map." + map_type + ".base_layer1.url"));
        model.addAttribute("layerType1", (Object)this.environment.getProperty("easy-map." + map_type + ".base_layer1.type"));
        model.addAttribute("zoom", (Object)this.environment.getProperty("easy-map." + map_type + ".zoom"));
        return "globalx/easy_map";
    }

    @GetMapping(value={"/favs/set"})
    @ResponseBody
    public ResultBean setFavs(@RequestParam String content) {
        String userId = this.userManagerClient.getCurrentUser().getId();
        Favorites fav = this.favRepo.getFirstByUserId(userId);
        if (fav == null) {
            fav = new Favorites();
            fav.setUserId(userId);
        }
        fav.setContent(content);
        this.favRepo.save((Object)fav);
        return new ResultBean((Object)fav);
    }

    @GetMapping(value={"/favs/get"})
    @ResponseBody
    public ResultBean getFavs() {
        String userId = this.userManagerClient.getCurrentUser().getId();
        return new ResultBean((Object)this.favRepo.getFirstByUserId(userId));
    }

    @GetMapping(value={"/theme/set"})
    @ResponseBody
    public ResultBean setTheme(@RequestParam(name="content") String content) {
        ThemeInfo themeInfo = (ThemeInfo)JSON.parseObject((String)content, ThemeInfo.class);
        String userId = this.userManagerClient.getCurrentUser().getId();
        if (StringUtils.isEmpty((Object)themeInfo.getUserId())) {
            themeInfo.setUserId(userId);
        }
        this.themeRepo.save((Object)themeInfo);
        return new ResultBean((Object)themeInfo);
    }

    @GetMapping(value={"/theme/delete"})
    @ResponseBody
    public ResultBean deletTheme(@RequestParam(name="id") String id) {
        this.themeRepo.delete((Serializable)((Object)id));
        return new ResultBean((Object)true);
    }

    @GetMapping(value={"/theme/share"})
    @ResponseBody
    public ResultBean shareTheme(@RequestParam(name="id") String id) {
        ThemeInfo themeInfo = (ThemeInfo)this.themeRepo.findOne((Serializable)((Object)id));
        ThemeInfo share = this.themeRepo.findFirstByOriId(id);
        if (share != null) {
            return new ResultBean((Throwable)new Exception("theme has aready shared"));
        }
        ThemeInfo newThemeInfo = new ThemeInfo();
        newThemeInfo.setOriId(id);
        newThemeInfo.setOwnState("public");
        newThemeInfo.setRenderType(themeInfo.getRenderType());
        newThemeInfo.setMid(themeInfo.getMid());
        newThemeInfo.setName(themeInfo.getName());
        newThemeInfo.setUserId(themeInfo.getUserId());
        newThemeInfo.setGeoId(themeInfo.getGeoId());
        newThemeInfo.setUrl(themeInfo.getUrl());
        newThemeInfo.setParams(themeInfo.getParams());
        newThemeInfo.setLabel(themeInfo.getLabel());
        newThemeInfo.setImg(themeInfo.getImg());
        this.themeRepo.save((Object)newThemeInfo);
        return new ResultBean((Object)true);
    }

    @GetMapping(value={"/theme/share/delete"})
    @ResponseBody
    public ResultBean cancelShare(@RequestParam(name="id") String id) {
        try {
            ThemeInfo share = this.themeRepo.findFirstByOriId(id);
            if (share != null) {
                this.themeRepo.delete((Object)share);
            }
            return new ResultBean((Object)true);
        }
        catch (Exception er) {
            return new ResultBean((Throwable)er);
        }
    }

    @GetMapping(value={"/theme/get"})
    @ResponseBody
    public ResultBean getTheme(@RequestParam(defaultValue="public") String ownState) {
        String userId = this.userManagerClient.getCurrentUser().getId();
        List themes = ownState.equals("public") ? this.themeRepo.findByOwnState("public") : this.themeRepo.findByUserIdAndOwnState(userId, "private");
        for (ThemeInfo theme : themes) {
            if (theme.getUserId().equals(userId)) {
                theme.setEditable(true);
            }
            if (this.themeRepo.findFirstByOriId(theme.getId()) == null) continue;
            theme.setShared(true);
        }
        return new ResultBean((Object)themes);
    }

    @GetMapping(value={"/theme/test"})
    @ResponseBody
    public ResultBean addThemeTest() {
        String content = "[{\"id\":\"addNew\",\"url\":\"\",\"name\":\"\u65b0\u589e\u53ef\u89c6\u5316\",\"iconCls\":\"icon-f-add-file\",\"img\":\"points\",\"display\":true,\"check\":false,\"edit\":false},{\"id\":\"scatterMap\",\"url\":\"\",\"name\":\"\u6563\u70b9\u56fe:\u6c14\u8c61\",\"iconCls\":\"icon-f-pointsMap\",\"img\":\"points\",\"display\":true,\"check\":false,\"edit\":false},{\"id\":\"heatMap1\",\"url\":\"\",\"name\":\" \u70ed\u529b\u56fe:\u5357\u4eac\u5e02\",\"iconCls\":\"icon-f-gl-heatMap\",\"img\":\"heat\",\"display\":true,\"check\":false,\"edit\":false},{\"id\":\"honeycomb1\",\"url\":\"\",\"name\":\"\u8702\u7a9d\u56fe:\u5357\u4eac\u5e02\",\"iconCls\":\"icon-f-gl-heatMap\",\"img\":\"points\",\"display\":true,\"check\":false},{\"id\":\"flightMap\",\"url\":\"\",\"name\":\"\u8fc1\u5f99\u56fe:\u4e16\u754c\u4eba\u53e3\u6d41\u52a8\",\"iconCls\":\"icon-f-people\",\"img\":\"flow\",\"display\":true,\"check\":false,\"edit\":false},{\"id\":\"flowMap\",\"url\":\"\",\"name\":\"\u6d41\u5411\u56fe:\u5357\u4eac\u5e02\",\"img\":\"flow\",\"iconCls\":\"icon-f-linesMap\",\"display\":true,\"check\":false,\"edit\":false},{\"id\":\"flow2Map\",\"url\":\"\",\"name\":\"\u6d41\u5411\u56fe:\u6d41\u5411\u6548\u679c2\",\"iconCls\":\"icon-f-linesMap\",\"img\":\"flow\",\"display\":true,\"check\":false,\"edit\":false},{\"id\":\"trafficMap\",\"url\":\"\",\"name\":\"\u4e2d\u5fc3\u70b9\u6269\u6563\u6548\u679c\",\"iconCls\":\"icon-f-linesMap\",\"img\":\"flow\",\"display\":true,\"check\":false,\"edit\":false},{\"id\":\"transMap\",\"url\":\"\",\"name\":\"\u4ea4\u901a\u9053\u8def\u62e5\u5835\u56fe\",\"iconCls\":\"icon-f-gl-heatMap\",\"img\":\"heat\",\"display\":true,\"check\":false,\"edit\":false},{\"id\":\"pointsMapV\",\"url\":\"\",\"name\":\"\u6e32\u67d3\u70ed\u529b\u56fe\u6548\u679c\",\"iconCls\":\"icon-f-dataviews\",\"img\":\"heat\",\"display\":true,\"check\":false,\"edit\":false},{\"id\":\"heatMap\",\"url\":\"\",\"name\":\"s3m\u53e0\u52a0\u70ed\u529b\u56fe\",\"iconCls\":\"icon-f-gl-heatMap\",\"img\":\"heat\",\"display\":true,\"check\":false,\"edit\":false},{\"id\":\"mapVHoneycomb\",\"url\":\"\",\"name\":\"\u6e32\u67d3\u8702\u7a9d\u56fe\",\"iconCls\":\"icon-f-dataviews\",\"img\":\"points\",\"display\":true,\"check\":false,\"edit\":false},{\"id\":\"mapVLines\",\"url\":\"\",\"name\":\"\u6e32\u67d3\u7ebf\u6548\u679c\",\"iconCls\":\"icon-f-dataviews\",\"img\":\"lines\",\"display\":true,\"check\":false,\"edit\":false}]";
        JSONArray arr = JSON.parseArray((String)content);
        ArrayList<ThemeInfo> ThemeInfos = new ArrayList<ThemeInfo>();
        String userId = this.userManagerClient.getCurrentUser().getId();
        for (Object obj : arr) {
            Map target = (Map)obj;
            ThemeInfo theme = new ThemeInfo();
            theme.setUrl((String)target.get("url"));
            theme.setImg((String)target.get("img"));
            theme.setMid((String)target.get("id"));
            theme.setName((String)target.get("name"));
            theme.setOwnState("private");
            theme.setRenderType("view");
            theme.setUserId(userId);
            ThemeInfos.add(theme);
        }
        this.themeRepo.save(ThemeInfos);
        return new ResultBean();
    }

    @GetMapping(value={"/record/insert"})
    @ResponseBody
    public ResultBean insertRecord(@RequestParam(name="geojson") String geojson, @RequestParam(name="tableName") String tableName) {
        ResultBean result = this.dataStoreCore.createTableByFeatureCollection(this.instanceId, tableName, null, geojson);
        return result;
    }

    @GetMapping(value={"/col/save"})
    @ResponseBody
    public ResultBean insertCol(MapCollections mapCollection) {
        this.collectionRepo.save((Object)mapCollection);
        return new ResultBean((Object)true);
    }

    @GetMapping(value={"/col/delete"})
    @ResponseBody
    public ResultBean deleteCol(String id) {
        this.collectionRepo.delete((Serializable)((Object)id));
        return new ResultBean((Object)true);
    }

    @GetMapping(value={"/col/get"})
    @ResponseBody
    public ResultBean getCols() {
        return new ResultBean((Object)this.collectionRepo.findAll());
    }

    @GetMapping(value={"/session"})
    @ResponseBody
    public ResultBean getOrSetSession(String key, String value) {
        if (StringUtils.isEmpty((Object)value)) {
            return new ResultBean(SessionMap.get((String)key));
        }
        SessionMap.put((String)key, (Object)value);
        return new ResultBean(SessionMap.get((String)key));
    }
}

