/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web;

import cn.gtmap.gtc.dg.web.BaseController;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping
public class IndexController
extends BaseController {
    @Value(value="${app.oauth}")
    private String logout;

    @GetMapping(value={"/", "/index"})
    public String index() {
        return "index";
    }

    @RequestMapping(value={"/userLogout"})
    public String userlogout(HttpServletRequest request, HttpServletResponse response) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            new SecurityContextLogoutHandler().logout(request, response, authentication);
        }
        SecurityContextHolder.getContext().setAuthentication(null);
        String url = "redirect:".concat(this.getAccountLogoutPath().concat("?redirect_uri=" + this.getAbsContextPath(request).concat("/index")));
        return url;
    }

    private String getAccountLogoutPath() {
        return this.logout.concat("/logout");
    }

    public String getAbsContextPath(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
    }
}

