/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.common.clients.dm.wdm.DMClient;
import cn.gtmap.gtc.common.clients.dw.mdb.ApplyDataClient;
import cn.gtmap.gtc.common.clients.dw.mdb.DataStoreClient;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.dg.service.AuthorityService;
import cn.gtmap.gtc.dg.web.BaseController;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/dw"})
public class DwController
extends BaseController {
    @Autowired
    private UserManagerClient userClient;
    @Autowired
    private AuthorityService authService;
    @Autowired
    DMClient dmClient;
    @Autowired
    DataStoreClient dataStoreClient;
    @Autowired
    private ApplyDataClient applyDataClient;

    @RequestMapping(value={"/db_info"})
    public String getDbInfo(Model model) {
        return "dw/mdb/dbInfomanage";
    }

    @RequestMapping(value={"/service_info"})
    public String getServiceInfo(Model model) {
        return "dw/mdb/servicemanage";
    }

    @RequestMapping(value={"/metadata"}, method={RequestMethod.POST, RequestMethod.GET})
    public String showDetail(@RequestParam(value="id") String id, @RequestParam(value="ownState") String ownState, Model model, @RequestParam(name="breadType", defaultValue="metadata") String breadType, @RequestParam(name="breadTitle", defaultValue="\u67e5\u770b\u5143\u6570\u636e") String breadTitle) {
        UserDto user = this.userClient.getCurrentUser();
        String userName = user.getUsername();
        HashMap metaMap = new HashMap();
        model.addAttribute("username", (Object)userName);
        model.addAttribute("id", (Object)id);
        model.addAttribute("ownState", (Object)ownState);
        model.addAttribute("breadType", (Object)breadType);
        model.addAttribute("breadTitle", (Object)breadTitle);
        return "dw/mdb/metadatamanage";
    }

    @RequestMapping(value={"/tables_info"})
    public String getTablesInfo(Model model) {
        UserDto user = this.userClient.getCurrentUser();
        String userName = user.getUsername();
        model.addAttribute("username", (Object)userName);
        return "dw/mdb/tablesmanage";
    }

    @RequestMapping(value={"/data_mining"})
    public String getDataMining(Model model) {
        ResultBean result = this.dmClient.toolList2();
        HashMap<String, Object> dt = new HashMap<String, Object>();
        dt.put("data", result.getData());
        model.addAttribute("tools", dt);
        return "dm/wdm/dataMining";
    }

    @RequestMapping(value={"/data_mining/result"})
    public String getDataMiningResult(Model model) {
        return "dm/wdm/dataMining-result";
    }

    @RequestMapping(value={"/newTb"})
    public String getNewTb(Model model) {
        UserDto user = this.userClient.getCurrentUser();
        String userName = user.getUsername();
        model.addAttribute("username", (Object)userName);
        return "dw/mdb/newTable";
    }

    @RequestMapping(value={"/user"})
    public String userManage(Model model) {
        model.addAttribute("menuCode", (Object)"\u6211\u7684\u5e73\u53f0");
        return "dw/mdb/usermanage";
    }

    @RequestMapping(value={"/version"})
    public String getVersion(Model model, String tableid) {
        model.addAttribute("tableid", (Object)tableid);
        return "dw/mdb/versionManage";
    }

    @RequestMapping(value={"/personal"})
    public String personalManage(Model model) {
        model.addAttribute("menuCode", (Object)"pt");
        return "dw/mdb/personmanage";
    }

    @RequestMapping(value={"/edit-personal"})
    public String editPersonal(Model model) {
        model.addAttribute("menuCode", (Object)"\u6211\u7684\u5e73\u53f0");
        model.addAttribute("editUser", (Object)"\u6211\u7684\u4fe1\u606f");
        return "dw/mdb/personmanage";
    }

    @RequestMapping(value={"/form-download"})
    public String applyDownload(@RequestParam(name="ywbsId") String id, Model model, @RequestParam(name="state", required=false, defaultValue="edit") String state) {
        List listInfos = (List)this.applyDataClient.queryDownload(id).getData();
        model.addAttribute("processInsId", (Object)id);
        if (listInfos.size() > 0) {
            Map map = (Map)listInfos.get(0);
            model.addAttribute("userName", map.get("userName"));
            model.addAttribute("time", map.get("time"));
            model.addAttribute("reason", map.get("reason"));
            model.addAttribute("state", (Object)state);
            String layerName = "";
            for (Map info : listInfos) {
                layerName = layerName + info.get("layerName") + ";";
            }
            layerName = layerName.substring(0, layerName.length() - 1);
            model.addAttribute("layerName", (Object)layerName);
        }
        return "dw/mdb/ApplyDownload";
    }

    @RequestMapping(value={"/data-insert"})
    public String insertData2Database(Model model) {
        model.addAttribute("menuCode", (Object)"\u6211\u7684\u5e73\u53f0");
        return "dw/mdb/dataInsertDatabase";
    }

    @RequestMapping(value={"/batch-delete"})
    public String batchDelete(Model model) {
        model.addAttribute("menuCode", (Object)"\u6211\u7684\u5e73\u53f0");
        return "dw/mdb/batchdelete";
    }

    @RequestMapping(value={"/data-tasklist"})
    public String insertTaskList(Model model) {
        model.addAttribute("menuCode", (Object)"\u6211\u7684\u5e73\u53f0");
        return "dw/mdb/dataInsertTaskList";
    }

    @RequestMapping(value={"/db_stosub"})
    public String getStoSub(Model model) {
        return "dw/mdb/db_stosub";
    }

    @RequestMapping(value={"/storage_result"})
    public String StoSubResult(Model model) {
        return "dw/mdb/storage_result";
    }

    @RequestMapping(value={"/service_man"})
    public String getServiceDetail(Model model) {
        return "dw/mdb/service_man";
    }

    @RequestMapping(value={"/db_sto"})
    public String getDbStor(Model model) {
        return "dw/mdb/db_sto";
    }

    @RequestMapping(value={"/db_con"})
    public String getDbCon(Model model) {
        return "dw/mdb/db_con";
    }

    @RequestMapping(value={"/db_mod"})
    public String getDbMod(Model model) {
        return "dw/mdb/db_mod";
    }

    @RequestMapping(value={"/data_man"})
    public String getDataMan(Model model) {
        return "dw/mdb/data_man";
    }

    @RequestMapping(value={"/data_ser"})
    public String getDataSer(Model model) {
        return "dw/mdb/data_ser";
    }

    @RequestMapping(value={"/model_edi"})
    public String getModelEdit(Model model) {
        return "dw/mdb/model_edi";
    }

    @RequestMapping(value={"/style_man"})
    public String getStyleMan(Model model) {
        return "dw/mdb/style_man";
    }

    @RequestMapping(value={"/data_ana"})
    public String getDataAna(Model model) {
        return "dw/mdb/data_ana";
    }

    @RequestMapping(value={"/analyze_ope"})
    public String getAnalyzeOpe(Model model) {
        return "dw/mdb/analyze_ope";
    }

    @RequestMapping(value={"/analyze_rec"})
    public String getAnalyzeRec(Model model) {
        return "dw/mdb/analyze_rec";
    }

    @RequestMapping(value={"/model_man"})
    public String getModelMan(Model model) {
        return "dw/mdb/model_man";
    }
}

