/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web;

import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.dg.entity.Article;
import cn.gtmap.gtc.dg.entity.ArticleMenu;
import cn.gtmap.gtc.dg.service.Impl.DocService;
import cn.gtmap.gtc.dg.web.BaseController;
import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.MultipartDto;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/api"})
public class DocController
extends BaseController {
    @Autowired
    private DocService docService;
    @Autowired
    private StorageClient storageClient;

    @RequestMapping(value={"/doc"})
    public String doc(Model model, String tplName) {
        ArticleMenu menu = this.docService.getMenu(tplName);
        JSONArray nodes = JSON.parseArray((String)menu.content);
        if (nodes.size() > 0) {
            model.addAttribute("kfmenus", nodes.get(0));
        } else {
            model.addAttribute("kfmenus", new ArrayList());
        }
        model.addAttribute("menuCode", (Object)"kfzx");
        return "api/doc";
    }

    @RequestMapping(value={"/doc/edit"})
    public String docEditor(Model model, String tplName) {
        model.addAttribute("tplName", (Object)tplName);
        return "api/doc_editor";
    }

    @RequestMapping(value={"/article/get"})
    @ResponseBody
    public ResultBean getHtml(String menuId) {
        Article article = this.docService.findArticleByMenuId(menuId);
        if (article == null) {
            article = new Article();
            article.setCatalogId(menuId);
        }
        return new ResultBean((Object)article);
    }

    @RequestMapping(value={"/article/set"})
    @ResponseBody
    public ResultBean setHtml(@RequestParam(required=false, defaultValue="") String menuId, String html) {
        Article article = this.docService.findArticleByMenuId(menuId);
        if (article == null) {
            article = new Article();
            article.setContent(html);
            article.setCatalogId(menuId);
        }
        article.setContent(html);
        this.docService.saveArticle(article);
        return new ResultBean((Object)article);
    }

    @RequestMapping(value={"/article/delete"})
    @ResponseBody
    public ResultBean deleteHtml(String id) throws Exception {
        return new ResultBean((Object)this.docService.deleteArticle(id));
    }

    @PostMapping(value={"/upload"})
    @ResponseBody
    public String upload(@RequestParam(name="fileName") MultipartFile file) throws IOException {
        MultipartDto multipartDto = new MultipartDto();
        multipartDto.setName(file.getName());
        multipartDto.setContentType(file.getContentType());
        multipartDto.setData(file.getBytes());
        multipartDto.setOriginalFilename(file.getOriginalFilename());
        multipartDto.setSize(file.getSize());
        StorageDto storageDto = this.storageClient.multipartUpload(multipartDto);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("error", 0);
        result.put("url", storageDto.getDownUrl());
        return JSON.toJSONString(result);
    }

    @RequestMapping(value={"/menu/set"})
    @ResponseBody
    public ResultBean saveMenu(ArticleMenu menu) {
        ArticleMenu tmpMenu = this.docService.saveMenu(menu);
        return new ResultBean((Object)tmpMenu);
    }

    @RequestMapping(value={"/menu/get"})
    @ResponseBody
    public ResultBean getMenu(String tplName) {
        ArticleMenu tmpMenu = this.docService.getMenu(tplName);
        if (tmpMenu == null) {
            tmpMenu = new ArticleMenu();
            tmpMenu.setTplName(tplName);
            HashMap<String, Object> menu = new HashMap<String, Object>();
            menu.put("level", "0");
            menu.put("id", tplName);
            menu.put("name", tplName);
            menu.put("children", new ArrayList());
            tmpMenu.setContent(JSON.toJSONString(menu));
        }
        return new ResultBean((Object)tmpMenu);
    }

    @RequestMapping(value={"/menu/delete"})
    @ResponseBody
    public ResultBean deleteMenu(String tplName) {
        ArticleMenu tmpMenu = this.docService.getMenu(tplName);
        if (tmpMenu == null) {
            tmpMenu = new ArticleMenu();
            tmpMenu.setTplName(tplName);
            HashMap<String, Object> menu = new HashMap<String, Object>();
            menu.put("level", "0");
            menu.put("id", tplName);
            menu.put("name", tplName);
            menu.put("children", new ArrayList());
        }
        return new ResultBean((Object)tmpMenu);
    }

    @RequestMapping(value={"/model"})
    public String modelBuilder(Model model) {
        model.addAttribute("menuCode", (Object)"kfzx");
        model.addAttribute("modelUrl", (Object)this.modelBuilderUrl);
        return "api/modelBuilder";
    }
}

