/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web;

import cn.gtmap.gtc.common.clients.dc.dgk.JobClient;
import cn.gtmap.gtc.common.clients.dw.mdb.V1BusinessClient;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.dg.config.CustomConfig;
import cn.gtmap.gtc.dg.web.BaseController;
import cn.gtmap.gtc.starter.gscas.annotation.ModuleAuthority;
import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import java.text.DecimalFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/dg"})
public class DgController
extends BaseController {
    @Autowired
    private V1BusinessClient businessClient;
    @Autowired
    private StorageClient storageClient;
    @Autowired
    private CustomConfig customConfig;
    @Autowired
    private JobClient jobClient;

    @RequestMapping(value={"/index"})
    public String index(Model model) {
        switch (this.appVersion) {
            case "yantai": {
                break;
            }
            case "ningxia": {
                model.addAttribute("default_year", (Object)this.customConfig.getIndex().getDefault_year());
                model.addAttribute("threedinstanceid", (Object)this.customConfig.getIndex().getThreedinstanceid());
                model.addAttribute("initQuery", (Object)this.customConfig.getJanusgraph().getInitQuery());
                break;
            }
            default: {
                model.addAttribute("default_year", (Object)this.customConfig.getIndex().getDefault_year());
                model.addAttribute("threedinstanceid", (Object)this.customConfig.getIndex().getThreedinstanceid());
                model.addAttribute("initQuery", (Object)this.customConfig.getJanusgraph().getInitQuery());
                model.addAttribute("url", (Object)this.customConfig.getJanusgraph().getBaseUrl());
                DecimalFormat df = new DecimalFormat("0.00");
                String sPgSize = "";
                try {
                    String sTempSize = "";
                    double lTempSize = 0.0;
                    sTempSize = this.businessClient.findPostgresDatabaseSize("postgis");
                    if (sTempSize.indexOf(" MB") != -1) {
                        lTempSize += Double.parseDouble(sTempSize.substring(0, sTempSize.indexOf(" MB")));
                    } else if (sTempSize.indexOf(" GB") != -1) {
                        lTempSize += Double.parseDouble(sTempSize.substring(0, sTempSize.indexOf(" GB"))) * 1024.0;
                    }
                    sTempSize = this.businessClient.findPostgresDatabaseSize("postgisdb");
                    if (sTempSize.indexOf(" MB") != -1) {
                        lTempSize += Double.parseDouble(sTempSize.substring(0, sTempSize.indexOf(" MB")));
                    } else if (sTempSize.indexOf(" GB") != -1) {
                        lTempSize += Double.parseDouble(sTempSize.substring(0, sTempSize.indexOf(" GB"))) * 1024.0;
                    }
                    sTempSize = this.businessClient.findPostgresDatabaseSize("postgres");
                    if (sTempSize.indexOf(" MB") != -1) {
                        lTempSize += Double.parseDouble(sTempSize.substring(0, sTempSize.indexOf(" MB")));
                    } else if (sTempSize.indexOf(" GB") != -1) {
                        lTempSize += Double.parseDouble(sTempSize.substring(0, sTempSize.indexOf(" GB"))) * 1024.0;
                    }
                    sPgSize = lTempSize > 1048576.0 ? df.format(lTempSize / 1048576.0) + "TB" : (lTempSize > 1024.0 ? df.format(lTempSize / 1024.0) + "GB" : lTempSize + "MB");
                }
                catch (Exception sTempSize) {
                    // empty catch block
                }
                model.addAttribute("pgSize", (Object)sPgSize);
                PageRequest page = new PageRequest(0, 10000);
                PageResult pageStorageDtos = this.storageClient.listMimeStorages((Pageable)page, null, null, null, null, Integer.valueOf(1), Integer.valueOf(1));
                String sOtherSize = "0 MB";
                String sRemainOtherSize = "";
                long fileSize = 0L;
                if (pageStorageDtos != null) {
                    for (StorageDto storage : (List)pageStorageDtos.getData()) {
                        fileSize += storage.getFileSize() / 0x100000L;
                    }
                    sOtherSize = (double)fileSize < Math.pow(2.0, 10.0) ? fileSize + " MB" : ((double)fileSize < Math.pow(2.0, 20.0) ? df.format(fileSize / 1024L) + " GB" : df.format(fileSize / 0x100000L) + " TB");
                }
                model.addAttribute("otherSize", (Object)sOtherSize);
                String sTotalSize = "";
                if (!"".equals(sPgSize)) {
                    String extent = sPgSize.substring(sPgSize.length() - 2, sPgSize.length());
                    sPgSize = sPgSize.substring(0, sPgSize.length() - 2);
                    double lPgSize = 0.0;
                    try {
                        lPgSize = Double.parseDouble(sPgSize);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    double lTotalSize = 0.0;
                    String sRemainSize = "";
                    lTotalSize = extent.contains("MB") ? (double)fileSize + lPgSize : (extent.contains("GB") ? (double)fileSize + lPgSize * 1024.0 : (double)fileSize + lPgSize * 1024.0 * 1024.0);
                    sTotalSize = lTotalSize < Math.pow(2.0, 10.0) ? df.format(lTotalSize) + " MB" : (lTotalSize < Math.pow(2.0, 20.0) ? df.format(lTotalSize / 1024.0) + " GB" : df.format(lTotalSize / 1048576.0) + " TB");
                    model.addAttribute("totalSize", (Object)sTotalSize);
                    break;
                }
                model.addAttribute("totalSize", (Object)sOtherSize);
            }
        }
        model.addAttribute("menuCode", (Object)"\u9996\u9875");
        if (StringUtils.isBlank((String)this.appVersion)) {
            return "dg/index";
        }
        return "dg/index_" + this.appVersion;
    }

    @RequestMapping(value={"/sjzl"})
    @ModuleAuthority(code="sjzl")
    public String index2(Model model) {
        model.addAttribute("menuCode", (Object)"pt");
        return "dg/sjzl";
    }

    @RequestMapping(value={"/zl"})
    public String index3(Model model) {
        String sPgSize = "";
        DecimalFormat df = new DecimalFormat("0.00");
        try {
            String sTempSize = "";
            double lTempSize = 0.0;
            sTempSize = this.businessClient.findPostgresDatabaseSize("postgis");
            if (sTempSize.indexOf(" MB") != -1) {
                lTempSize += Double.parseDouble(sTempSize.substring(0, sTempSize.indexOf(" MB")));
            } else if (sTempSize.indexOf(" GB") != -1) {
                lTempSize += Double.parseDouble(sTempSize.substring(0, sTempSize.indexOf(" GB"))) * 1024.0;
            }
            sTempSize = this.businessClient.findPostgresDatabaseSize("postgisdb");
            if (sTempSize.indexOf(" MB") != -1) {
                lTempSize += Double.parseDouble(sTempSize.substring(0, sTempSize.indexOf(" MB")));
            } else if (sTempSize.indexOf(" GB") != -1) {
                lTempSize += Double.parseDouble(sTempSize.substring(0, sTempSize.indexOf(" GB"))) * 1024.0;
            }
            sTempSize = this.businessClient.findPostgresDatabaseSize("postgres");
            if (sTempSize.indexOf(" MB") != -1) {
                lTempSize += Double.parseDouble(sTempSize.substring(0, sTempSize.indexOf(" MB")));
            } else if (sTempSize.indexOf(" GB") != -1) {
                lTempSize += Double.parseDouble(sTempSize.substring(0, sTempSize.indexOf(" GB"))) * 1024.0;
            }
            sPgSize = lTempSize > 1048576.0 ? df.format(lTempSize / 1048576.0) + "TB" : (lTempSize > 1024.0 ? df.format(lTempSize / 1024.0) + "GB" : lTempSize + "MB");
        }
        catch (Exception sTempSize) {
            // empty catch block
        }
        sPgSize = "155GB";
        model.addAttribute("pgSize", (Object)sPgSize);
        PageRequest page = new PageRequest(0, 10000);
        PageResult pageStorageDtos = null;
        try {
            pageStorageDtos = this.storageClient.listMimeStorages((Pageable)page, null, null, null, null, Integer.valueOf(1), Integer.valueOf(1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String sOtherSize = "0 MB";
        String sRemainOtherSize = "";
        long fileSize = 0L;
        if (pageStorageDtos != null) {
            for (StorageDto storage : (List)pageStorageDtos.getData()) {
                fileSize += storage.getFileSize() / 0x100000L;
            }
            sOtherSize = (double)fileSize < Math.pow(2.0, 10.0) ? fileSize + " MB" : ((double)fileSize < Math.pow(2.0, 20.0) ? df.format(fileSize / 1024L) + " GB" : df.format(fileSize / 0x100000L) + " TB");
        }
        model.addAttribute("otherSize", (Object)sOtherSize);
        String sTotalSize = "";
        if (!"".equals(sPgSize)) {
            String extent = sPgSize.substring(sPgSize.length() - 2, sPgSize.length());
            sPgSize = sPgSize.substring(0, sPgSize.length() - 2);
            double lPgSize = Double.parseDouble(sPgSize);
            double lTotalSize = 0.0;
            String sRemainSize = "";
            lTotalSize = extent.contains("MB") ? (double)fileSize + lPgSize : (extent.contains("GB") ? (double)fileSize + lPgSize * 1024.0 : (double)fileSize + lPgSize * 1024.0 * 1024.0);
            sTotalSize = lTotalSize < Math.pow(2.0, 10.0) ? df.format(lTotalSize) + " MB" : (lTotalSize < Math.pow(2.0, 20.0) ? df.format(lTotalSize / 1024.0) + " GB" : df.format(lTotalSize / 1048576.0) + " TB");
            model.addAttribute("totalSize", (Object)sTotalSize);
        } else {
            model.addAttribute("totalSize", (Object)sOtherSize);
        }
        try {
            ResultBean result = this.jobClient.getJobList();
            List mapTask = (List)result.getData();
            if (mapTask != null) {
                model.addAttribute("taskSize", (Object)(mapTask.size() + "\u9879"));
            }
        }
        catch (Exception e) {
            model.addAttribute("taskSize", (Object)"0\u9879");
        }
        model.addAttribute("menuCode", (Object)"\u6211\u7684\u5e73\u53f0");
        return "dg/zl";
    }

    @RequestMapping(value={"/data_sta"})
    public String index4(Model model) {
        return "dg/data_sta";
    }

    @RequestMapping(value={"/sumdata"})
    public String index5(Model model) {
        return "dg/sumdata";
    }

    @RequestMapping(value={"/data_acc"})
    public String index6(Model model) {
        return "dg/data_acc";
    }

    @RequestMapping(value={"/data_col"})
    public String index7(Model model) {
        return "dg/data_col";
    }

    @RequestMapping(value={"/data_cap"})
    public String index8(Model model) {
        return "dg/data_cap";
    }

    @RequestMapping(value={"/data_pro"})
    public String index9(Model model) {
        return "dg/data_pro";
    }

    @RequestMapping(value={"/data_che"})
    public String index10(Model model) {
        return "dg/data_che";
    }

    @RequestMapping(value={"/process_che"})
    public String index11(Model model) {
        return "dg/process_che";
    }

    @RequestMapping(value={"/cap_progress"})
    public String index12() {
        return "dg/cap_progress";
    }

    @RequestMapping(value={"/process_rul"})
    public String processRule(Model model) {
        return "dg/process_rul";
    }

    @RequestMapping(value={"/fc-upload"})
    public String fcUpload(Model model) {
        return "dg/fc-upload";
    }
}

