/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web;

import cn.gtmap.gtc.common.clients.dm.wdm.DMClient;
import cn.gtmap.gtc.common.clients.dw.mdb.DataStoreClient;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.dg.utils.EnumUtils;
import cn.gtmap.gtc.dg.web.BaseController;
import cn.gtmap.gtc.gis.core.geojson.BaseConverter;
import cn.gtmap.gtc.gis.core.jtsgeo.JTSGeometryHelper;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/dm"})
public class DataMiningController
extends BaseController {
    @Autowired
    private DMClient dmClient;
    @Autowired
    private DataStoreClient dataStoreClient;

    @RequestMapping(value={"/rapid/jobs"})
    public String toolsManager(Model model, String id) {
        model.addAttribute("id", (Object)id);
        model.addAttribute("menuCode", (Object)"\u6211\u7684\u5e73\u53f0");
        return "dm/wdm/rapid-jobs";
    }

    @RequestMapping(value={"/tool/execute"})
    @ResponseBody
    public ResultBean execute(HttpServletRequest request) {
        MultipartHttpServletRequest mpRequest = (MultipartHttpServletRequest)request;
        MultiValueMap map = mpRequest.getMultiFileMap();
        List files = (List)map.get((Object)"file");
        String paramJson = mpRequest.getParameter("paramJson");
        String url = mpRequest.getParameter("url");
        String tooltype = mpRequest.getParameter("tooltype");
        String fileJson = mpRequest.getParameter("fileJson");
        JSONObject fileJSonObj = (JSONObject)JSON.parse((String)fileJson);
        JSONArray jsonArray = JSON.parseArray((String)paramJson);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject object = (JSONObject)jsonArray.get(i);
            if (!object.containsKey((Object)EnumUtils.ANALYSIS_PARAM.source_type.name())) continue;
            String sourceType = MapUtils.getString((Map)object, (Object)EnumUtils.ANALYSIS_PARAM.source_type.name(), (String)"");
            String paramKey = MapUtils.getString((Map)object, (Object)EnumUtils.ANALYSIS_PARAM.name.name(), (String)"");
            String paramVal = MapUtils.getString((Map)object, (Object)EnumUtils.ANALYSIS_PARAM.value.name(), (String)"");
            ResultBean resultJson = null;
            if (EnumUtils.SOURCE_TYPE.shp.name().equals(sourceType)) {
                String key = paramKey + "-file";
                String fileName = MapUtils.getString((Map)fileJSonObj, (Object)key, (String)"");
                for (MultipartFile file : files) {
                    if (!fileName.equals(file.getOriginalFilename())) continue;
                    resultJson = this.dataStoreClient.getGeojson(sourceType, "", file);
                }
            } else {
                resultJson = this.dataStoreClient.getGeojsonNoShp(sourceType, paramVal);
            }
            object.put(EnumUtils.ANALYSIS_PARAM.value.name(), (Object)resultJson.getData().toString());
        }
        return this.dmClient.execute(url, JSON.toJSONString((Object)jsonArray), tooltype);
    }

    @RequestMapping(value={"/tool/geoJson"})
    @ResponseBody
    public ResultBean getGeoJson(HttpServletRequest request) {
        MultipartHttpServletRequest mpRequest = (MultipartHttpServletRequest)request;
        String geometry = mpRequest.getParameter("geometry");
        Object geoJson = null;
        if (geometry.equals("1")) {
            MultipartFile file = mpRequest.getFile("file");
            return new ResultBean(this.dataStoreClient.getGeojson("shp", "", file).getData());
        }
        String layerName = mpRequest.getParameter("layerName");
        return new ResultBean(this.dataStoreClient.getGeojsonNoShp("sjcc", layerName).getData());
    }

    @RequestMapping(value={"/tool/getGeoJson"})
    @ResponseBody
    public ResultBean getJTWGeoJson(HttpServletRequest request) {
        MultipartHttpServletRequest mpRequest = (MultipartHttpServletRequest)request;
        String geometry = mpRequest.getParameter("geometry");
        String geoJson = null;
        if (geometry.equals("1")) {
            MultipartFile file = mpRequest.getFile("file");
            geoJson = JSON.toJSONString((Object)this.dataStoreClient.getGeojson("shp", "", file).getData());
        } else {
            String layerName = mpRequest.getParameter("layerName");
            geoJson = JSON.toJSONString((Object)this.dataStoreClient.getGeojsonNoShp("sjcc", layerName).getData());
        }
        BaseConverter baseConverter = new BaseConverter();
        JTSGeometryHelper jtsGeometryHelper = new JTSGeometryHelper();
        SimpleFeatureCollection simpleFeatureCollection = (SimpleFeatureCollection)jtsGeometryHelper.readUnTypeGeoJSON(geoJson);
        List mapList = baseConverter.convertToListMap(simpleFeatureCollection, "the_geom", true);
        return new ResultBean((Object)mapList);
    }
}

