/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web;

import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.dg.web.BaseController;
import cn.gtmap.gtc.resource.clients.resource.DictClient;
import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.MultipartDto;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/common"})
public class CommonController
extends BaseController {
    @Autowired
    private StorageClient storageClient;
    @Autowired
    private DictClient dictClient;

    @PostMapping(value={"/upload"})
    @ResponseBody
    public ResultBean upload(@RequestParam(name="file") MultipartFile file) throws IOException {
        MultipartDto multipartDto = new MultipartDto();
        multipartDto.setName(file.getName());
        multipartDto.setContentType(file.getContentType());
        multipartDto.setData(file.getBytes());
        multipartDto.setOriginalFilename(file.getOriginalFilename());
        multipartDto.setSize(file.getSize());
        StorageDto storageDto = this.storageClient.multipartUpload(multipartDto);
        return new ResultBean((Object)storageDto);
    }

    @GetMapping(value={"/get-dict"})
    @ResponseBody
    public ResultBean getDict(@RequestParam(value="key") String key) {
        return new ResultBean((Object)this.dictClient.findValueByKey(key));
    }

    @DeleteMapping(value={"/del-dict/{id}"})
    @ResponseBody
    public void delDict(@PathVariable(name="id") String id) {
        this.dictClient.deleteDict(id);
    }
}

