/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.web;

import cn.gtmap.gtc.clients.ModuleManagerClient;
import cn.gtmap.gtc.dg.config.CustomConfig;
import cn.gtmap.gtc.dg.service.AuthorityService;
import cn.gtmap.gtc.sso.domain.dto.ModuleDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ModelAttribute;

@Controller
public class BaseController {
    @Autowired
    private AuthorityService authSerive;
    @Autowired
    private ModuleManagerClient moduleManagerClient;
    @Autowired
    private CustomConfig customConfig;
    @Value(value="${server.port}")
    protected String port;
    @Value(value="${server.ui-path}")
    protected String uiPath;
    @Value(value="${app.oauth}")
    protected String loginPath;
    @Value(value="${url.account}")
    protected String accountPath;
    @Value(value="${url.storage}")
    protected String storagePath;
    @Value(value="${url.storageServer}")
    protected String storageServerPath;
    @Value(value="${url.bpm}")
    protected String bpmPath;
    @Value(value="${url.monitor}")
    protected String monitorPath;
    @Value(value="${url.datastore}")
    protected String datastorePath;
    @Value(value="${url.resourceProxy}")
    protected String resourceProxyPath;
    @Value(value="${url.resource-ui}")
    protected String resourceUiPath;
    @Value(value="${url.model-builder}")
    protected String modelBuilderUrl;
    @Value(value="${url.model-config}")
    protected String modelConfigUrl;
    @Value(value="${url.yxjy}")
    protected String yxjyPath;
    @Value(value="${security.oauth2.client.client-id}")
    protected String clientId;
    @Value(value="${app.version}")
    protected String appVersion;
    @Value(value="${app.copyright}")
    protected String appCopyright;
    @Value(value="${app.title}")
    protected String appTitle;
    @Value(value="${app.applykey}")
    protected String applyDefKey;
    @Value(value="${app.instanceId}")
    protected String instanceId;

    @ModelAttribute
    public void setReqAndRes(HttpServletRequest request, HttpServletResponse response) {
        try {
            UserDto currentUser = this.authSerive.getCurrentUser();
            request.setAttribute("uername", (Object)currentUser.getUsername());
        }
        catch (Exception currentUser) {
            // empty catch block
        }
        List rootModules = this.moduleManagerClient.getRootModules("yunClientID");
        ArrayList menu = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)rootModules)) {
            for (ModuleDto moduleDto : rootModules) {
                if (!StringUtils.equals((String)moduleDto.getType(), (String)"menu")) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", moduleDto.getId());
                map.put("code", moduleDto.getCode());
                map.put("name", moduleDto.getName());
                map.put("url", moduleDto.getUrl());
                map.put("method", moduleDto.getMethod());
                ArrayList child = new ArrayList();
                List juniorModules = this.moduleManagerClient.findJuniorModules(moduleDto.getId());
                if (!CollectionUtils.isEmpty((Collection)juniorModules)) {
                    for (ModuleDto dto : juniorModules) {
                        HashMap<String, String> map1 = new HashMap<String, String>();
                        map1.put("id", dto.getId());
                        map1.put("code", dto.getCode());
                        map1.put("name", dto.getName());
                        map1.put("url", dto.getUrl());
                        map1.put("method", dto.getMethod());
                        child.add(map1);
                    }
                }
                map.put("children", child);
                menu.add(map);
            }
        }
        request.setAttribute("menus", menu);
        request.setAttribute("dgUiPath", (Object)(this.uiPath + ":" + this.port));
        request.setAttribute("accountPath", (Object)this.accountPath);
        request.setAttribute("storagePath", (Object)this.storagePath);
        request.setAttribute("bpmPath", (Object)this.bpmPath);
        request.setAttribute("loginPath", (Object)this.loginPath);
        request.setAttribute("monitorPath", (Object)this.monitorPath);
        request.setAttribute("storageServerPath", (Object)this.storageServerPath);
        request.setAttribute("datastorePath", (Object)this.datastorePath);
        request.setAttribute("resourceProxyPath", (Object)this.resourceProxyPath);
        request.setAttribute("resourceUiPath", (Object)this.resourceUiPath);
        request.setAttribute("modelBuilderUrl", (Object)this.modelBuilderUrl);
        request.setAttribute("modelConfigUrl", (Object)this.modelConfigUrl);
        request.setAttribute("yxjyPath", (Object)this.yxjyPath);
        request.setAttribute("clientId", (Object)this.clientId);
        request.setAttribute("appVersion", (Object)(StringUtils.isBlank((String)this.appVersion) ? "" : "_" + this.appVersion));
        request.setAttribute("appTitle", (Object)this.appTitle);
        request.setAttribute("appCopyright", (Object)this.appCopyright);
        request.setAttribute("parseGeoFileUrl", (Object)this.customConfig.getGisDataAnalysis().getParseGeoFileUrl());
    }
}

