/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.service.Impl;

import cn.gtmap.gtc.clients.LogMessageClient;
import cn.gtmap.gtc.dg.client.ResourceGWClient;
import cn.gtmap.gtc.dg.service.LogService;
import cn.gtmap.gtc.dg.utils.TimeUtil;
import cn.gtmap.gtc.resource.clients.resource.CatalogClient;
import cn.gtmap.gtc.resource.clients.resource.DictClient;
import cn.gtmap.gtc.resource.domain.resource.dto.resource.CatalogView;
import cn.gtmap.gtc.sso.domain.dto.AccessStatsDto;
import cn.gtmap.gtc.sso.domain.dto.DataValue;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class LogServiceImpl
implements LogService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private LogMessageClient logMessageClient;
    @Autowired
    private ResourceGWClient resourceGWClient;
    @Autowired
    private CatalogClient catalogClient;
    @Autowired
    private DictClient dictClient;
    private static final String TIMESTAMP = "timestap";
    private static final String COUNT = "count";
    private static final String DOC_COUNT = "doc_count";

    public long getResourceCountByWeek(String resourceId) {
        Date date = new Date();
        Date before = TimeUtil.getDateBefore((Date)date, (int)6);
        long endTime = TimeUtil.getEnd((Date)date).getTime();
        long startTime = TimeUtil.getEnd((Date)before).getTime();
        return this.commonHistoryNubmer(resourceId, startTime, endTime, "day");
    }

    public long getResourceCountByYear(String resourceId) {
        Calendar curr = Calendar.getInstance();
        curr.set(1, curr.get(1) - 1);
        Date date = curr.getTime();
        return this.commonHistoryNubmer(resourceId, date.getTime(), System.currentTimeMillis(), "month");
    }

    public List<String> getResourceDetailByWeek(String resourceId) {
        Date myDate = new Date();
        Date before = TimeUtil.getDateBefore((Date)myDate, (int)7);
        myDate.setDate(myDate.getDate() - 6);
        String[] dateArray = new String[7];
        String[] countArray = new String[7];
        for (int i = 0; i < 7; ++i) {
            countArray[i] = "0";
        }
        String count = "";
        for (int i = 0; i < 7; ++i) {
            String dateTemp;
            int year = myDate.getYear() + 1900;
            dateArray[i] = dateTemp = year + "-" + (myDate.getMonth() + 1) + "-" + myDate.getDate();
            myDate.setDate(myDate.getDate() + 1);
        }
        long endTime = TimeUtil.getEnd((Date)myDate).getTime();
        long startTime = TimeUtil.getEnd((Date)before).getTime();
        List details = this.commonHistoryByResourceId(resourceId, startTime, endTime, "day");
        block2: for (Map detail : details) {
            long time = Long.parseLong((String)detail.get(TIMESTAMP));
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-M-d");
            String dateString = formatter.format(time);
            count = (String)detail.get(COUNT);
            for (int i = 0; i < 7; ++i) {
                if (!dateArray[i].equals(dateString)) continue;
                countArray[i] = count;
                continue block2;
            }
        }
        return new ArrayList<String>(Arrays.asList(countArray));
    }

    public List<String> getResourceDetailByYear(String resourceId) {
        int i;
        String[] countArray = new String[12];
        String[] dateArray2 = new String[12];
        String[] dateArray = new String[12];
        Date d = new Date();
        Calendar curr = Calendar.getInstance();
        curr.set(1, curr.get(1) - 1);
        for (i = 0; i < 12; ++i) {
            countArray[i] = "0";
        }
        for (i = 0; i < 12; ++i) {
            d.setMonth(d.getMonth() - 1);
            int m = d.getMonth() + 2;
            if (m == 13) {
                dateArray[i] = d.getYear() + 1900 + 1 + "-1";
                continue;
            }
            m = m < 10 ? 0 + m : m;
            dateArray[i] = d.getYear() + 1900 + "-" + m;
        }
        for (i = 0; i < 12; ++i) {
            dateArray2[11 - i] = dateArray[i];
        }
        List details = this.commonHistoryByResourceId(resourceId, curr.getTime().getTime(), System.currentTimeMillis(), "month");
        block3: for (Map detail : details) {
            long time = Long.parseLong((String)detail.get(TIMESTAMP));
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-M");
            String dateString = formatter.format(time);
            String count = (String)detail.get(COUNT);
            for (int i2 = 0; i2 < 12; ++i2) {
                if (!dateArray2[i2].equals(dateString)) continue;
                countArray[i2] = count;
                continue block3;
            }
        }
        return new ArrayList<String>(Arrays.asList(countArray));
    }

    public long getResourceByResourceId(String resourceIds, long startTime, long endTime) {
        String[] details = resourceIds.split(",");
        long count = 0L;
        for (String key : details) {
            if (key.equals("")) continue;
            String url = "http:/resp/" + key + "*";
            String message = this.logMessageClient.generalQuery(this.buildResAccStatsQuery(url, startTime, endTime));
            count += this.getResAccStatsResult(message);
        }
        return count;
    }

    public long commonHistoryNubmer(String resourceId, long startTime, long endTime, String interval) {
        String url = "http:/resp/" + resourceId + "*";
        long count = 0L;
        String message = this.logMessageClient.generalQuery(this.buildResIntervalStatsQuery(url, startTime, endTime, interval));
        List list = this.getResIntervalStatsResult(message);
        for (DataValue data : list) {
            count += Long.valueOf(data.getKey()).longValue();
        }
        return count;
    }

    public List<Map<String, String>> commonHistoryByResourceId(String resourceId, long startTime, long endTime, String interval) {
        ArrayList<Map<String, String>> history = new ArrayList<Map<String, String>>();
        String url = "http:/resp/" + resourceId + "*";
        String message = this.logMessageClient.generalQuery(this.buildResIntervalStatsQuery(url, startTime, endTime, interval));
        List list = this.getResIntervalStatsResult(message);
        for (DataValue data : list) {
            HashMap<String, String> detail = new HashMap<String, String>();
            detail.put(COUNT, data.getKey());
            detail.put(TIMESTAMP, data.getValue() + "");
            history.add(detail);
        }
        return history;
    }

    public Map getHotResourcePercent(long start, long end) {
        String url = "http:/resp/*";
        String responseMessage = this.logMessageClient.generalQuery(this.buildHotResStatsQuery(url, start, end));
        List datas = this.getHotResStatsResult(responseMessage);
        datas.stream().sorted(Comparator.comparing(DataValue::getValue)).collect(Collectors.toList());
        StringBuilder strs = new StringBuilder();
        int resourceCount = 150000;
        try {
            resourceCount = Integer.parseInt(this.dictClient.findValueByKey("resourceCount").getValue());
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u786e\u8ba4\u70ed\u95e8\u8d44\u6e90\u6570\u636e\u91cf\u5dee\u503c\u5b57\u5178\u9879resourceCount\u662f\u5426\u914d\u7f6e\u6b63\u786e");
        }
        List resData = new ArrayList();
        boolean res = false;
        for (int n = 0; n < datas.size() && !res; ++n) {
            for (int m = n + 1; m < datas.size() - 1 && !res; ++m) {
                int b;
                int a = Integer.parseInt(((DataValue)datas.get(n)).getValue());
                if (a - (b = Integer.parseInt(((DataValue)datas.get(m)).getValue())) > resourceCount) {
                    resData = datas.subList(n + 1, datas.size());
                    res = true;
                    continue;
                }
                a = b;
                if (a - (b = Integer.parseInt(((DataValue)datas.get(m + 1)).getValue())) > resourceCount) {
                    resData = datas.subList(m + 1, datas.size());
                    res = true;
                    continue;
                }
                resData = datas;
            }
        }
        for (DataValue data : datas) {
            String id = data.getKey();
            strs.append(id + ",");
        }
        List resMapList = this.resourceGWClient.getNameByIds(strs.toString());
        Map st = new HashMap();
        Map catas = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)resMapList) && resMapList.size() >= 2) {
            st = (Map)resMapList.get(0);
            catas = (Map)resMapList.get(1);
        }
        int i = 0;
        ArrayList maps = new ArrayList();
        for (DataValue detail : resData) {
            for (Map.Entry entry : st.entrySet()) {
                if (!detail.getKey().contains((CharSequence)entry.getKey())) continue;
                DataValue data = new DataValue();
                data.setKey((String)entry.getValue());
                data.setValue(detail.getValue());
                datas.set(i, data);
                ++i;
            }
            for (Map.Entry entry : catas.entrySet()) {
                if (!detail.getKey().contains((CharSequence)entry.getKey())) continue;
                HashMap map = new HashMap();
                map.put(entry.getValue(), detail.getValue());
                maps.add(map);
            }
        }
        List catalogViewList = this.catalogClient.findAllCatalogByType("RESC");
        HashMap<String, Integer> titleMap = new HashMap<String, Integer>();
        for (CatalogView catalogView : catalogViewList) {
            int num = 0;
            String code = catalogView.getCode();
            for (Map map : maps) {
                if (!map.containsKey(code)) continue;
                num += MapUtils.getInteger((Map)map, (Object)code).intValue();
            }
            titleMap.put(catalogView.getTitle(), num);
        }
        return titleMap;
    }

    public List<Map> getHotResource(long start, long end) {
        String url = "http:/resp/*";
        String responseMessage = this.logMessageClient.generalQuery(this.buildHotResStatsQuery(url, start, end));
        List datas = this.getHotResStatsResult(responseMessage);
        StringBuilder strs = new StringBuilder();
        for (DataValue data : datas) {
            String id = data.getKey();
            strs.append(id + ",");
        }
        List resMapList = this.resourceGWClient.getNameByIds(strs.toString());
        Map st = (Map)resMapList.get(0);
        ArrayList<Map> mapList = new ArrayList<Map>();
        for (Map.Entry entry : st.entrySet()) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("value", entry.getValue());
            valueMap.put("key", entry.getKey());
            mapList.add(valueMap);
        }
        return mapList;
    }

    private String buildHotResStatsQuery(String url, long begin, long end) {
        return "{\"size\": 0,\"query\": {\"bool\": {\"must\": [{\"wildcard\": {\"name\": \"" + url + "\"}},{\"range\":{\"timestamp_millis\": {\"gte\": " + begin + ",\"lte\": " + end + "}}}]}},\"aggs\": {\"xx\": {\"nested\": {\"path\": \"binaryAnnotations\"},\"aggs\": {\"tsdd\": {\"filter\": {\"term\": {\"binaryAnnotations.key\": \"custom\"}},\"aggs\": {\"detail\": {\"terms\": {\"field\": \"binaryAnnotations.value\",\"size\": 10}}}}}}}}";
    }

    private String buildResAccStatsQuery(String url, long begin, long end) {
        return "{\"size\":0,\"query\":{\"bool\":{\"must\":[{\"wildcard\":{\"name\":\"" + url + "\"}},{\"range\":{\"timestamp_millis\":{\"gte\":" + begin + ",\"lte\":" + end + "}}}]}},\"aggs\":{\"uniqueTraceId\":{\"cardinality\":{\"field\":\"traceId\"}}}}";
    }

    private String buildResIntervalStatsQuery(String url, long begin, long end, String interval) {
        return "{\"size\":0,\"query\":{\"bool\":{\"must\":[{\"wildcard\":{\"name\":\"" + url + "\"}},{\"range\":{\"timestamp_millis\":{\"gte\":" + begin + ",\"lte\":" + end + "}}}]}},\"aggs\":{\"days\":{\"date_histogram\":{\"field\":\"timestamp_millis\",\"interval\":\"" + interval + "\",\"min_doc_count\":0},\"aggs\":{\"uniqueTraceId\":{\"cardinality\":{\"field\":\"traceId\"}}}}}}";
    }

    private List<DataValue> getHotResStatsResult(String message) {
        ArrayList<DataValue> dataList = new ArrayList<DataValue>();
        String data = message.replaceAll("/n", "");
        TreeMap<Long, String> statisticalData = new TreeMap<Long, String>();
        JSONObject jsonObject = JSON.parseObject((String)data);
        JSONObject aggregations = (JSONObject)jsonObject.get((Object)"aggregations");
        JSONObject xx = (JSONObject)aggregations.get((Object)"xx");
        JSONObject tsdd = (JSONObject)xx.get((Object)"tsdd");
        JSONObject detail = (JSONObject)tsdd.get((Object)"detail");
        JSONArray buckets = (JSONArray)detail.get((Object)"buckets");
        for (JSONObject json : buckets.toJavaList(JSONObject.class)) {
            DataValue value = new DataValue();
            value.setKey(json.get((Object)"key").toString());
            value.setValue(json.get((Object)DOC_COUNT).toString());
            statisticalData.put(Long.valueOf(json.get((Object)DOC_COUNT).toString()), json.get((Object)"key").toString());
            dataList.add(value);
        }
        return dataList;
    }

    private long getResAccStatsResult(String message) {
        String data = message.replaceAll("/n", "");
        JSONObject jsonObject = JSON.parseObject((String)data);
        JSONObject aggregations = jsonObject.getJSONObject("aggregations");
        JSONObject uniqueTraceId = aggregations.getJSONObject("uniqueTraceId");
        return Long.valueOf(uniqueTraceId.get((Object)"value").toString());
    }

    public List<DataValue> getResIntervalStatsResult(String message) {
        String data = message.replaceAll("/n", "");
        JSONObject jsonObject = JSON.parseObject((String)data);
        JSONObject t = jsonObject.getJSONObject("aggregations");
        JSONObject tt = t.getJSONObject("days");
        ArrayList<DataValue> dataList = new ArrayList<DataValue>();
        if (tt != null) {
            JSONArray ttt = tt.getJSONArray("buckets");
            for (JSONObject json : ttt.toJavaList(JSONObject.class)) {
                DataValue value = new DataValue();
                value.setValue(json.get((Object)"key").toString());
                value.setKey(json.getJSONObject("uniqueTraceId").get((Object)"value").toString());
                dataList.add(value);
            }
        }
        return dataList;
    }

    public AccessStatsDto accessStatistics(@RequestParam(name="event", required=false) String event, @RequestParam(name="principal", required=false) String principal, @RequestParam(name="begin", required=false) Long begin, @RequestParam(name="end", required=false) Long end) {
        return this.logMessageClient.accessStatistics(event, principal, begin, end);
    }
}

