/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.dg.service.Impl;

import cn.gtmap.gtc.clients.AuthorityManagerClient;
import cn.gtmap.gtc.clients.DataAuthorityClient;
import cn.gtmap.gtc.clients.DataResourceClient;
import cn.gtmap.gtc.clients.ModuleManagerClient;
import cn.gtmap.gtc.clients.OperationManagerClient;
import cn.gtmap.gtc.clients.OrganizationManagerClient;
import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.common.domain.core.PageBean;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import cn.gtmap.gtc.dg.service.AuthorityService;
import cn.gtmap.gtc.sso.domain.dto.AuthorityDto;
import cn.gtmap.gtc.sso.domain.dto.DataAuthorityDto;
import cn.gtmap.gtc.sso.domain.dto.DataResourceDto;
import cn.gtmap.gtc.sso.domain.dto.ModuleDto;
import cn.gtmap.gtc.sso.domain.dto.OperationDto;
import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AuthorityServiceImpl
implements AuthorityService {
    @Autowired
    DataResourceClient sourceClient;
    @Autowired
    UserManagerClient userClient;
    @Autowired
    OperationManagerClient operationClient;
    @Autowired
    DataAuthorityClient authorityClient;
    @Autowired
    OrganizationManagerClient orgClient;
    @Autowired
    ModuleManagerClient moduleClient;
    @Autowired
    AuthorityManagerClient authManagerClient;

    public DataResourceDto findDataSource(String moduleCode, String moduleName, String code) {
        DataResourceDto dataResource = this.sourceClient.getDataResource(moduleCode, code);
        if (dataResource == null) {
            return this.sourceClient.saveDataResource(moduleCode, moduleName, code, null);
        }
        return dataResource;
    }

    public UserDto getCurrentUser() {
        return this.userClient.getCurrentUser();
    }

    public List<DataAuthorityDto> saveDataAuthority(String users, String moduleCode, String moduleName, String codes, String authorityCode) {
        ArrayList<DataAuthorityDto> listResult = new ArrayList<DataAuthorityDto>();
        ArrayList<UserDto> listUserDto = new ArrayList<UserDto>();
        if (users.equals("self")) {
            listUserDto.add(this.userClient.getCurrentUser());
        } else {
            String[] userArray = users.split(",");
            for (String userName : userArray) {
                UserDto userDto;
                if (userName == "" || (userDto = this.userClient.getUserDetailByUsername(userName)) == null) continue;
                listUserDto.add(userDto);
            }
        }
        String[] codeArray = codes.split(",");
        for (UserDto item : listUserDto) {
            DataAuthorityDto dataAuthority = new DataAuthorityDto();
            dataAuthority.setUserId(item.getId());
            dataAuthority.setUserAlias(item.getAlias());
            dataAuthority.setUserName(item.getUsername());
            for (String code : codeArray) {
                dataAuthority.setDataResourceDto(this.findDataSource(moduleCode, moduleName, code));
                if (authorityCode.equals("")) {
                    authorityCode = "";
                    List listOperations = this.operationClient.findAll();
                    for (OperationDto operation : listOperations) {
                        if (!operation.getCode().equals("read") && (!operation.getCode().equals("update") || !"self".equals(users))) continue;
                        authorityCode = authorityCode + operation.getId() + ",";
                    }
                    authorityCode = authorityCode.substring(0, authorityCode.length() - 1);
                }
                dataAuthority.setAuthority(authorityCode);
                listResult.add(this.authorityClient.saveDataAuthority(dataAuthority));
            }
        }
        return listResult;
    }

    public List<Map> getAllUsers() {
        ArrayList<Map> resultlist = new ArrayList<Map>();
        UserDto currentUser = this.userClient.getCurrentUser();
        String username = currentUser.getUsername();
        Page users = this.userClient.listGradeUsers((Pageable)new PageRequest(0, 1000), username, null, null, Integer.valueOf(1));
        for (UserDto user : users) {
            if (username.equals(user.getUsername())) continue;
            HashMap<String, String> mapUser = new HashMap<String, String>();
            mapUser.put("name", user.getUsername());
            mapUser.put("value", user.getId());
            resultlist.add(mapUser);
        }
        return resultlist;
    }

    public PageBean getUsersByPage(int page, int size, String searchName, String searchAlisa) {
        Page users = this.userClient.listGradeUsers((Pageable)new PageRequest(page, size), "admin", searchName, searchAlisa, null);
        List listUsers = users.getContent();
        return new PageBean(Integer.valueOf(page), Integer.valueOf(size), Integer.valueOf((int)users.getTotalElements()), listUsers);
    }

    public List<Map> getAllOperation() {
        ArrayList<Map> resultlist = new ArrayList<Map>();
        List listOperations = this.operationClient.findAll();
        for (OperationDto operation : listOperations) {
            HashMap<String, String> mapOper = new HashMap<String, String>();
            mapOper.put("name", operation.getName());
            mapOper.put("value", operation.getId());
            resultlist.add(mapOper);
        }
        return resultlist;
    }

    public String queryUserDataAuthority(String userName, String moduleCode, String code) {
        return this.authorityClient.userDataAuthority(userName, moduleCode, code);
    }

    public List<Map> queryUserModuleAuthority(String userName, String moduleCode) {
        List listAuthDtos = this.authManagerClient.findModuleAuthorities(userName, moduleCode);
        ArrayList<Map> listResult = new ArrayList<Map>();
        if (listAuthDtos.size() == 0) {
            return listResult;
        }
        for (OperationDto oper : ((AuthorityDto)listAuthDtos.get(0)).getOperations()) {
            HashMap<String, String> mapOper = new HashMap<String, String>();
            mapOper.put("name", oper.getName());
            mapOper.put("value", oper.getId());
            listResult.add(mapOper);
        }
        return listResult;
    }

    public List<String> queryCode(String userName, String moduleCode, String authorityCode, boolean isEqual) {
        ArrayList<String> listResultCode = new ArrayList<String>();
        Page dataAuthorities = this.authorityClient.findUserPage((Pageable)new PageRequest(0, 1000, null), userName, null);
        if (dataAuthorities == null) {
            return new ArrayList<String>();
        }
        List listAuthorities = dataAuthorities.getContent();
        listAuthorities.forEach(p -> {
            DataResourceDto resource = p.getDataResourceDto();
            String authority = p.getAuthority();
            if ((isEqual && authority.equals(authorityCode) || !isEqual && authority.contains(authorityCode)) && resource != null && resource.getModuleCode().equals(moduleCode)) {
                listResultCode.add(resource.getCode());
            }
        });
        return listResultCode;
    }

    public String queryAuthorityID(String userName, String moduleCode, String code) {
        DataAuthorityDto authorityDto = this.authorityClient.findConfigUserAuthority(userName, moduleCode, code);
        if (authorityDto != null) {
            return authorityDto.getId();
        }
        return "";
    }

    public boolean deleteAuthority(String authorityID) {
        return this.authorityClient.deleteAuthority(authorityID);
    }

    public boolean deleteDataSource(String dataSourceID) {
        return this.sourceClient.deleteDataResource(dataSourceID);
    }

    public boolean deleteAuthorityAndDataSource(String userName, String moduleCode, String moduleName, String code) {
        String authorityID = this.queryAuthorityID(userName, moduleCode, code);
        if (this.deleteAuthority(authorityID)) {
            DataResourceDto resourceDto = this.findDataSource(moduleCode, moduleName, code);
            String resourceID = resourceDto.getId();
            return this.deleteDataSource(resourceID);
        }
        return false;
    }

    public boolean exist(String userName) {
        return this.userClient.checkUserExist(userName);
    }

    public ResultBean buildOrgTree() {
        List listRootOrgs = this.orgClient.findRootOrgs();
        return new ResultBean((Object)this.buildChildrenTree(listRootOrgs));
    }

    public ResultBean addUser(UserDto user) {
        return new ResultBean((Object)this.userClient.createNewUser(user));
    }

    public ResultBean getOrgByIds(List<String> ids) {
        return new ResultBean((Object)this.orgClient.findOrgByIds(ids));
    }

    public ResultBean enableUser(String id, int enable) {
        if (enable == 0) {
            return new ResultBean((Object)this.userClient.disabledUser(id));
        }
        return new ResultBean((Object)this.userClient.enabledUser(id));
    }

    public ResultBean editUser(UserDto user) {
        return new ResultBean((Object)this.userClient.updateUser(user.getId(), user));
    }

    public ResultBean deleteUser(String id) {
        return new ResultBean((Object)this.userClient.deleteUser(id));
    }

    public ResultBean editOrg(OrganizationDto org) {
        return new ResultBean((Object)this.orgClient.updateOrg(org));
    }

    public ResultBean addOrg(OrganizationDto org) {
        return new ResultBean((Object)this.orgClient.createOrg(org));
    }

    public boolean deleteOrg(String id) {
        return this.orgClient.deleteOrg(id);
    }

    private List<Map<String, Object>> buildChildrenTree(List<OrganizationDto> listRootOrgs) {
        ArrayList<Map<String, Object>> listResult = new ArrayList<Map<String, Object>>();
        for (OrganizationDto org : listRootOrgs) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            List listChildOrgs = this.orgClient.findChildren(org.getId(), null);
            if (listChildOrgs != null && listChildOrgs.size() != 0) {
                result.put("children", this.buildChildrenTree(listChildOrgs));
            }
            result.put("id", org.getId());
            result.put("code", org.getCode());
            result.put("name", org.getName());
            result.put("parentId", org.getParentId());
            result.put("parentName", org.getParentName());
            listResult.add(result);
        }
        return listResult;
    }

    public ResultBean getSubsModules(String clientId) {
        List listRoots = this.moduleClient.getRootModules(clientId);
        return new ResultBean((Object)this.buildModule(listRoots));
    }

    private List<Map<String, Object>> buildModule(List<ModuleDto> listRoots) {
        ArrayList<Map<String, Object>> listResult = new ArrayList<Map<String, Object>>();
        for (ModuleDto module : listRoots) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            List listChildModules = this.moduleClient.findJuniorModules(module.getId());
            if (listChildModules != null && listChildModules.size() != 0) {
                result.put("children", this.buildModule(listChildModules));
            }
            result.put("id", module.getId());
            result.put("name", module.getName());
            result.put("parentId", module.getParentId());
            result.put("parentName", module.getParentName());
            result.put("code", module.getCode());
            listResult.add(result);
        }
        return listResult;
    }

    public boolean saveModuleAuthority(String userName, String moduleId, String jsonOperations) {
        List listOperations = (List)JSON.parse((String)jsonOperations);
        ModuleDto modDto = this.moduleClient.getModuleById(moduleId);
        List listAuthDtos = this.authManagerClient.findModuleAuthorities(userName, modDto.getCode());
        AuthorityDto authorityDto = null;
        if (listAuthDtos.size() == 0) {
            ArrayList<OperationDto> listResult = new ArrayList<OperationDto>();
            authorityDto = new AuthorityDto();
            UserDto user = this.userClient.getUserDetailByUsername(userName);
            authorityDto.setUserId(user.getId());
            authorityDto.setUserAlias(user.getAlias());
            authorityDto.setUserName(userName);
            authorityDto.setModuleCode(modDto.getCode());
            authorityDto.setModuleClientId(modDto.getClientId());
            authorityDto.setModuleId(moduleId);
            authorityDto.setModuleName(modDto.getName());
            for (Map mapOper : listOperations) {
                String id = mapOper.get("value").toString();
                OperationDto operationDto = this.operationClient.findById(id);
                listResult.add(operationDto);
            }
            authorityDto.setOperations(listResult);
            this.authManagerClient.createAuthority(authorityDto);
        } else {
            authorityDto = (AuthorityDto)listAuthDtos.get(0);
            List listDelete = authorityDto.getOperations();
            ArrayList<String> listDeleteIds = new ArrayList<String>();
            for (OperationDto oper : listDelete) {
                listDeleteIds.add(oper.getId());
            }
            this.authManagerClient.removeOperationRef(authorityDto.getId(), listDeleteIds);
            ArrayList<String> listOperIds = new ArrayList<String>();
            authorityDto = (AuthorityDto)listAuthDtos.get(0);
            for (Map mapOper : listOperations) {
                String id = mapOper.get("value").toString();
                listOperIds.add(id);
            }
            this.authManagerClient.addOperation(authorityDto.getId(), listOperIds);
        }
        return true;
    }
}

