/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.common.clients.dw.mdb;

import cn.gtmap.gtc.common.domain.core.PageBean;
import cn.gtmap.gtc.common.domain.core.ResultBean;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@FeignClient(value="mdb-app")
@RequestMapping(value={"/mdb/v1/gs"})
public interface MapServiceClient {
    @ApiOperation(value="\u521b\u5efa\u5de5\u4f5c\u533a")
    @PostMapping(value={"/create/workspace"})
    public ResultBean createWorkspace(@RequestParam(value="workspace") String var1);

    @PostMapping(value={"/create/datastore"})
    public ResultBean createDataStore(@RequestParam(value="datastore") String var1, @RequestParam(value="parameters") String var2);

    @GetMapping(value={"/list/layerName"})
    public ResultBean listLayerName(@RequestParam(value="storeName") String var1);

    @PostMapping(value={"/publish/layer"})
    public ResultBean publishDBLayer(@RequestParam(value="workspace") String var1, @RequestParam(value="datastore") String var2, @RequestParam(value="layerName") String var3);

    @GetMapping(value={"/featureNames"})
    public ResultBean getFeatureNames(@RequestParam(value="parameters") Map var1) throws Exception;

    @PostMapping(value={"/layer/publish"})
    public ResultBean pulishLayerDefaultStyle(@RequestParam(name="tableId") String var1, @RequestParam(name="serviceName") String var2, @RequestParam(name="createBy") String var3, @RequestParam(name="addstyleName", required=false, defaultValue="generic") String var4, @RequestParam(name="tags", required=false, defaultValue="") Set<String> var5);

    @PostMapping(value={"/layer/temppublish"})
    public ResultBean pulishTempLayer(@RequestParam(name="tableId") String var1, @RequestParam(name="addstyleName", required=false, defaultValue="generic") String var2);

    @GetMapping(value={"/mapservice/list"})
    public PageBean listMetaMapService(@RequestParam(name="pageIndex", defaultValue="1") Integer var1, @RequestParam(name="pageSize", defaultValue="20") Integer var2);

    @GetMapping(value={"/mapservice/list1"})
    public PageBean listMetaMapService1(@RequestParam(name="text") String var1, @RequestParam(name="filterfield", required=false) String var2, @RequestParam(name="guids", required=false) Set<String> var3, @RequestParam(name="withthumbnail", required=false, defaultValue="false") boolean var4, @RequestParam(name="pageIndex", defaultValue="1") Integer var5, @RequestParam(name="pageSize", defaultValue="20") Integer var6);

    @GetMapping(value={"/mapservice/{id}"})
    public PageBean getMapServiceByID(@PathVariable(name="id") String var1);

    @GetMapping(value={"/mapservice1/{tableId}"})
    public PageBean getMapServiceByTableID(@PathVariable(name="tableId") String var1);

    @PostMapping(value={"/style/publish"}, consumes={"multipart/form-data"})
    public ResultBean publishSLDStyle(@RequestPart(name="file") MultipartFile var1);

    @PutMapping(value={"/layer/style"})
    public ResultBean updateMapStyle(@RequestParam(name="serviceId") String var1, @RequestParam(name="styleName") String var2);

    @PostMapping(value={"/layer/enable"})
    public ResultBean setMapServiceEnabled(@RequestParam(name="serviceId") String var1, @RequestParam(name="enable") boolean var2);

    @PostMapping(value={"/layer/delete"})
    public ResultBean deleteMapService(@RequestParam(name="serviceId") String var1);

    @PutMapping(value={"/layer/{id}"})
    public ResultBean updateMapservice(@PathVariable(name="id") String var1, @RequestParam(name="attributes") String var2);

    @PutMapping(value={"/layer2/{id}"})
    public ResultBean updateMapservice(@PathVariable(name="id") String var1, @RequestParam(name="attributes") String var2, @RequestParam(name="tags", required=false, defaultValue="") Set<String> var3);

    @GetMapping(value={"/layer/{text}"})
    public PageBean getMapserviceByText(@PathVariable(name="text") String var1, @RequestParam(name="pageIndex", defaultValue="1") Integer var2, @RequestParam(name="pageSize", defaultValue="20") Integer var3);

    @GetMapping(value={"/publishedstyle"})
    public PageBean listSLDStyles(@RequestParam(name="page") Integer var1, @RequestParam(name="limit") Integer var2);

    @PostMapping(value={"/stylewiththumbnail"})
    public PageBean listSLDStylesWithThumbnail(@RequestParam(name="page") Integer var1, @RequestParam(name="limit") Integer var2);

    @PostMapping(value={"/delmapstyle"})
    public ResultBean delMapStyles(@RequestParam(name="styleNames") List<String> var1);

    @GetMapping(value={"/publishedlayers"})
    public PageBean listLayersWithExtent(@RequestParam(name="page") Integer var1, @RequestParam(name="limit") Integer var2);

    @PostMapping(value={"/layer/thumbnail"})
    public ResultBean createThumbnail(@RequestParam(name="layerName") String var1, @RequestParam(name="styleName") String var2);

    @GetMapping(value={"/layerinfo"})
    public ResultBean getLayerWithExtentByName(@RequestParam(name="layerName") String var1);

    @Configuration
    public static class MultipartSupportConfig {
        @Bean
        Encoder feignFormEncoder() {
            return new SpringFormEncoder();
        }
    }
}

