/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.common.clients.dc.dgk;

import cn.gtmap.gtc.common.domain.core.ResultBean;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@FeignClient(name="dgk-app", configuration={FeignSupportConfig.class})
@RequestMapping(value={"/v1/job"})
public interface JobClient {
    @PostMapping(value={"/start"})
    public ResultBean startJob(@RequestParam(name="id") String var1);

    @RequestMapping(value={"/log"})
    public ResultBean getLog(long var1);

    @RequestMapping(value={"/list"})
    public ResultBean getJobList();

    @PostMapping(value={"/stop"})
    public ResultBean stopJob(@RequestParam(name="id") String var1);

    @GetMapping(value={"/timing/get"})
    public ResultBean getTiming(@RequestParam(name="id", defaultValue="") String var1);

    @PostMapping(value={"/timing/set"})
    public ResultBean setTiming(@RequestParam(name="id", defaultValue="") String var1, @RequestBody Map var2) throws Exception;

    @PostMapping(value={"/timing/edit"})
    public ResultBean edit(@RequestParam(name="id", defaultValue="") String var1, @RequestParam(name="description", defaultValue="") String var2, @RequestParam(name="name", defaultValue="") String var3, @RequestParam(name="status", defaultValue="") String var4);

    @PostMapping(value={"/add"}, consumes={"multipart/form-data"})
    public ResultBean add(@RequestParam(name="description") String var1, @RequestParam(name="name") String var2, @RequestPart(name="kjbfile") MultipartFile var3);

    @RequestMapping(value={"/log/his"})
    public ResultBean getLogHis(@RequestParam(name="id") String var1, @RequestParam(name="page") int var2, @RequestParam(name="size") int var3);

    @ApiOperation(value="kettle\u5220\u9664job")
    @DeleteMapping(value={"/detele/job/{jobid}"})
    public ResultBean deleteJob(@PathVariable(name="jobid") Integer var1);

    @ApiOperation(value="kettle\u5220\u9664transformation")
    @DeleteMapping(value={"/detele/tran/{tranid}"})
    public ResultBean deleteTran(@PathVariable(name="tranid") Integer var1);

    @ApiOperation(value="\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2kettle\u4e2d\u7684job\u548ctransformation")
    @GetMapping(value={"/list/search"})
    public ResultBean searchByNameAndTime(@RequestParam(name="keyword") String var1, @RequestParam(name="startdate") String var2, @RequestParam(name="enddate") String var3);

    @Configuration
    public static class FeignSupportConfig {
        @Bean
        public Encoder feignFormEncoder() {
            return new SpringFormEncoder();
        }
    }
}

