/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.common.domain.core;

import java.io.Serializable;
import java.util.List;

public class PageBean<T>
implements Serializable {
    private Integer pageSize;
    private Integer currentPage;
    private Integer totalPage;
    private Integer count;
    private List<T> data;
    private int code = 0;
    private String msg;

    public PageBean() {
    }

    public PageBean(Integer pageNum, Integer pageSize, List<T> sourceList) {
        this.count = sourceList.size();
        this.pageSize = pageSize;
        this.totalPage = (this.count + this.pageSize - 1) / this.pageSize;
        pageNum = pageNum >= 1 ? pageNum : 1;
        this.currentPage = pageNum >= this.totalPage ? this.totalPage : pageNum;
        Integer fromIndex = (this.currentPage - 1) * this.pageSize;
        Integer toIndex = this.pageSize * this.currentPage >= this.count ? this.count : this.pageSize * this.currentPage;
        this.data = sourceList.subList(fromIndex, toIndex);
    }

    public PageBean(Integer currentPage, Integer pageSize, Integer totalRecord, List<T> dataList) {
        this.pageSize = pageSize;
        this.currentPage = currentPage;
        this.totalPage = (totalRecord + pageSize - 1) / pageSize;
        this.count = totalRecord;
        this.data = dataList;
        this.code = 0;
        this.msg = "";
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public Integer getTotalPage() {
        return this.totalPage;
    }

    public Integer getCount() {
        return this.count;
    }

    public List<T> getData() {
        return this.data;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public void setTotalPage(Integer totalPage) {
        this.totalPage = totalPage;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageBean)) {
            return false;
        }
        PageBean other = (PageBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Integer this$currentPage = this.getCurrentPage();
        Integer other$currentPage = other.getCurrentPage();
        if (this$currentPage == null ? other$currentPage != null : !((Object)this$currentPage).equals(other$currentPage)) {
            return false;
        }
        Integer this$totalPage = this.getTotalPage();
        Integer other$totalPage = other.getTotalPage();
        if (this$totalPage == null ? other$totalPage != null : !((Object)this$totalPage).equals(other$totalPage)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Integer $currentPage = this.getCurrentPage();
        result = result * 59 + ($currentPage == null ? 43 : ((Object)$currentPage).hashCode());
        Integer $totalPage = this.getTotalPage();
        result = result * 59 + ($totalPage == null ? 43 : ((Object)$totalPage).hashCode());
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        result = result * 59 + this.getCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }

    public String toString() {
        return "PageBean(pageSize=" + this.getPageSize() + ", currentPage=" + this.getCurrentPage() + ", totalPage=" + this.getTotalPage() + ", count=" + this.getCount() + ", data=" + this.getData() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
    }
}

